/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class SwingWorker<T> {
    private static final Logger LOG = Logger.getInstance(SwingWorker.class);
    private Future<?> myFuture;
    private volatile T value;
    private final ModalityState myModalityState = ModalityState.current();

    protected T getValue() {
        return this.value;
    }

    private void setValue(T x2) {
        this.value = x2;
    }

    public abstract T construct();

    public void finished() {
    }

    public void onThrowable() {
    }

    public void interrupt() {
        this.myFuture.cancel(true);
    }

    public T get() {
        if (this.myFuture == null) {
            throw new IllegalStateException("The start method has not been called.");
        }
        try {
            this.myFuture.get();
            return this.getValue();
        }
        catch (InterruptedException | ExecutionException e2) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public SwingWorker() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created SwingWorker " + this + " with modality state " + this.myModalityState);
        }
    }

    public void start() {
        this.myFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.setValue(this.construct());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("construct() terminated for " + this);
                }
            }
            catch (Throwable e2) {
                LOG.error(e2);
                this.onThrowable();
                throw new RuntimeException(e2);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("invoking 'finished' action for " + this);
            }
            ApplicationManager.getApplication().invokeLater(() -> this.finished(), this.myModalityState);
        });
    }
}

