/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentBitSetImpl;
import com.intellij.util.containers.ConcurrentPackedBitsArray;

class ConcurrentPackedBitsArrayImpl
implements ConcurrentPackedBitsArray {
    private final int bitsPerChunk;
    private final ConcurrentBitSetImpl bits = new ConcurrentBitSetImpl();
    private final int mask;
    private final int chunksPerWord;

    ConcurrentPackedBitsArrayImpl(int bitsPerChunk) {
        if (bitsPerChunk <= 0 || bitsPerChunk > 32) {
            throw new IllegalArgumentException("Bits-to-pack number must be between 1 and 32, but got: " + bitsPerChunk);
        }
        this.bitsPerChunk = bitsPerChunk;
        this.mask = bitsPerChunk == 32 ? -1 : (1 << bitsPerChunk) - 1;
        this.chunksPerWord = 32 / bitsPerChunk;
    }

    @Override
    public long get(int id2) {
        assert (id2 >= 0) : id2;
        int bitIndex = id2 / this.chunksPerWord * 32 + id2 % this.chunksPerWord * this.bitsPerChunk;
        return Integer.toUnsignedLong(this.bits.getWord(bitIndex) >> bitIndex & this.mask);
    }

    @Override
    public long set(int id2, long flags) {
        assert (id2 >= 0) : id2;
        if ((flags & (long)(~this.mask)) != 0L) {
            throw new IllegalArgumentException("Flags must have <= " + this.bitsPerChunk + " bits set, but got: " + Long.toBinaryString(flags));
        }
        int bitIndex = id2 / this.chunksPerWord * 32 + id2 % this.chunksPerWord * this.bitsPerChunk;
        int oldFlags = this.bits.changeWord(bitIndex, word -> word & ~(this.mask << bitIndex) | (int)flags << bitIndex) >> bitIndex;
        return Integer.toUnsignedLong(oldFlags & this.mask);
    }

    @Override
    public void clear() {
        this.bits.clear();
    }
}

