/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileCollectionFactory {
    private static final SerializableHashingStrategy<File> FILE_HASH_STRATEGY = new SerializableHashingStrategy<File>(){

        @Override
        public int hashCode(@Nullable File o2) {
            return FileUtilRt.pathHashCode(o2 == null ? null : o2.getPath());
        }

        @Override
        public boolean equals(@Nullable File a2, @Nullable File b2) {
            return FileUtilRt.pathsEqual(a2 == null ? null : a2.getPath(), b2 == null ? null : b2.getPath());
        }
    };

    @NotNull
    public static <V> Map<Path, V> createCanonicalPathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap(new PathSerializableHashStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap(new Hash.Strategy<String>(){

            @Override
            public int hashCode(@Nullable String value) {
                return FileUtilRt.pathHashCode(value);
            }

            @Override
            public boolean equals(@Nullable String val1, @Nullable String val2) {
                return FileUtilRt.pathsEqual(val1, val2);
            }
        });
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap() {
        return new Object2ObjectOpenCustomHashMap(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(int expected) {
        return new Object2ObjectOpenCustomHashMap(expected, FILE_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(@NotNull Map<? extends File, ? extends V> map2) {
        if (map2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(0);
        }
        Map<File, V> result2 = FileCollectionFactory.createCanonicalFileMap(map2.size());
        result2.putAll(map2);
        Map<File, V> map3 = result2;
        if (map3 == null) {
            FileCollectionFactory.$$$reportNull$$$0(1);
        }
        return map3;
    }

    @NotNull
    public static Set<File> createCanonicalFileSet() {
        return new ObjectOpenCustomHashSet<File>(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createCanonicalFileSet(@NotNull Collection<? extends File> files2) {
        if (files2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(2);
        }
        Set<File> set = FileCollectionFactory.createCanonicalFileSet();
        set.addAll(files2);
        Set<File> set2 = set;
        if (set2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet() {
        return new ObjectOpenCustomHashSet<Path>(new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet(@NotNull Collection<? extends Path> files2) {
        if (files2 == null) {
            FileCollectionFactory.$$$reportNull$$$0(4);
        }
        return new ObjectOpenCustomHashSet<Path>(files2, new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<String> createCanonicalFilePathSet() {
        return new ObjectOpenCustomHashSet<String>(FastUtilHashingStrategies.FILE_PATH_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createCanonicalFileLinkedSet() {
        return new ObjectLinkedOpenCustomHashSet<File>(new Hash.Strategy<File>(){

            @Override
            public int hashCode(@Nullable File o2) {
                return FileUtilRt.pathHashCode(o2 == null ? null : o2.getPath());
            }

            @Override
            public boolean equals(@Nullable File a2, @Nullable File b2) {
                return FileUtilRt.pathsEqual(a2 == null ? null : a2.getPath(), b2 == null ? null : b2.getPath());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FileCollectionFactory";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FileCollectionFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanonicalFileMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanonicalFileSet";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalFileMap";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalFileSet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalPathSet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PathSerializableHashStrategy
    implements FastUtilHashingStrategies.SerializableHashStrategy<Path> {
        private PathSerializableHashStrategy() {
        }

        @Override
        public int hashCode(@Nullable Path o2) {
            return FileUtilRt.pathHashCode(o2 == null ? null : o2.toString());
        }

        @Override
        public boolean equals(@Nullable Path a2, @Nullable Path b2) {
            return FileUtilRt.pathsEqual(a2 == null ? null : a2.toString(), b2 == null ? null : b2.toString());
        }
    }

    private static interface SerializableHashingStrategy<T>
    extends Hash.Strategy<T>,
    Serializable {
    }
}

