/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class Unsafe {
    private static final MethodHandle putObjectVolatile;
    private static final MethodHandle getObjectVolatile;
    private static final MethodHandle compareAndSwapObject;
    private static final MethodHandle compareAndSwapInt;
    private static final MethodHandle compareAndSwapLong;
    private static final MethodHandle getAndAddInt;
    private static final MethodHandle objectFieldOffset;
    private static final MethodHandle arrayIndexScale;
    private static final MethodHandle arrayBaseOffset;
    private static final MethodHandle copyMemory;

    @NotNull
    private static MethodHandle find(String name2, Class<?> returnType, Class<?> ... params) throws Exception {
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        Object unsafe = ReflectionUtil.getUnsafe();
        MethodHandle methodHandle = publicLookup.findVirtual(unsafe.getClass(), name2, MethodType.methodType(returnType, params)).bindTo(unsafe);
        if (methodHandle == null) {
            Unsafe.$$$reportNull$$$0(0);
        }
        return methodHandle;
    }

    public static boolean compareAndSwapInt(Object object, long offset, int expected, int value) {
        try {
            return compareAndSwapInt.invokeExact(object, offset, expected, value);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compareAndSwapLong(@NotNull Object object, long offset, long expected, long l2) {
        if (object == null) {
            Unsafe.$$$reportNull$$$0(1);
        }
        try {
            void value;
            return compareAndSwapLong.invokeExact(object, offset, expected, (long)value);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static int getAndAddInt(Object object, long offset, int v2) {
        try {
            return getAndAddInt.invokeExact(object, offset, v2);
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
    }

    public static Object getObjectVolatile(Object object, long offset) {
        try {
            return getObjectVolatile.invokeExact(object, offset);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static boolean compareAndSwapObject(Object o2, long offset, Object expected, Object x2) {
        try {
            return compareAndSwapObject.invokeExact(o2, offset, expected, x2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void putObjectVolatile(Object o2, long offset, Object x2) {
        try {
            putObjectVolatile.invokeExact(o2, offset, x2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static long objectFieldOffset(Field f2) {
        try {
            return objectFieldOffset.invokeExact(f2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static int arrayIndexScale(Class<?> arrayClass) {
        try {
            return arrayIndexScale.invokeExact(arrayClass);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static int arrayBaseOffset(Class<?> arrayClass) {
        try {
            return arrayBaseOffset.invokeExact(arrayClass);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void copyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes2) {
        try {
            copyMemory.invokeExact(srcBase, srcOffset, destBase, destOffset, bytes2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        try {
            putObjectVolatile = Unsafe.find("putObjectVolatile", Void.TYPE, Object.class, Long.TYPE, Object.class);
            getObjectVolatile = Unsafe.find("getObjectVolatile", Object.class, Object.class, Long.TYPE);
            compareAndSwapObject = Unsafe.find("compareAndSwapObject", Boolean.TYPE, Object.class, Long.TYPE, Object.class, Object.class);
            compareAndSwapInt = Unsafe.find("compareAndSwapInt", Boolean.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
            compareAndSwapLong = Unsafe.find("compareAndSwapLong", Boolean.TYPE, Object.class, Long.TYPE, Long.TYPE, Long.TYPE);
            getAndAddInt = Unsafe.find("getAndAddInt", Integer.TYPE, Object.class, Long.TYPE, Integer.TYPE);
            objectFieldOffset = Unsafe.find("objectFieldOffset", Long.TYPE, Field.class);
            arrayBaseOffset = Unsafe.find("arrayBaseOffset", Integer.TYPE, Class.class);
            arrayIndexScale = Unsafe.find("arrayIndexScale", Integer.TYPE, Class.class);
            copyMemory = Unsafe.find("copyMemory", Void.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable t2) {
            throw new Error(t2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/Unsafe";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/Unsafe";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSwapLong";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

