/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.hash;

import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.HashUtil;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Deprecated
public class LinkedHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Entry<K, V>[] table;
    private Entry<K, V> top;
    private Entry<K, V> back;
    private int capacity;
    private int size;
    private final float loadFactor;
    private final EqualityPolicy<? super K> hashingStrategy;
    private final boolean accessOrder;

    @TestOnly
    public LinkedHashMap() {
        this(0, 1.0f, EqualityPolicy.CANONICAL, false);
    }

    @TestOnly
    public LinkedHashMap(int capacity, boolean accessOrder) {
        this(capacity, 1.0f, EqualityPolicy.CANONICAL, accessOrder);
    }

    public LinkedHashMap(@NotNull EqualityPolicy<? super K> hashingStrategy2) {
        if (hashingStrategy2 == null) {
            LinkedHashMap.$$$reportNull$$$0(0);
        }
        this(0, 1.0f, hashingStrategy2, false);
    }

    public LinkedHashMap(int capacity, float loadFactor, @NotNull EqualityPolicy<? super K> hashingStrategy2, boolean accessOrder) {
        if (hashingStrategy2 == null) {
            LinkedHashMap.$$$reportNull$$$0(1);
        }
        this.loadFactor = loadFactor;
        this.hashingStrategy = hashingStrategy2;
        this.accessOrder = accessOrder;
        this.clear(capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.clear(0);
    }

    @Override
    public V get(Object key) {
        Entry<K, V>[] table = this.table;
        int hash = this.hashKey(key);
        int index2 = hash % table.length;
        Entry e2 = table[index2];
        while (e2 != null) {
            Object entryKey;
            if (e2.keyHash == hash && ((entryKey = e2.key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
                this.moveToTop(e2);
                return (V)e2.value;
            }
            e2 = e2.hashNext;
        }
        return null;
    }

    private int hashKey(K key) {
        return key == null ? 0 : this.hashingStrategy.getHashCode(key) & Integer.MAX_VALUE;
    }

    @Override
    public V put(K key, @NotNull V value) {
        if (value == null) {
            LinkedHashMap.$$$reportNull$$$0(2);
        }
        Entry<K, V>[] table = this.table;
        int hash = this.hashKey(key);
        int index2 = hash % table.length;
        Entry<K, V> e2 = table[index2];
        while (e2 != null) {
            Object entryKey;
            if (((Entry)e2).keyHash == hash && ((entryKey = ((Entry)e2).key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
                this.moveToTop(e2);
                return e2.setValue(value);
            }
            e2 = ((Entry)e2).hashNext;
        }
        e2 = new Entry<K, V>(key, value, hash);
        ((Entry)e2).hashNext = (Entry)table[index2];
        table[index2] = e2;
        Entry<K, V> top = this.top;
        ((Entry)e2).next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = (Entry)e2;
        } else {
            this.back = e2;
        }
        this.top = e2;
        ++this.size;
        if (this.removeEldestEntry(this.back, ((Entry)this.back).key, ((Entry)this.back).value)) {
            this.doRemoveEldestEntry();
        } else if (this.size > this.capacity) {
            this.rehash((int)((float)this.capacity * 1.618034f));
        }
        return null;
    }

    public void doRemoveEldestEntry() {
        V val = this.remove(((Entry)this.back).key);
        assert (val != null) : "LinkedHashMap.Entry was not removed. Possibly mutable key: " + Entry.access$200(this.back);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V remove(Object key) {
        Object entryKey;
        Entry<K, V>[] table = this.table;
        int hash = this.hashKey(key);
        int index2 = hash % table.length;
        Entry e2 = table[index2];
        if (e2 == null) {
            return null;
        }
        if (e2.keyHash == hash && ((entryKey = e2.key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
            table[index2] = e2.hashNext;
        } else {
            Entry last2;
            do {
                last2 = e2;
                if ((e2 = e2.hashNext) != null) continue;
                return null;
            } while (e2.keyHash != hash || (entryKey = e2.key) != key && !this.hashingStrategy.isEqual(entryKey, key));
            last2.hashNext = e2.hashNext;
        }
        this.unlink(e2);
        --this.size;
        return (V)e2.value;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new Values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
        return this.removeEldestEntry(eldest);
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    private void init(int capacity) {
        this.table = new Entry[HashUtil.adjustTableSize((int)((float)capacity / this.loadFactor))];
        this.back = null;
        this.top = null;
        this.capacity = capacity;
    }

    private void clear(int capacity) {
        if (capacity < 5) {
            capacity = 5;
        }
        this.init(capacity);
        this.size = 0;
    }

    @Nullable
    public K getLastKey() {
        return (K)(this.top != null ? ((Entry)this.top).key : null);
    }

    @Nullable
    public V getLastValue() {
        return (V)(this.top != null ? ((Entry)this.top).value : null);
    }

    @Nullable
    public K getFirstKey() {
        return (K)(this.back != null ? ((Entry)this.back).key : null);
    }

    private void moveToTop(Entry<K, V> e2) {
        if (!this.accessOrder) {
            return;
        }
        Entry<K, V> top = this.top;
        if (top != e2) {
            Entry prev = ((Entry)e2).previous;
            Entry next = ((Entry)e2).next;
            prev.next = next;
            if (next != null) {
                next.previous = prev;
            } else {
                this.back = prev;
            }
            ((Entry)top).previous = (Entry)e2;
            ((Entry)e2).next = (Entry)top;
            ((Entry)e2).previous = null;
            this.top = e2;
        }
    }

    private void unlink(Entry<K, V> e2) {
        Entry prev = ((Entry)e2).previous;
        Entry next = ((Entry)e2).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)e2).previous = null;
        ((Entry)e2).next = null;
    }

    private void rehash(int capacity) {
        this.table = new Entry[HashUtil.adjustTableSize((int)((float)capacity / this.loadFactor))];
        this.capacity = capacity;
        Entry<K, V>[] table = this.table;
        int tableLen = table.length;
        Entry e2 = this.back;
        while (e2 != null) {
            int hash = e2.keyHash % tableLen;
            e2.hashNext = (Entry)table[hash];
            table[hash] = e2;
            e2 = e2.previous;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/hash/LinkedHashMap";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final int keyHash;
        private V value;
        private Entry<K, V> next;
        private Entry<K, V> previous;
        private Entry<K, V> hashNext;

        Entry(K key, V value, int hash) {
            this.key = key;
            this.keyHash = hash;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result2 = this.value;
            this.value = value;
            return result2;
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return new LinkedHashIterator<K>(){

                @Override
                public K next() {
                    return this.nextEntry().key;
                }
            };
        }

        @Override
        public int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            return LinkedHashMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            return LinkedHashMap.this.remove(o2) != null;
        }

        @Override
        public void clear() {
            LinkedHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return new LinkedHashIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().value;
                }
            };
        }

        @Override
        public int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            return LinkedHashMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            LinkedHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedHashIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object value = LinkedHashMap.this.get(e2.getKey());
            return value != null && value.equals(e2.getValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return LinkedHashMap.this.remove(e2.getKey()) != null;
        }

        @Override
        public int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public void clear() {
            LinkedHashMap.this.clear();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        private Entry<K, V> e;
        private Entry<K, V> last;

        private LinkedHashIterator() {
            this.e = LinkedHashMap.this.back;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<K, V> nextEntry() {
            this.last = this.e;
            Entry result2 = this.last;
            this.e = result2.previous;
            return result2;
        }
    }
}

