/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.prefix.set;

import com.intellij.util.containers.prefix.factory.PrefixTreeFactory;
import com.intellij.util.containers.prefix.map.MutablePrefixTreeMap;
import com.intellij.util.containers.prefix.set.MutablePrefixTreeSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0096\u0002J\u0015\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/util/containers/prefix/set/PrefixTreeSetImpl;", "Key", "KeyElement", "Lcom/intellij/util/containers/prefix/set/MutablePrefixTreeSet;", "convertor", "Lcom/intellij/util/containers/prefix/factory/PrefixTreeFactory;", "(Lcom/intellij/util/containers/prefix/factory/PrefixTreeFactory;)V", "map", "Lcom/intellij/util/containers/prefix/map/MutablePrefixTreeMap;", "", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)V", "contains", "", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "getAncestors", "", "(Ljava/lang/Object;)Ljava/util/Set;", "getDescendants", "getRoots", "isEmpty", "iterator", "", "remove", "intellij.platform.util.base"})
@ApiStatus.Internal
public final class PrefixTreeSetImpl<Key, KeyElement>
implements MutablePrefixTreeSet<Key> {
    @NotNull
    private final MutablePrefixTreeMap map;

    public PrefixTreeSetImpl(@NotNull PrefixTreeFactory<Key, KeyElement> convertor) {
        Intrinsics.checkNotNullParameter(convertor, "convertor");
        this.map = convertor.createMap(new Pair[0]);
    }

    public int getSize() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return ((Map)this.map).containsKey(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.map.keySet().containsAll(elements);
    }

    @Override
    @NotNull
    public Set<Key> getDescendants(Key element) {
        return this.map.getDescendantKeys(element);
    }

    @Override
    @NotNull
    public Set<Key> getAncestors(Key element) {
        return this.map.getAncestorKeys(element);
    }

    @Override
    @NotNull
    public Set<Key> getRoots() {
        return this.map.getRootKeys();
    }

    @Override
    public void add(Key element) {
        this.map.set(element, null);
    }

    @Override
    public void remove(Key element) {
        this.map.remove(element);
    }

    @Override
    @NotNull
    public Iterator<Key> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean add(Key element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Key> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        Intrinsics.checkNotNullParameter(array2, "array");
        return CollectionToArray.toArray(this, array2);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }
}

