/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.LCSBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.jetbrains.annotations.TestOnly;

final class Reindexer {
    private final int[][] myOldIndices = new int[2][];
    private final int[] myOriginalLengths = new int[]{-1, -1};
    private final int[] myDiscardedLengths = new int[]{-1, -1};

    Reindexer() {
    }

    public int[][] discardUnique(int[] ints1, int[] ints2) {
        int[] discarded1 = this.discard(ints2, ints1, 0);
        return new int[][]{discarded1, this.discard(discarded1, ints2, 1)};
    }

    @TestOnly
    void idInit(int length1, int length2) {
        this.myOriginalLengths[0] = length1;
        this.myOriginalLengths[1] = length2;
        this.myDiscardedLengths[0] = length1;
        this.myDiscardedLengths[1] = length2;
        for (int j2 = 0; j2 < 2; ++j2) {
            int originalLength = this.myOriginalLengths[j2];
            this.myOldIndices[j2] = new int[originalLength];
            for (int i2 = 0; i2 < originalLength; ++i2) {
                this.myOldIndices[j2][i2] = i2;
            }
        }
    }

    @TestOnly
    int restoreIndex(int index2, int array2) {
        return this.myOldIndices[array2][index2];
    }

    private int[] discard(int[] needed, int[] toDiscard, int arrayIndex) {
        this.myOriginalLengths[arrayIndex] = toDiscard.length;
        int[] sorted1 = Reindexer.createSorted(needed);
        IntArrayList discarded = new IntArrayList(toDiscard.length);
        IntArrayList oldIndices = new IntArrayList(toDiscard.length);
        for (int i2 = 0; i2 < toDiscard.length; ++i2) {
            int index2 = toDiscard[i2];
            if (Arrays.binarySearch(sorted1, index2) < 0) continue;
            discarded.add(index2);
            oldIndices.add(i2);
        }
        this.myOldIndices[arrayIndex] = oldIndices.toIntArray();
        this.myDiscardedLengths[arrayIndex] = discarded.size();
        return discarded.toIntArray();
    }

    private static int[] createSorted(int[] ints1) {
        int[] sorted1 = (int[])ints1.clone();
        Arrays.sort(sorted1);
        return sorted1;
    }

    public void reindex(BitSet[] discardedChanges, LCSBuilder builder) {
        int y2;
        int x2;
        BitSet changes2;
        BitSet changes1;
        if (this.myDiscardedLengths[0] == this.myOriginalLengths[0] && this.myDiscardedLengths[1] == this.myOriginalLengths[1]) {
            changes1 = discardedChanges[0];
            changes2 = discardedChanges[1];
        } else {
            changes1 = new BitSet(this.myOriginalLengths[0]);
            changes2 = new BitSet(this.myOriginalLengths[1]);
            x2 = 0;
            y2 = 0;
            while (x2 < this.myDiscardedLengths[0] || y2 < this.myDiscardedLengths[1]) {
                if (x2 < this.myDiscardedLengths[0] && y2 < this.myDiscardedLengths[1] && !discardedChanges[0].get(x2) && !discardedChanges[1].get(y2)) {
                    x2 = Reindexer.increment(this.myOldIndices[0], x2, changes1, this.myOriginalLengths[0]);
                    y2 = Reindexer.increment(this.myOldIndices[1], y2, changes2, this.myOriginalLengths[1]);
                    continue;
                }
                if (discardedChanges[0].get(x2)) {
                    changes1.set(Reindexer.getOriginal(this.myOldIndices[0], x2));
                    x2 = Reindexer.increment(this.myOldIndices[0], x2, changes1, this.myOriginalLengths[0]);
                    continue;
                }
                if (!discardedChanges[1].get(y2)) continue;
                changes2.set(Reindexer.getOriginal(this.myOldIndices[1], y2));
                y2 = Reindexer.increment(this.myOldIndices[1], y2, changes2, this.myOriginalLengths[1]);
            }
            if (this.myDiscardedLengths[0] == 0) {
                changes1.set(0, this.myOriginalLengths[0]);
            } else {
                changes1.set(0, this.myOldIndices[0][0]);
            }
            if (this.myDiscardedLengths[1] == 0) {
                changes2.set(0, this.myOriginalLengths[1]);
            } else {
                changes2.set(0, this.myOldIndices[1][0]);
            }
        }
        x2 = 0;
        y2 = 0;
        while (x2 < this.myOriginalLengths[0] && y2 < this.myOriginalLengths[1]) {
            int startX = x2;
            while (x2 < this.myOriginalLengths[0] && y2 < this.myOriginalLengths[1] && !changes1.get(x2) && !changes2.get(y2)) {
                ++x2;
                ++y2;
            }
            if (x2 > startX) {
                builder.addEqual(x2 - startX);
            }
            int dx = 0;
            int dy = 0;
            while (x2 < this.myOriginalLengths[0] && changes1.get(x2)) {
                ++dx;
                ++x2;
            }
            while (y2 < this.myOriginalLengths[1] && changes2.get(y2)) {
                ++dy;
                ++y2;
            }
            if (dx == 0 && dy == 0) continue;
            builder.addChange(dx, dy);
        }
        if (x2 != this.myOriginalLengths[0] || y2 != this.myOriginalLengths[1]) {
            builder.addChange(this.myOriginalLengths[0] - x2, this.myOriginalLengths[1] - y2);
        }
    }

    private static int getOriginal(int[] indexes, int i2) {
        return indexes[i2];
    }

    private static int increment(int[] indexes, int i2, BitSet set, int length) {
        if (i2 + 1 < indexes.length) {
            set.set(indexes[i2] + 1, indexes[i2 + 1]);
        } else {
            set.set(indexes[i2] + 1, length);
        }
        return i2 + 1;
    }
}

