/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.graph.ElementOrder;
import com.intellij.util.graph.EndpointPair;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.MutableNetwork;
import com.intellij.util.graph.Network;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphAdapter {
    private GraphAdapter() {
    }

    public static <N> EndpointPair<N> wrapEndpointsPair(com.google.common.graph.EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return EndpointPair.ordered(endpoints.source(), endpoints.target());
        }
        return EndpointPair.unordered(endpoints.nodeU(), endpoints.nodeV());
    }

    public static <N> com.google.common.graph.EndpointPair<N> unwrapEndpointsPair(EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return com.google.common.graph.EndpointPair.ordered(endpoints.source(), endpoints.target());
        }
        return com.google.common.graph.EndpointPair.unordered(endpoints.nodeU(), endpoints.nodeV());
    }

    public static <T> ElementOrder<T> wrapOrder(com.google.common.graph.ElementOrder<T> order) {
        switch (order.type()) {
            case STABLE: {
                return ElementOrder.stable();
            }
            case INSERTION: {
                return ElementOrder.insertion();
            }
            case SORTED: {
                return ElementOrder.sorted(order.comparator());
            }
        }
        return ElementOrder.unordered();
    }

    public static <T> com.google.common.graph.ElementOrder<T> unwrapOrder(ElementOrder<T> order) {
        switch (order.type()) {
            case STABLE: {
                return com.google.common.graph.ElementOrder.stable();
            }
            case INSERTION: {
                return com.google.common.graph.ElementOrder.insertion();
            }
            case SORTED: {
                return com.google.common.graph.ElementOrder.sorted(order.comparator());
            }
        }
        return com.google.common.graph.ElementOrder.unordered();
    }

    public static <N, E> MutableNetwork<N, E> wrapNetwork(com.google.common.graph.MutableNetwork<N, E> delegate2) {
        return new MyMutableNetworkWrapper(delegate2);
    }

    public static <N, E> @NotNull com.google.common.graph.MutableNetwork<N, E> unwrapNetwork(@NotNull Network<N, E> network) {
        if (network == null) {
            GraphAdapter.$$$reportNull$$$0(0);
        }
        com.google.common.graph.MutableNetwork mutableNetwork = ((MyMutableNetworkWrapper)network).getDelegate();
        if (mutableNetwork == null) {
            GraphAdapter.$$$reportNull$$$0(1);
        }
        return mutableNetwork;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "network";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/graph/impl/GraphAdapter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/graph/impl/GraphAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapNetwork";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrapNetwork";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyMutableNetworkWrapper<N, E>
    implements MutableNetwork<N, E> {
        @NotNull
        private final com.google.common.graph.MutableNetwork<N, E> myDelegate;

        private MyMutableNetworkWrapper(@NotNull com.google.common.graph.MutableNetwork<N, E> delegate2) {
            if (delegate2 == null) {
                MyMutableNetworkWrapper.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate2;
        }

        @NotNull
        com.google.common.graph.MutableNetwork<N, E> getDelegate() {
            com.google.common.graph.MutableNetwork<N, E> mutableNetwork = this.myDelegate;
            if (mutableNetwork == null) {
                MyMutableNetworkWrapper.$$$reportNull$$$0(1);
            }
            return mutableNetwork;
        }

        @Override
        public boolean addNode(N n2) {
            return this.myDelegate.addNode(n2);
        }

        @Override
        public boolean addEdge(N n2, N n1, E e2) {
            return this.myDelegate.addEdge(n2, n1, e2);
        }

        @Override
        public boolean addEdge(EndpointPair<N> endpoints, E edge) {
            return this.myDelegate.addEdge(GraphAdapter.unwrapEndpointsPair(endpoints), edge);
        }

        @Override
        public boolean removeNode(N n2) {
            return this.myDelegate.removeNode(n2);
        }

        @Override
        public boolean removeEdge(E e2) {
            return this.myDelegate.removeEdge(e2);
        }

        @Override
        public Set<N> nodes() {
            return this.myDelegate.nodes();
        }

        @Override
        public Set<E> edges() {
            return this.myDelegate.edges();
        }

        @Override
        public Graph<N> asGraph() {
            return new Graph<N>(){

                @Override
                @NotNull
                public Collection<N> getNodes() {
                    Set set = this.nodes();
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                @Override
                @NotNull
                public Iterator<N> getIn(N n2) {
                    Iterator iterator2 = this.predecessors(n2).iterator();
                    if (iterator2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return iterator2;
                }

                @Override
                @NotNull
                public Iterator<N> getOut(N n2) {
                    Iterator iterator2 = this.successors(n2).iterator();
                    if (iterator2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return iterator2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/graph/impl/GraphAdapter$MyMutableNetworkWrapper$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNodes";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIn";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getOut";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        @Override
        public boolean isDirected() {
            return this.myDelegate.isDirected();
        }

        @Override
        public boolean allowsParallelEdges() {
            return this.myDelegate.allowsParallelEdges();
        }

        @Override
        public boolean allowsSelfLoops() {
            return this.myDelegate.allowsSelfLoops();
        }

        @Override
        public ElementOrder<N> nodeOrder() {
            return GraphAdapter.wrapOrder(this.myDelegate.nodeOrder());
        }

        @Override
        public ElementOrder<E> edgeOrder() {
            return GraphAdapter.wrapOrder(this.myDelegate.edgeOrder());
        }

        @Override
        public Set<N> adjacentNodes(N n2) {
            return this.myDelegate.adjacentNodes(n2);
        }

        @Override
        public Set<N> predecessors(N n2) {
            return this.myDelegate.predecessors((Object)n2);
        }

        @Override
        public Set<N> successors(N n2) {
            return this.myDelegate.successors((Object)n2);
        }

        @Override
        public Set<E> incidentEdges(N n2) {
            return this.myDelegate.incidentEdges(n2);
        }

        @Override
        public Set<E> inEdges(N n2) {
            return this.myDelegate.inEdges(n2);
        }

        @Override
        public Set<E> outEdges(N n2) {
            return this.myDelegate.outEdges(n2);
        }

        @Override
        public int degree(N n2) {
            return this.myDelegate.degree(n2);
        }

        @Override
        public int inDegree(N n2) {
            return this.myDelegate.inDegree(n2);
        }

        @Override
        public int outDegree(N n2) {
            return this.myDelegate.outDegree(n2);
        }

        @Override
        public EndpointPair<N> incidentNodes(E e2) {
            return GraphAdapter.wrapEndpointsPair(this.myDelegate.incidentNodes(e2));
        }

        @Override
        public Set<E> adjacentEdges(E e2) {
            return this.myDelegate.adjacentEdges(e2);
        }

        @Override
        public Set<E> edgesConnecting(N n2, N n1) {
            return this.myDelegate.edgesConnecting(n2, n1);
        }

        @Override
        public Optional<E> edgeConnecting(N n2, N n1) {
            return this.myDelegate.edgeConnecting(n2, n1);
        }

        @Override
        public E edgeConnectingOrNull(N n2, N n1) {
            return this.myDelegate.edgeConnectingOrNull(n2, n1);
        }

        @Override
        public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
            return this.myDelegate.edgesConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
        }

        @Override
        public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
            return this.myDelegate.edgeConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
        }

        @Override
        @Nullable
        public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
            return this.myDelegate.edgeConnectingOrNull(GraphAdapter.unwrapEndpointsPair(endpoints));
        }

        @Override
        public boolean hasEdgeConnecting(N n2, N n1) {
            return this.myDelegate.hasEdgeConnecting(n2, n1);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.myDelegate.hasEdgeConnecting(GraphAdapter.unwrapEndpointsPair(endpoints));
        }

        @Override
        public boolean equals(@Nullable Object o2) {
            return this.myDelegate.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/graph/impl/GraphAdapter$MyMutableNetworkWrapper";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/graph/impl/GraphAdapter$MyMutableNetworkWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

