/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.Java11Shim;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final Logger LOG = Logger.getInstance(ID.class);
    private static final PluginId CORE_PLUGIN_ID = PluginId.getId("com.intellij");
    private static volatile SimpleStringPersistentEnumerator nameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
    private static final Map<String, ID<?, ?>> idObjects = new ConcurrentHashMap();
    private static final Object lock = new Object();
    private static volatile Map<@NotNull ID<?, ?>, @NotNull PluginId> idToPluginId = Java11Shim.INSTANCE.mapOf();
    private static volatile Map<@NotNull ID<?, ?>, @NotNull Throwable> idToRegistrationStackTrace = Java11Shim.INSTANCE.mapOf();
    static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private volatile int uniqueId;

    @ApiStatus.Internal
    @NotNull
    private static Path getEnumFile() {
        Path path = PathManager.getIndexRoot().resolve("indices.enum");
        if (path == null) {
            ID.$$$reportNull$$$0(0);
        }
        return path;
    }

    @ApiStatus.Internal
    public static void reloadEnumFile() {
        ID.reloadEnumFile(ID.getEnumFile());
    }

    private static void reloadEnumFile(@NotNull Path enumFile) {
        if (enumFile == null) {
            ID.$$$reportNull$$$0(1);
        }
        if (Files.exists(enumFile, new LinkOption[0]) && enumFile.equals(nameToIdRegistry.getFile())) {
            return;
        }
        SimpleStringPersistentEnumerator newNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
        Map<String, Integer> newInvertedState = newNameToIdRegistry.getInvertedState();
        Map<String, Integer> oldInvertedState = nameToIdRegistry.getInvertedState();
        oldInvertedState.forEach((oldKey, oldId) -> {
            Integer newId = (Integer)newInvertedState.get(oldKey);
            if (newId == null) {
                int createdId = newNameToIdRegistry.enumerate((String)oldKey);
                if (createdId != oldId) {
                    ID.reassign(oldKey, createdId);
                }
            } else if (oldId.intValue() != newId.intValue()) {
                ID.reassign(oldKey, newId);
            }
        });
        nameToIdRegistry = newNameToIdRegistry;
    }

    private static void reassign(String name2, int newId) {
        ID<?, ?> id2 = idObjects.get(name2);
        if (id2 != null) {
            id2.uniqueId = newId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected ID(@NotNull String name2, @Nullable PluginId pluginId) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(2);
        }
        super(name2);
        this.uniqueId = ID.stringToId(name2);
        ID old = idObjects.put(name2, this);
        assert (old == null) : "ID with name '" + name2 + "' is already registered";
        Object object = lock;
        synchronized (object) {
            PluginId oldPluginId = idToPluginId.get(this);
            assert (oldPluginId == null) : "ID with name '" + name2 + "' is already registered in " + oldPluginId + " but current caller is " + pluginId;
            idToPluginId = UtilKt.with(idToPluginId, this, pluginId == null ? CORE_PLUGIN_ID : pluginId);
            idToRegistrationStackTrace = UtilKt.with(idToRegistrationStackTrace, this, new Throwable());
        }
    }

    private static int stringToId(@NotNull String name2) {
        int id2;
        if (name2 == null) {
            ID.$$$reportNull$$$0(3);
        }
        if ((id2 = nameToIdRegistry.enumerate(name2)) != (short)id2) {
            throw new AssertionError((Object)"Too many indexes registered");
        }
        return id2;
    }

    static void reinitializeDiskStorage() {
        nameToIdRegistry.forceDiskSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static <K, V> ID<K, V> create(@NonNls @NotNull String name2) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(4);
        }
        PluginId pluginId = ID.getCallerPluginId();
        Object object = lock;
        // MONITORENTER : object
        ID<K, V> found = ID.findByName(name2, true, pluginId);
        ID<K, V> iD = found == null ? new ID<K, V>(name2, pluginId) : found;
        // MONITOREXIT : object
        if (iD != null) return iD;
        ID.$$$reportNull$$$0(5);
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name2) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(6);
        }
        return ID.findByName(name2, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected static <K, V> ID<K, V> findByName(@NotNull String name2, boolean checkCallerPlugin, @Nullable PluginId requiredPluginId) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(7);
        }
        ID<?, ?> id2 = ID.findById(ID.stringToId(name2));
        if (checkCallerPlugin && id2 != null) {
            String requiredPluginIdStr;
            PluginId actualPluginId = idToPluginId.get(id2);
            String actualPluginIdStr = actualPluginId == null ? "" : actualPluginId.getIdString();
            String string2 = requiredPluginIdStr = requiredPluginId == null ? "" : requiredPluginId.getIdString();
            if (!Objects.equals(actualPluginIdStr, requiredPluginIdStr)) {
                Throwable registrationStackTrace = idToRegistrationStackTrace.get(id2);
                String message2 = ID.getInvalidIdAccessMessage(name2, actualPluginIdStr, requiredPluginIdStr, registrationStackTrace);
                if (registrationStackTrace == null) {
                    throw new AssertionError((Object)message2);
                }
                throw new AssertionError(message2, registrationStackTrace);
            }
        }
        return id2;
    }

    @NotNull
    private static String getInvalidIdAccessMessage(@NotNull String name2, @Nullable String actualPluginIdStr, @Nullable String requiredPluginIdStr, @Nullable Throwable registrationStackTrace) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(8);
        }
        String string2 = "ID with name '" + name2 + "' requested for plugin " + requiredPluginIdStr + " but registered for " + actualPluginIdStr + " plugin. Please use an instance field to access corresponding ID." + (registrationStackTrace == null ? " Registration stack trace: " : "");
        if (string2 == null) {
            ID.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @ApiStatus.Internal
    public static Collection<ID<?, ?>> getRegisteredIds() {
        return idToPluginId.keySet();
    }

    @ApiStatus.Internal
    @NotNull
    public Throwable getRegistrationTrace() {
        Throwable throwable = idToRegistrationStackTrace.get(this);
        if (throwable == null) {
            ID.$$$reportNull$$$0(10);
        }
        return throwable;
    }

    @ApiStatus.Internal
    public int getUniqueId() {
        return this.uniqueId;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginId getPluginId() {
        return idToPluginId.get(this);
    }

    @ApiStatus.Internal
    public static ID<?, ?> findById(int id2) {
        String key = nameToIdRegistry.valueOf(id2);
        return key == null ? null : idObjects.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void unloadId(@NotNull ID<?, ?> id2) {
        if (id2 == null) {
            ID.$$$reportNull$$$0(11);
        }
        String name2 = id2.getName();
        Object object = lock;
        synchronized (object) {
            ID<?, ?> oldID = idObjects.remove(name2);
            LOG.assertTrue(id2.equals(oldID), "Failed to unload: " + name2);
            idToPluginId = UtilKt.without(idToPluginId, id2);
            idToRegistrationStackTrace = UtilKt.without(idToRegistrationStackTrace, id2);
        }
    }

    @ApiStatus.Internal
    @Nullable
    protected static PluginId getCallerPluginId() {
        Class<?> aClass = Java11Shim.INSTANCE.getCallerClass(3);
        if (aClass == null) {
            return null;
        }
        ClassLoader loader2 = aClass.getClassLoader();
        if (!(loader2 instanceof PluginAwareClassLoader)) {
            return null;
        }
        return ((PluginAwareClassLoader)((Object)loader2)).getPluginId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/ID";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIdAccessMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationTrace";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reloadEnumFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stringToId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidIdAccessMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unloadId";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

