/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.IOCancellationCallbackHolder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.ints.q;
import java.util.Collection;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InvertedIndexUtil {
    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAllKeys(@NotNull InvertedIndex<? super K, V, I> index2, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker) throws StorageException {
        if (index2 == null) {
            InvertedIndexUtil.$$$reportNull$$$0(0);
        }
        if (dataKeys == null) {
            InvertedIndexUtil.$$$reportNull$$$0(1);
        }
        IntOpenHashSet mainIntersection = null;
        for (K dataKey : dataKeys) {
            IOCancellationCallbackHolder.checkCancelled();
            IntOpenHashSet copy2 = new IntOpenHashSet();
            ValueContainer<V> container = index2.getData(dataKey);
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                IntPredicate predicate;
                Object value = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value)) continue;
                IOCancellationCallbackHolder.checkCancelled();
                ValueContainer.IntIterator iterator2 = valueIt.getInputIdsIterator();
                if (mainIntersection == null || iterator2.size() < mainIntersection.size() || (predicate = valueIt.getValueAssociationPredicate()) == null) {
                    while (iterator2.hasNext()) {
                        int id2 = iterator2.next();
                        if ((mainIntersection != null || idChecker != null && !idChecker.test(id2)) && (mainIntersection == null || !mainIntersection.contains(id2))) continue;
                        copy2.add(id2);
                    }
                    continue;
                }
                IntIterator intIterator = mainIntersection.iterator();
                while (intIterator.hasNext()) {
                    int id3 = intIterator.nextInt();
                    if (!predicate.test(id3) || idChecker != null && !idChecker.test(id3)) continue;
                    copy2.add(id3);
                }
            }
            mainIntersection = copy2;
            if (!mainIntersection.isEmpty()) continue;
            IntSets.EmptySet emptySet = IntSets.EMPTY_SET;
            if (emptySet == null) {
                InvertedIndexUtil.$$$reportNull$$$0(2);
            }
            return emptySet;
        }
        q q2 = mainIntersection == null ? IntSets.EMPTY_SET : mainIntersection;
        if (q2 == null) {
            InvertedIndexUtil.$$$reportNull$$$0(3);
        }
        return q2;
    }

    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAnyKey(@NotNull InvertedIndex<? super K, V, I> index2, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker) throws StorageException {
        if (index2 == null) {
            InvertedIndexUtil.$$$reportNull$$$0(4);
        }
        if (dataKeys == null) {
            InvertedIndexUtil.$$$reportNull$$$0(5);
        }
        IntCollection result2 = null;
        for (K dataKey : dataKeys) {
            IOCancellationCallbackHolder.checkCancelled();
            ValueContainer<V> container = index2.getData(dataKey);
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value)) continue;
                IOCancellationCallbackHolder.checkCancelled();
                ValueContainer.IntIterator iterator2 = valueIt.getInputIdsIterator();
                while (iterator2.hasNext()) {
                    int id2 = iterator2.next();
                    if (idChecker != null && !idChecker.test(id2)) continue;
                    if (result2 == null) {
                        result2 = new IntOpenHashSet();
                    }
                    result2.add(id2);
                }
            }
        }
        IntCollection intCollection = result2 == null ? IntSets.EMPTY_SET : result2;
        if (intCollection == null) {
            InvertedIndexUtil.$$$reportNull$$$0(6);
        }
        return intCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/InvertedIndexUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/InvertedIndexUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInputIdsContainingAllKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInputIdsContainingAnyKey";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInputIdsContainingAllKeys";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInputIdsContainingAnyKey";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

