/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ZipUtilsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"addEntry", "", "Ljava/util/zip/ZipOutputStream;", "entryName", "", "operation", "Lkotlin/Function0;", "addFile", "byteArray", "", "addFolder", "folder", "Ljava/nio/file/Path;", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nZipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtils.kt\ncom/intellij/util/io/ZipUtilsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,41:1\n43#2:42\n22#2,2:43\n*S KotlinDebug\n*F\n+ 1 ZipUtils.kt\ncom/intellij/util/io/ZipUtilsKt\n*L\n36#1:42\n36#1:43,2\n*E\n"})
public final class ZipUtilsKt {
    public static final void addFolder(@NotNull ZipOutputStream $this$addFolder, @NotNull String entryName, @NotNull Path folder) {
        Intrinsics.checkNotNullParameter($this$addFolder, "<this>");
        Intrinsics.checkNotNullParameter(entryName, "entryName");
        Intrinsics.checkNotNullParameter(folder, "folder");
        Iterator<Path> iterator2 = PathsKt.walk(folder, new PathWalkOption[0]).iterator();
        while (iterator2.hasNext()) {
            Path path = iterator2.next();
            Path relativized = folder.relativize(path);
            String prefix = ((CharSequence)entryName).length() > 0 ? entryName + '/' : "";
            StringBuilder stringBuilder = new StringBuilder().append(prefix);
            Intrinsics.checkNotNull(relativized);
            ZipUtilsKt.addEntry($this$addFolder, stringBuilder.append(CollectionsKt.joinToString$default(relativized, "/", null, null, 0, null, addFolder.1.INSTANCE, 30, null)).toString(), new Function0<Unit>(path, $this$addFolder){
                final /* synthetic */ Path $path;
                final /* synthetic */ ZipOutputStream $this_addFolder;
                {
                    this.$path = $path;
                    this.$this_addFolder = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream(this.$path, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
                    Closeable closeable = inputStream;
                    ZipOutputStream zipOutputStream = this.$this_addFolder;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        ByteStreamsKt.copyTo$default(it, zipOutputStream, 0, 2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
            });
        }
    }

    public static final void addFile(@NotNull ZipOutputStream $this$addFile, @NotNull String entryName, @NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter($this$addFile, "<this>");
        Intrinsics.checkNotNullParameter(entryName, "entryName");
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        ZipUtilsKt.addEntry($this$addFile, entryName, new Function0<Unit>($this$addFile, byteArray){
            final /* synthetic */ ZipOutputStream $this_addFile;
            final /* synthetic */ byte[] $byteArray;
            {
                this.$this_addFile = $receiver;
                this.$byteArray = $byteArray;
                super(0);
            }

            public final void invoke() {
                this.$this_addFile.write(this.$byteArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addEntry(@NotNull ZipOutputStream $this$addEntry, @NotNull String entryName, @NotNull Function0<Unit> operation) {
        Intrinsics.checkNotNullParameter($this$addEntry, "<this>");
        Intrinsics.checkNotNullParameter(entryName, "entryName");
        Intrinsics.checkNotNullParameter(operation, "operation");
        ZipEntry zipEntry = new ZipEntry(entryName);
        try {
            $this$addEntry.putNextEntry(zipEntry);
            operation.invoke();
        }
        catch (Exception ex) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            logger.error("Failed to add file to stream", ex);
        }
        finally {
            $this$addEntry.closeEntry();
        }
    }
}

