/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.zip.DosTime;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipOutputStream;
import com.intellij.util.io.zip.Zip64ExtraField;
import com.intellij.util.io.zip.ZipLong;
import com.intellij.util.io.zip.ZipShort;
import com.intellij.util.io.zip.ZipUInt64;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.jetbrains.annotations.NotNull;

public class JBZipFile
implements Closeable {
    static final int SHORT = 2;
    static final int WORD = 4;
    static final int DWORD = 8;
    private static final int HASH_SIZE = 509;
    private static final int NIBLET_MASK = 15;
    private static final int BYTE_SHIFT = 8;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final List<JBZipEntry> entries;
    private final Map<String, JBZipEntry> nameMap;
    private final Charset myEncoding;
    final RandomAccessFile myArchive;
    private boolean myIsZip64;
    private JBZipOutputStream myOutputStream;
    private long currentCfdOffset;
    private final boolean myIsReadonly;
    private static final int CFH_LEN = 42;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final int ZIP64_EOCDL_LENGTH = 20;
    private static final int ZIP64_EOCDL_LOCATOR_OFFSET = 8;
    private static final int ZIP64_EOCD_CFD_LOCATOR_OFFSET = 48;
    static final long LFH_OFFSET_FOR_CRC = 14L;
    static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;

    public JBZipFile(File f2) throws IOException {
        this(f2, DEFAULT_CHARSET);
    }

    public JBZipFile(String name2) throws IOException {
        this(new File(name2), DEFAULT_CHARSET);
    }

    public JBZipFile(@NotNull File f2, boolean readonly) throws IOException {
        if (f2 == null) {
            JBZipFile.$$$reportNull$$$0(0);
        }
        this(f2, DEFAULT_CHARSET, readonly);
    }

    public JBZipFile(String name2, @NotNull String encoding) throws IOException {
        if (encoding == null) {
            JBZipFile.$$$reportNull$$$0(1);
        }
        this(new File(name2), encoding);
    }

    public JBZipFile(File f2, @NotNull String encoding) throws IOException {
        if (encoding == null) {
            JBZipFile.$$$reportNull$$$0(2);
        }
        this(f2, Charset.forName(encoding));
    }

    public JBZipFile(File f2, @NotNull Charset encoding) throws IOException {
        if (encoding == null) {
            JBZipFile.$$$reportNull$$$0(3);
        }
        this(f2, encoding, false);
    }

    boolean isZip64() {
        return this.myIsZip64;
    }

    public JBZipFile(@NotNull File f2, @NotNull Charset encoding, boolean readonly) throws IOException {
        if (f2 == null) {
            JBZipFile.$$$reportNull$$$0(4);
        }
        if (encoding == null) {
            JBZipFile.$$$reportNull$$$0(5);
        }
        this(f2, encoding, readonly, ThreeState.NO);
    }

    public JBZipFile(@NotNull File f2, @NotNull Charset encoding, boolean readonly, @NotNull ThreeState isZip64) throws IOException {
        if (f2 == null) {
            JBZipFile.$$$reportNull$$$0(6);
        }
        if (encoding == null) {
            JBZipFile.$$$reportNull$$$0(7);
        }
        if (isZip64 == null) {
            JBZipFile.$$$reportNull$$$0(8);
        }
        this.entries = new ArrayList<JBZipEntry>(509);
        this.nameMap = new HashMap<String, JBZipEntry>(509);
        this.myEncoding = encoding;
        this.myIsReadonly = readonly;
        this.myArchive = new RandomAccessFile(f2, readonly ? "r" : "rw");
        try {
            if (this.myArchive.length() > 0L) {
                this.populateFromCentralDirectory(isZip64);
            } else {
                this.myIsZip64 = isZip64 == ThreeState.YES;
                this.getOutputStream();
            }
        }
        catch (Throwable e2) {
            try {
                this.myArchive.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e2;
        }
    }

    public String toString() {
        return "JBZipFile{readonly=" + this.myIsReadonly + '}';
    }

    public Charset getEncoding() {
        return this.myEncoding;
    }

    @Override
    public void close() throws IOException {
        if (this.myOutputStream != null) {
            if (this.entries.isEmpty()) {
                JBZipEntry empty2 = this.getOrCreateEntry("/empty.file.marker");
                this.myOutputStream.putNextEntryBytes(empty2, "empty".getBytes(StandardCharsets.US_ASCII));
            }
            this.myOutputStream.finish();
            this.myArchive.setLength(this.myOutputStream.getWritten());
        }
        this.myArchive.close();
    }

    public List<JBZipEntry> getEntries() {
        return this.entries;
    }

    public JBZipEntry getEntry(String name2) {
        return this.nameMap.get(name2);
    }

    public JBZipEntry getOrCreateEntry(String name2) {
        JBZipEntry entry = this.nameMap.get(name2);
        if (entry != null) {
            return entry;
        }
        entry = new JBZipEntry(name2, this);
        this.nameMap.put(name2, entry);
        this.entries.add(entry);
        return entry;
    }

    private void populateFromCentralDirectory(@NotNull ThreeState isZip64) throws IOException {
        if (isZip64 == null) {
            JBZipFile.$$$reportNull$$$0(9);
        }
        this.positionAtCentralDirectory(isZip64);
        byte[] cfh = new byte[42];
        byte[] signatureBytes = new byte[4];
        this.myArchive.readFully(signatureBytes);
        long sig = ZipLong.getValue(signatureBytes);
        long cfhSig = ZipLong.getValue(JBZipOutputStream.CFH_SIG);
        while (sig == cfhSig) {
            this.myArchive.readFully(cfh);
            int off = 0;
            int versionMadeBy = ZipShort.getValue(cfh, off);
            off += 2;
            int platform = versionMadeBy >> 8 & 0xF;
            int method = ZipShort.getValue(cfh, off += 4);
            long time = DosTime.dosToJavaTime(ZipLong.getValue(cfh, off += 2));
            long crc = ZipLong.getValue(cfh, off += 4);
            long compressedSize = ZipLong.getValue(cfh, off += 4);
            long uncompressedSize = ZipLong.getValue(cfh, off += 4);
            int fileNameLen = ZipShort.getValue(cfh, off += 4);
            int extraLen = ZipShort.getValue(cfh, off += 2);
            int commentLen = ZipShort.getValue(cfh, off += 2);
            off += 2;
            int internalAttributes = ZipShort.getValue(cfh, off += 2);
            long externalAttributes = ZipLong.getValue(cfh, off += 2);
            long localHeaderOffset = ZipLong.getValue(cfh, off += 4);
            String name2 = this.getString(this.readBytes(fileNameLen));
            byte[] extra = this.readBytes(extraLen);
            String comment = this.getString(this.readBytes(commentLen));
            JBZipEntry ze = new JBZipEntry(this);
            ze.setName(name2);
            ze.setHeaderOffset(localHeaderOffset);
            ze.setPlatform(platform);
            ze.setMethod(method);
            ze.setTime(time);
            ze.setCrc(crc);
            ze.setCompressedSize(compressedSize);
            ze.setSize(uncompressedSize);
            ze.setInternalAttributes(internalAttributes);
            ze.setExternalAttributes(externalAttributes);
            ze.readExtraFromCentralDirectoryBytes(extra);
            try {
                ze.setComment(comment);
            }
            catch (IllegalArgumentException e2) {
                ze.setComment(comment.substring(0, 21845));
            }
            this.nameMap.put(ze.getName(), ze);
            this.entries.add(ze);
            this.myArchive.readFully(signatureBytes);
            sig = ZipLong.getValue(signatureBytes);
        }
    }

    private byte[] readBytes(int count2) throws IOException {
        if (count2 > 0) {
            byte[] bytes2 = new byte[count2];
            this.myArchive.readFully(bytes2);
            return bytes2;
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    private void positionAtCentralDirectory(@NotNull ThreeState isZip64) throws IOException {
        boolean searchForZip64EOCD;
        if (isZip64 == null) {
            JBZipFile.$$$reportNull$$$0(10);
        }
        boolean found = false;
        long off = this.myArchive.length() - 22L;
        if (off >= 0L) {
            this.myArchive.seek(off);
            byte[] sig = JBZipOutputStream.EOCD_SIG;
            int curr = this.myArchive.read();
            while (curr != -1) {
                if (curr == sig[0] && (curr = this.myArchive.read()) == sig[1] && (curr = this.myArchive.read()) == sig[2] && (curr = this.myArchive.read()) == sig[3]) {
                    found = true;
                    break;
                }
                this.myArchive.seek(--off);
                curr = this.myArchive.read();
            }
        }
        if (!found) {
            throw new ZipException("archive is not a ZIP archive");
        }
        boolean bl2 = searchForZip64EOCD = this.myArchive.getFilePointer() > 20L;
        if (searchForZip64EOCD) {
            this.myArchive.seek(this.myArchive.getFilePointer() - 20L - 4L);
            this.myIsZip64 = Arrays.equals(this.readBytes(4), JBZipOutputStream.ZIP64_EOCD_LOC_SIG);
        }
        if (this.myIsZip64) {
            long value;
            if (isZip64.equals((Object)ThreeState.NO)) {
                throw new IOException("Non ZIP64 archive was requested but it is a ZIP64 archive");
            }
            this.myArchive.skipBytes(4);
            this.myArchive.seek(ZipUInt64.getLongValue(this.readBytes(8)));
            if (!Arrays.equals(this.readBytes(4), JBZipOutputStream.ZIP64_EOCD_SIG)) {
                throw new IOException("archive is not a ZIP64 archive");
            }
            this.myArchive.skipBytes(44);
            this.currentCfdOffset = value = ZipUInt64.getLongValue(this.readBytes(8));
            this.myArchive.seek(value);
        } else {
            if (isZip64.equals((Object)ThreeState.YES)) {
                throw new IOException("ZIP64 archive was requested but it is not a ZIP64 archive");
            }
            this.myArchive.seek(off + 16L);
            byte[] cfdOffset = new byte[4];
            this.myArchive.readFully(cfdOffset);
            this.currentCfdOffset = ZipLong.getValue(cfdOffset);
            this.myArchive.seek(this.currentCfdOffset);
        }
    }

    private String getString(byte[] bytes2) {
        if (this.myEncoding == null) {
            return new String(bytes2, Charset.defaultCharset());
        }
        return new String(bytes2, this.myEncoding);
    }

    public void eraseEntry(JBZipEntry entry) throws IOException {
        this.getOutputStream();
        this.entries.remove(entry);
        this.nameMap.remove(entry.getName());
    }

    public void gc() throws IOException {
        if (this.myOutputStream != null) {
            this.myOutputStream = null;
            LinkedHashMap<JBZipEntry, byte[]> existingEntries = new LinkedHashMap<JBZipEntry, byte[]>();
            for (JBZipEntry jBZipEntry : this.entries) {
                existingEntries.put(jBZipEntry, jBZipEntry.getData());
            }
            this.currentCfdOffset = 0L;
            this.nameMap.clear();
            this.entries.clear();
            for (Map.Entry entry : existingEntries.entrySet()) {
                JBZipEntry zipEntry = this.getOrCreateEntry(((JBZipEntry)entry.getKey()).getName());
                zipEntry.setComment(((JBZipEntry)entry.getKey()).getComment());
                zipEntry.setExtra(ContainerUtil.filter(((JBZipEntry)entry.getKey()).getExtra(), f2 -> !(f2 instanceof Zip64ExtraField)));
                zipEntry.setMethod(((JBZipEntry)entry.getKey()).getMethod());
                zipEntry.setTime(((JBZipEntry)entry.getKey()).getTime());
                zipEntry.setData((byte[])entry.getValue());
            }
        }
    }

    JBZipOutputStream getOutputStream() throws IOException {
        if (this.myIsReadonly) {
            throw new IOException("Archive " + this + " is an empty file");
        }
        if (this.myOutputStream == null) {
            this.myOutputStream = new JBZipOutputStream(this, this.currentCfdOffset);
        }
        return this.myOutputStream;
    }

    void ensureFlushed(long end) throws IOException {
        if (this.myOutputStream != null) {
            this.myOutputStream.ensureFlushed(end);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isZip64";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/zip/JBZipFile";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "populateFromCentralDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "positionAtCentralDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

