/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.util.ArrayUtil;
import com.intellij.util.io.zip.JBZipExtraField;
import com.intellij.util.io.zip.ZipShort;
import com.intellij.util.io.zip.ZipUInt64;
import java.util.zip.ZipException;
import org.jetbrains.annotations.NotNull;

public final class Zip64ExtraField
implements JBZipExtraField {
    static final ZipShort HEADER_ID = new ZipShort(1);
    private ZipUInt64 mySize;
    private ZipUInt64 myCompressedSize;
    private ZipUInt64 myHeaderOffset;

    Zip64ExtraField() {
    }

    public Zip64ExtraField(ZipUInt64 size, ZipUInt64 compressedSize, ZipUInt64 headerOffset) {
        this.mySize = size;
        this.myCompressedSize = compressedSize;
        this.myHeaderOffset = headerOffset;
    }

    @Override
    @NotNull
    public ZipShort getHeaderId() {
        ZipShort zipShort = HEADER_ID;
        if (zipShort == null) {
            Zip64ExtraField.$$$reportNull$$$0(0);
        }
        return zipShort;
    }

    @Override
    @NotNull
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(this.mySize != null ? 16 : 0);
    }

    @Override
    @NotNull
    public ZipShort getCentralDirectoryLength() {
        return new ZipShort((this.mySize != null ? 8 : 0) + (this.myCompressedSize != null ? 8 : 0) + (this.myHeaderOffset != null ? 8 : 0));
    }

    @Override
    public byte @NotNull [] getLocalFileDataData() {
        if (this.mySize != null || this.myCompressedSize != null) {
            if (this.mySize == null || this.myCompressedSize == null) {
                throw new IllegalArgumentException("Must contain both size values in the local file header");
            }
            byte[] data = new byte[16];
            this.addSizes(data);
            if (data == null) {
                Zip64ExtraField.$$$reportNull$$$0(1);
            }
            return data;
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            Zip64ExtraField.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    @Override
    public byte @NotNull [] getCentralDirectoryData() {
        byte[] data = ArrayUtil.newByteArray(this.getCentralDirectoryLength().getValue());
        int off = this.addSizes(data);
        if (this.myHeaderOffset != null) {
            System.arraycopy(this.myHeaderOffset.getBytes(), 0, data, off, 8);
        }
        if (data == null) {
            Zip64ExtraField.$$$reportNull$$$0(3);
        }
        return data;
    }

    @Override
    public void parseFromLocalFileData(byte @NotNull [] buffer, int offset, int length) throws ZipException {
        if (buffer == null) {
            Zip64ExtraField.$$$reportNull$$$0(4);
        }
        if (length == 0) {
            return;
        }
        if (length < 16) {
            throw new ZipException("Must contain both size values in the local file header.");
        }
        this.mySize = new ZipUInt64(buffer, offset);
        this.myCompressedSize = new ZipUInt64(buffer, offset += 8);
        offset += 8;
        int remaining = length - 16;
        if (remaining >= 8) {
            this.myHeaderOffset = new ZipUInt64(buffer, offset);
        }
    }

    @Override
    public void parseFromCentralDirectoryData(byte @NotNull [] buffer, int offset, int length) throws ZipException {
        if (buffer == null) {
            Zip64ExtraField.$$$reportNull$$$0(5);
        }
        this.mySize = new ZipUInt64(buffer, offset);
        this.myCompressedSize = new ZipUInt64(buffer, offset += 8);
        this.myHeaderOffset = new ZipUInt64(buffer, offset += 8);
    }

    public ZipUInt64 getSize() {
        return this.mySize;
    }

    public ZipUInt64 getCompressedSize() {
        return this.myCompressedSize;
    }

    public ZipUInt64 getHeaderOffset() {
        return this.myHeaderOffset;
    }

    private int addSizes(byte[] data) {
        int off = 0;
        if (this.mySize != null) {
            System.arraycopy(this.mySize.getBytes(), 0, data, 0, 8);
            off += 8;
        }
        if (this.myCompressedSize != null) {
            System.arraycopy(this.myCompressedSize.getBytes(), 0, data, off, 8);
            off += 8;
        }
        return off;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/zip/Zip64ExtraField";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileDataData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCentralDirectoryData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/zip/Zip64ExtraField";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseFromLocalFileData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFromCentralDirectoryData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

