/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

public final class ZipLong
implements Cloneable {
    private static final int WORD = 4;
    private static final int BYTE_BIT_SIZE = 8;
    private static final int BYTE_MASK = 255;
    private static final int BYTE_1 = 1;
    private static final int BYTE_1_MASK = 65280;
    private static final int BYTE_1_SHIFT = 8;
    private static final int BYTE_2 = 2;
    private static final int BYTE_2_MASK = 0xFF0000;
    private static final int BYTE_2_SHIFT = 16;
    private static final int BYTE_3 = 3;
    private static final long BYTE_3_MASK = 0xFF000000L;
    private static final int BYTE_3_SHIFT = 24;
    private final long value;

    public ZipLong(long value) {
        this.value = value;
    }

    public ZipLong(byte[] bytes2) {
        this(bytes2, 0);
    }

    public ZipLong(byte[] bytes2, int offset) {
        this.value = ZipLong.getValue(bytes2, offset);
    }

    public byte[] getBytes() {
        return ZipLong.getBytes(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public static byte[] getBytes(long value) {
        byte[] result2 = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24)};
        return result2;
    }

    public static long getValue(byte[] bytes2, int offset) {
        long value = (long)(bytes2[offset + 3] << 24) & 0xFF000000L;
        value += (long)(bytes2[offset + 2] << 16 & 0xFF0000);
        value += (long)(bytes2[offset + 1] << 8 & 0xFF00);
        return value += (long)(bytes2[offset] & 0xFF);
    }

    public static long getValue(byte[] bytes2) {
        return ZipLong.getValue(bytes2, 0);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof ZipLong)) {
            return false;
        }
        return this.value == ((ZipLong)o2).getValue();
    }

    public int hashCode() {
        return (int)this.value;
    }
}

