/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectByteBufferPool {
    public static final DirectByteBufferPool DEFAULT_POOL = new DirectByteBufferPool(it -> {});
    private static final int MIN_SIZE = 2048;
    private static final int MAX_POOL_SIZE = 32;
    private final ConcurrentSkipListMap<Integer, ByteBuffer> pool;
    private final AtomicInteger count;
    @NotNull
    private final Consumer<? super ByteBuffer> releaser;

    public DirectByteBufferPool(@NotNull Consumer<? super ByteBuffer> releaser) {
        if (releaser == null) {
            DirectByteBufferPool.$$$reportNull$$$0(0);
        }
        this.pool = new ConcurrentSkipListMap();
        this.count = new AtomicInteger();
        this.releaser = releaser;
    }

    @NotNull
    public ByteBuffer allocate(int requiredSize) {
        ByteBuffer result2;
        Map.Entry<Integer, ByteBuffer> entry;
        int size = DirectByteBufferPool.roundUpInt(requiredSize, 2048);
        while ((entry = this.pool.ceilingEntry(size)) != null && !this.pool.remove(entry.getKey(), entry.getValue())) {
        }
        if (entry == null) {
            result2 = ByteBuffer.allocateDirect(size);
        } else {
            this.count.decrementAndGet();
            result2 = entry.getValue();
        }
        result2.limit(requiredSize);
        ByteBuffer byteBuffer = result2;
        if (byteBuffer == null) {
            DirectByteBufferPool.$$$reportNull$$$0(1);
        }
        return byteBuffer;
    }

    public void release(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            DirectByteBufferPool.$$$reportNull$$$0(2);
        }
        if (buffer.isReadOnly()) {
            return;
        }
        buffer.rewind();
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (this.count.get() < 32 && this.pool.putIfAbsent(buffer.capacity(), buffer) == null) {
            this.count.incrementAndGet();
        } else {
            this.releaser.accept(buffer);
        }
    }

    public void releaseAll() {
        Iterator<ByteBuffer> iterator2 = this.pool.values().iterator();
        while (iterator2.hasNext()) {
            ByteBuffer buffer = iterator2.next();
            iterator2.remove();
            this.releaser.accept(buffer);
        }
    }

    private static int roundUpInt(int x2, int blockSizePowerOf2) {
        return x2 + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/DirectByteBufferPool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/DirectByteBufferPool";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "allocate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

