/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.CollectionStrategy;
import com.intellij.util.xmlb.DomAdapter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u00d6\u0003J \u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0014H\u00d6\u0001J$\u0010\u0019\u001a\u00020\u00042\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00112\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/xmlb/ArrayStrategy;", "Lcom/intellij/util/xmlb/CollectionStrategy;", "()V", "deserializeList", "", "T", "currentValue", "elements", "", "adapter", "Lcom/intellij/util/xmlb/DomAdapter;", "binding", "Lcom/intellij/util/xmlb/CollectionBinding;", "equals", "", "other", "getCollection", "", "bean", "getCollectionTagName", "", "target", "hashCode", "", "toString", "transformJsonValue", "value", "itemType", "Ljava/lang/Class;", "intellij.platform.util"})
final class ArrayStrategy
implements CollectionStrategy {
    @NotNull
    public static final ArrayStrategy INSTANCE = new ArrayStrategy();

    private ArrayStrategy() {
    }

    @Override
    @NotNull
    public String getCollectionTagName(@Nullable Object target) {
        return "array";
    }

    @Override
    @NotNull
    public <T> Object deserializeList(@Nullable Object currentValue, @NotNull List<? extends T> elements, @NotNull DomAdapter<T> adapter, @NotNull CollectionBinding binding) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        Intrinsics.checkNotNullParameter(binding, "binding");
        int size = elements.size();
        Object object = Array.newInstance(binding.itemType, size);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
        Object[] result2 = (Object[])object;
        for (int i2 = 0; i2 < size; ++i2) {
            Intrinsics.checkNotNull(binding.deserializeItem$intellij_platform_util(elements.get(i2), adapter, currentValue));
        }
        return result2;
    }

    @Override
    @NotNull
    public Collection<Object> getCollection(@NotNull Object bean, @NotNull CollectionBinding binding) {
        Collection collection;
        Intrinsics.checkNotNullParameter(bean, "bean");
        Intrinsics.checkNotNullParameter(binding, "binding");
        Object[] list2 = (Object[])bean;
        if (list2.length == 0) {
            List list3 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list3, "emptyList(...)");
            collection = list3;
        } else {
            collection = ArraysKt.asList(list2);
        }
        return collection;
    }

    @Override
    @NotNull
    public Object transformJsonValue(@NotNull Collection<? extends Object> value, @NotNull Class<?> itemType) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(itemType, "itemType");
        Collection<? extends Object> list2 = value;
        Object object = Array.newInstance(itemType, list2.size());
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
        Object[] result2 = (Object[])object;
        Object[] objectArray = list2.toArray(result2);
        Intrinsics.checkNotNullExpressionValue(objectArray, "toArray(...)");
        return objectArray;
    }

    @NotNull
    public String toString() {
        return "ArrayStrategy";
    }

    public int hashCode() {
        return -488452981;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArrayStrategy)) {
            return false;
        }
        ArrayStrategy cfr_ignored_0 = (ArrayStrategy)other;
        return true;
    }
}

