/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.api.impl;

import com.sun.xml.bind.api.impl.NameUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.lang.model.SourceVersion;

public interface NameConverter {
    public static final NameConverter standard = new Standard();
    public static final NameConverter jaxrpcCompatible = new Standard(){

        @Override
        protected boolean isPunct(char c2) {
            return c2 == '.' || c2 == '-' || c2 == ';' || c2 == '\u00b7' || c2 == '\u0387' || c2 == '\u06dd' || c2 == '\u06de';
        }

        @Override
        protected boolean isLetter(char c2) {
            return super.isLetter(c2) || c2 == '_';
        }

        @Override
        protected int classify(char c0) {
            if (c0 == '_') {
                return 2;
            }
            return super.classify(c0);
        }
    };
    public static final NameConverter smart = new Standard(){

        @Override
        public String toConstantName(String token2) {
            String name2 = super.toConstantName(token2);
            if (!SourceVersion.isKeyword(name2)) {
                return name2;
            }
            return '_' + name2;
        }
    };

    public String toClassName(String var1);

    public String toInterfaceName(String var1);

    public String toPropertyName(String var1);

    public String toConstantName(String var1);

    public String toVariableName(String var1);

    public String toPackageName(String var1);

    public static class Standard
    extends NameUtil
    implements NameConverter {
        @Override
        public String toClassName(String s2) {
            return this.toMixedCaseName(this.toWordList(s2), true);
        }

        @Override
        public String toVariableName(String s2) {
            return this.toMixedCaseName(this.toWordList(s2), false);
        }

        @Override
        public String toInterfaceName(String token2) {
            return this.toClassName(token2);
        }

        @Override
        public String toPropertyName(String s2) {
            String prop = this.toClassName(s2);
            if (prop.equals("Class")) {
                prop = "Clazz";
            }
            return prop;
        }

        @Override
        public String toConstantName(String token2) {
            return super.toConstantName(token2);
        }

        @Override
        public String toPackageName(String nsUri) {
            ArrayList<String> r2;
            String domain;
            String lastToken;
            ArrayList<String> tokens;
            int idx = nsUri.indexOf(58);
            String scheme = "";
            if (idx >= 0 && ((scheme = nsUri.substring(0, idx)).equalsIgnoreCase("http") || scheme.equalsIgnoreCase("urn"))) {
                nsUri = nsUri.substring(idx + 1);
            }
            if ((tokens = Standard.tokenize(nsUri, "/: ")).size() == 0) {
                return null;
            }
            if (tokens.size() > 1 && (idx = (lastToken = tokens.get(tokens.size() - 1)).lastIndexOf(46)) > 0) {
                lastToken = lastToken.substring(0, idx);
                tokens.set(tokens.size() - 1, lastToken);
            }
            if ((idx = (domain = tokens.get(0)).indexOf(58)) >= 0) {
                domain = domain.substring(0, idx);
            }
            if ((r2 = Standard.reverse(Standard.tokenize(domain, scheme.equals("urn") ? ".-" : "."))).get(r2.size() - 1).equalsIgnoreCase("www")) {
                r2.remove(r2.size() - 1);
            }
            tokens.addAll(1, r2);
            tokens.remove(0);
            for (int i2 = 0; i2 < tokens.size(); ++i2) {
                String token2 = tokens.get(i2);
                if (SourceVersion.isKeyword((token2 = Standard.removeIllegalIdentifierChars(token2)).toLowerCase())) {
                    token2 = '_' + token2;
                }
                tokens.set(i2, token2.toLowerCase());
            }
            return Standard.combine(tokens, '.');
        }

        private static String removeIllegalIdentifierChars(String token2) {
            StringBuilder newToken = new StringBuilder(token2.length() + 1);
            for (int i2 = 0; i2 < token2.length(); ++i2) {
                char c2 = token2.charAt(i2);
                if (i2 == 0 && !Character.isJavaIdentifierStart(c2)) {
                    newToken.append('_');
                }
                if (!Character.isJavaIdentifierPart(c2)) {
                    newToken.append('_');
                    continue;
                }
                newToken.append(c2);
            }
            return newToken.toString();
        }

        private static ArrayList<String> tokenize(String str, String sep) {
            StringTokenizer tokens = new StringTokenizer(str, sep);
            ArrayList<String> r2 = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                r2.add(tokens.nextToken());
            }
            return r2;
        }

        private static <T> ArrayList<T> reverse(List<T> a2) {
            ArrayList<T> r2 = new ArrayList<T>();
            for (int i2 = a2.size() - 1; i2 >= 0; --i2) {
                r2.add(a2.get(i2));
            }
            return r2;
        }

        private static String combine(List r2, char sep) {
            StringBuilder buf = new StringBuilder(r2.get(0).toString());
            for (int i2 = 1; i2 < r2.size(); ++i2) {
                buf.append(sep);
                buf.append(r2.get(i2));
            }
            return buf.toString();
        }
    }
}

