/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.tools;

import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.tools.VocabularyGenerator;
import com.sun.xml.fastinfoset.util.CharArrayArray;
import com.sun.xml.fastinfoset.util.ContiguousCharArrayArray;
import com.sun.xml.fastinfoset.util.PrefixArray;
import com.sun.xml.fastinfoset.util.QualifiedNameArray;
import com.sun.xml.fastinfoset.util.StringArray;
import com.sun.xml.fastinfoset.vocab.ParserVocabulary;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class PrintTable {
    public static void printVocabulary(ParserVocabulary vocabulary) {
        PrintTable.printArray("Attribute Name Table", vocabulary.attributeName);
        PrintTable.printArray("Attribute Value Table", vocabulary.attributeValue);
        PrintTable.printArray("Character Content Chunk Table", vocabulary.characterContentChunk);
        PrintTable.printArray("Element Name Table", vocabulary.elementName);
        PrintTable.printArray("Local Name Table", vocabulary.localName);
        PrintTable.printArray("Namespace Name Table", vocabulary.namespaceName);
        PrintTable.printArray("Other NCName Table", vocabulary.otherNCName);
        PrintTable.printArray("Other String Table", vocabulary.otherString);
        PrintTable.printArray("Other URI Table", vocabulary.otherURI);
        PrintTable.printArray("Prefix Table", vocabulary.prefix);
    }

    public static void printArray(String title, StringArray a2) {
        System.out.println(title);
        for (int i2 = 0; i2 < a2.getSize(); ++i2) {
            System.out.println("" + (i2 + 1) + ": " + a2.getArray()[i2]);
        }
    }

    public static void printArray(String title, PrefixArray a2) {
        System.out.println(title);
        for (int i2 = 0; i2 < a2.getSize(); ++i2) {
            System.out.println("" + (i2 + 1) + ": " + a2.getArray()[i2]);
        }
    }

    public static void printArray(String title, CharArrayArray a2) {
        System.out.println(title);
        for (int i2 = 0; i2 < a2.getSize(); ++i2) {
            System.out.println("" + (i2 + 1) + ": " + a2.getArray()[i2]);
        }
    }

    public static void printArray(String title, ContiguousCharArrayArray a2) {
        System.out.println(title);
        for (int i2 = 0; i2 < a2.getSize(); ++i2) {
            System.out.println("" + (i2 + 1) + ": " + a2.getString(i2));
        }
    }

    public static void printArray(String title, QualifiedNameArray a2) {
        System.out.println(title);
        for (int i2 = 0; i2 < a2.getSize(); ++i2) {
            QualifiedName name2 = a2.getArray()[i2];
            System.out.println("" + (name2.index + 1) + ": {" + name2.namespaceName + "}" + name2.prefix + ":" + name2.localName);
        }
    }

    public static void main(String[] args2) {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            ParserVocabulary referencedVocabulary = new ParserVocabulary();
            VocabularyGenerator vocabularyGenerator = new VocabularyGenerator(referencedVocabulary);
            File f2 = new File(args2[0]);
            saxParser.parse(f2, (DefaultHandler)vocabularyGenerator);
            PrintTable.printVocabulary(referencedVocabulary);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

