/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public final class NamespaceContextImplementation
implements NamespaceContext {
    private static int DEFAULT_SIZE = 8;
    private String[] prefixes = new String[DEFAULT_SIZE];
    private String[] namespaceURIs = new String[DEFAULT_SIZE];
    private int namespacePosition;
    private int[] contexts = new int[DEFAULT_SIZE];
    private int contextPosition;
    private int currentContext;

    public NamespaceContextImplementation() {
        this.prefixes[0] = "xml";
        this.namespaceURIs[0] = "http://www.w3.org/XML/1998/namespace";
        this.prefixes[1] = "xmlns";
        this.namespaceURIs[1] = "http://www.w3.org/2000/xmlns/";
        this.namespacePosition = 2;
        this.currentContext = 2;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        for (int i2 = this.namespacePosition - 1; i2 >= 0; --i2) {
            String declaredPrefix = this.prefixes[i2];
            if (!declaredPrefix.equals(prefix)) continue;
            return this.namespaceURIs[i2];
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        for (int i2 = this.namespacePosition - 1; i2 >= 0; --i2) {
            String declaredNamespaceURI = this.namespaceURIs[i2];
            if (!declaredNamespaceURI.equals(namespaceURI)) continue;
            String declaredPrefix = this.prefixes[i2];
            boolean isOutOfScope = false;
            for (int j2 = i2 + 1; j2 < this.namespacePosition; ++j2) {
                if (!declaredPrefix.equals(this.prefixes[j2])) continue;
                isOutOfScope = true;
                break;
            }
            if (isOutOfScope) continue;
            return declaredPrefix;
        }
        return null;
    }

    public String getNonDefaultPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        for (int i2 = this.namespacePosition - 1; i2 >= 0; --i2) {
            String declaredNamespaceURI = this.namespaceURIs[i2];
            if (!declaredNamespaceURI.equals(namespaceURI) || this.prefixes[i2].length() <= 0) continue;
            String declaredPrefix = this.prefixes[i2];
            ++i2;
            while (i2 < this.namespacePosition) {
                if (declaredPrefix.equals(this.prefixes[i2])) {
                    return null;
                }
                ++i2;
            }
            return declaredPrefix;
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> l2 = new ArrayList<String>();
        block0: for (int i2 = this.namespacePosition - 1; i2 >= 0; --i2) {
            String declaredNamespaceURI = this.namespaceURIs[i2];
            if (!declaredNamespaceURI.equals(namespaceURI)) continue;
            String declaredPrefix = this.prefixes[i2];
            for (int j2 = i2 + 1; j2 < this.namespacePosition; ++j2) {
                if (declaredPrefix.equals(this.prefixes[j2])) continue block0;
            }
            l2.add(declaredPrefix);
        }
        return l2.iterator();
    }

    public String getPrefix(int index2) {
        return this.prefixes[index2];
    }

    public String getNamespaceURI(int index2) {
        return this.namespaceURIs[index2];
    }

    public int getCurrentContextStartIndex() {
        return this.currentContext;
    }

    public int getCurrentContextEndIndex() {
        return this.namespacePosition;
    }

    public boolean isCurrentContextEmpty() {
        return this.currentContext == this.namespacePosition;
    }

    public void declarePrefix(String prefix, String namespaceURI) {
        prefix = prefix.intern();
        namespaceURI = namespaceURI.intern();
        if (prefix == "xml" || prefix == "xmlns") {
            return;
        }
        for (int i2 = this.currentContext; i2 < this.namespacePosition; ++i2) {
            String declaredPrefix = this.prefixes[i2];
            if (declaredPrefix != prefix) continue;
            this.prefixes[i2] = prefix;
            this.namespaceURIs[i2] = namespaceURI;
            return;
        }
        if (this.namespacePosition == this.namespaceURIs.length) {
            this.resizeNamespaces();
        }
        this.prefixes[this.namespacePosition] = prefix;
        this.namespaceURIs[this.namespacePosition++] = namespaceURI;
    }

    private void resizeNamespaces() {
        int newLength = this.namespaceURIs.length * 3 / 2 + 1;
        String[] newPrefixes = new String[newLength];
        System.arraycopy(this.prefixes, 0, newPrefixes, 0, this.prefixes.length);
        this.prefixes = newPrefixes;
        String[] newNamespaceURIs = new String[newLength];
        System.arraycopy(this.namespaceURIs, 0, newNamespaceURIs, 0, this.namespaceURIs.length);
        this.namespaceURIs = newNamespaceURIs;
    }

    public void pushContext() {
        if (this.contextPosition == this.contexts.length) {
            this.resizeContexts();
        }
        this.contexts[this.contextPosition++] = this.currentContext = this.namespacePosition;
    }

    private void resizeContexts() {
        int[] newContexts = new int[this.contexts.length * 3 / 2 + 1];
        System.arraycopy(this.contexts, 0, newContexts, 0, this.contexts.length);
        this.contexts = newContexts;
    }

    public void popContext() {
        if (this.contextPosition > 0) {
            this.namespacePosition = this.currentContext = this.contexts[--this.contextPosition];
        }
    }

    public void reset() {
        this.namespacePosition = 2;
        this.currentContext = 2;
    }
}

