/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TByteByteIterator;
import gnu.trove.TByteByteProcedure;
import gnu.trove.TByteFunction;
import gnu.trove.TByteHash;
import gnu.trove.TByteHashingStrategy;
import gnu.trove.TByteProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TByteByteHashMap
extends TByteHash {
    protected transient byte[] _values;

    public TByteByteHashMap() {
    }

    public TByteByteHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TByteByteHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TByteByteHashMap(TByteHashingStrategy strategy) {
        super(strategy);
    }

    public TByteByteHashMap(int initialCapacity, TByteHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TByteByteHashMap(int initialCapacity, float loadFactor, TByteHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TByteByteHashMap m4 = (TByteByteHashMap)super.clone();
        m4._values = this._values == null ? null : (byte[])this._values.clone();
        return m4;
    }

    public TByteByteIterator iterator() {
        return new TByteByteIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new byte[capacity];
        return capacity;
    }

    public byte put(byte key, byte value) {
        byte previous = 0;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        byte[] oldKeys = this._set;
        byte[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new byte[newCapacity];
        this._values = new byte[newCapacity];
        this._states = new byte[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldStates[i2] != 1) continue;
            byte o2 = oldKeys[i2];
            int index2 = this.insertionIndex(o2);
            this._set[index2] = o2;
            this._values[index2] = oldVals[i2];
            this._states[index2] = 1;
        }
    }

    public byte get(byte key) {
        int index2 = this.index(key);
        return index2 < 0 ? (byte)0 : this._values[index2];
    }

    public void clear() {
        super.clear();
        byte[] keys2 = this._set;
        byte[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i2 = keys2.length;
        while (i2-- > 0) {
            keys2[i2] = 0;
            vals[i2] = 0;
            states[i2] = 0;
        }
    }

    public byte remove(byte key) {
        byte prev = 0;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TByteByteHashMap)) {
            return false;
        }
        TByteByteHashMap that = (TByteByteHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p2 = new HashProcedure();
        this.forEachEntry(p2);
        return p2.getHashCode();
    }

    protected void removeAt(int index2) {
        this._values[index2] = 0;
        super.removeAt(index2);
    }

    public byte[] getValues() {
        byte[] vals = new byte[this.size()];
        byte[] v2 = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                vals[j2++] = v2[i2];
            }
        }
        return vals;
    }

    public byte[] keys() {
        byte[] keys2 = new byte[this.size()];
        byte[] k2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                keys2[j2++] = k2[i2];
            }
        }
        return keys2;
    }

    public boolean containsValue(byte val) {
        byte[] states = this._states;
        byte[] vals = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || val != vals[i2]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(byte key) {
        return this.contains(key);
    }

    public boolean forEachKey(TByteProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TByteProcedure procedure) {
        byte[] states = this._states;
        byte[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TByteByteProcedure procedure) {
        byte[] states = this._states;
        byte[] keys2 = this._set;
        byte[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TByteByteProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        byte[] keys2 = this._set;
        byte[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TByteFunction function) {
        byte[] states = this._states;
        byte[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                values2[i2] = function.execute(values2[i2]);
            }
        }
    }

    public boolean increment(byte key) {
        return this.adjustValue(key, (byte)1);
    }

    public boolean adjustValue(byte key, byte amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n2 = index2;
        this._values[n2] = (byte)(this._values[n2] + amount);
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            byte key = stream.readByte();
            byte val = stream.readByte();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TByteByteProcedure(){

            public boolean execute(byte key, byte value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TByteByteProcedure {
        private final TByteByteHashMap _otherMap;

        EqProcedure(TByteByteHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(byte key, byte value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(byte v1, byte v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TByteByteProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(byte key, byte value) {
            this.h += TByteByteHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

