/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleLongIterator;
import gnu.trove.TDoubleLongProcedure;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TDoubleLongHashMap
extends TDoubleHash {
    protected transient long[] _values;

    public TDoubleLongHashMap() {
    }

    public TDoubleLongHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TDoubleLongHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TDoubleLongHashMap(TDoubleHashingStrategy strategy) {
        super(strategy);
    }

    public TDoubleLongHashMap(int initialCapacity, TDoubleHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TDoubleLongHashMap(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TDoubleLongHashMap m4 = (TDoubleLongHashMap)super.clone();
        m4._values = this._values == null ? null : (long[])this._values.clone();
        return m4;
    }

    public TDoubleLongIterator iterator() {
        return new TDoubleLongIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new long[capacity];
        return capacity;
    }

    public long put(double key, long value) {
        long previous = 0L;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        double[] oldKeys = this._set;
        long[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new double[newCapacity];
        this._values = new long[newCapacity];
        this._states = new byte[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldStates[i2] != 1) continue;
            double o2 = oldKeys[i2];
            int index2 = this.insertionIndex(o2);
            this._set[index2] = o2;
            this._values[index2] = oldVals[i2];
            this._states[index2] = 1;
        }
    }

    public long get(double key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0L : this._values[index2];
    }

    public void clear() {
        super.clear();
        double[] keys2 = this._set;
        long[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i2 = keys2.length;
        while (i2-- > 0) {
            keys2[i2] = 0.0;
            vals[i2] = 0L;
            states[i2] = 0;
        }
    }

    public long remove(double key) {
        long prev = 0L;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleLongHashMap)) {
            return false;
        }
        TDoubleLongHashMap that = (TDoubleLongHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p2 = new HashProcedure();
        this.forEachEntry(p2);
        return p2.getHashCode();
    }

    protected void removeAt(int index2) {
        this._values[index2] = 0L;
        super.removeAt(index2);
    }

    public long[] getValues() {
        long[] vals = new long[this.size()];
        long[] v2 = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                vals[j2++] = v2[i2];
            }
        }
        return vals;
    }

    public double[] keys() {
        double[] keys2 = new double[this.size()];
        double[] k2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                keys2[j2++] = k2[i2];
            }
        }
        return keys2;
    }

    public boolean containsValue(long val) {
        byte[] states = this._states;
        long[] vals = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || val != vals[i2]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(double key) {
        return this.contains(key);
    }

    public boolean forEachKey(TDoubleProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TLongProcedure procedure) {
        byte[] states = this._states;
        long[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TDoubleLongProcedure procedure) {
        byte[] states = this._states;
        double[] keys2 = this._set;
        long[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TDoubleLongProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        double[] keys2 = this._set;
        long[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TLongFunction function) {
        byte[] states = this._states;
        long[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                values2[i2] = function.execute(values2[i2]);
            }
        }
    }

    public boolean increment(double key) {
        return this.adjustValue(key, 1L);
    }

    public boolean adjustValue(double key, long amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n2 = index2;
        this._values[n2] = this._values[n2] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            double key = stream.readDouble();
            long val = stream.readLong();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TDoubleLongProcedure(){

            public boolean execute(double key, long value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TDoubleLongProcedure {
        private final TDoubleLongHashMap _otherMap;

        EqProcedure(TDoubleLongHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(double key, long value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(long v1, long v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TDoubleLongProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double key, long value) {
            this.h += TDoubleLongHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

