/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatFloatIterator;
import gnu.trove.TFloatFloatProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TFloatFloatHashMap
extends TFloatHash {
    protected transient float[] _values;

    public TFloatFloatHashMap() {
    }

    public TFloatFloatHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatFloatHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatFloatHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatFloatHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatFloatHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TFloatFloatHashMap m4 = (TFloatFloatHashMap)super.clone();
        m4._values = this._values == null ? null : (float[])this._values.clone();
        return m4;
    }

    public TFloatFloatIterator iterator() {
        return new TFloatFloatIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new float[capacity];
        return capacity;
    }

    public float put(float key, float value) {
        float previous = 0.0f;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldKeys = this._set;
        float[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new float[newCapacity];
        this._states = new byte[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldStates[i2] != 1) continue;
            float o2 = oldKeys[i2];
            int index2 = this.insertionIndex(o2);
            this._set[index2] = o2;
            this._values[index2] = oldVals[i2];
            this._states[index2] = 1;
        }
    }

    public float get(float key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0.0f : this._values[index2];
    }

    public void clear() {
        super.clear();
        float[] keys2 = this._set;
        float[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i2 = keys2.length;
        while (i2-- > 0) {
            keys2[i2] = 0.0f;
            vals[i2] = 0.0f;
            states[i2] = 0;
        }
    }

    public float remove(float key) {
        float prev = 0.0f;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatFloatHashMap)) {
            return false;
        }
        TFloatFloatHashMap that = (TFloatFloatHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p2 = new HashProcedure();
        this.forEachEntry(p2);
        return p2.getHashCode();
    }

    protected void removeAt(int index2) {
        this._values[index2] = 0.0f;
        super.removeAt(index2);
    }

    public float[] getValues() {
        float[] vals = new float[this.size()];
        float[] v2 = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                vals[j2++] = v2[i2];
            }
        }
        return vals;
    }

    public float[] keys() {
        float[] keys2 = new float[this.size()];
        float[] k2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i2 = states.length;
            int j2 = 0;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                keys2[j2++] = k2[i2];
            }
        }
        return keys2;
    }

    public boolean containsValue(float val) {
        byte[] states = this._states;
        float[] vals = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || val != vals[i2]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TFloatProcedure procedure) {
        byte[] states = this._states;
        float[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TFloatFloatProcedure procedure) {
        byte[] states = this._states;
        float[] keys2 = this._set;
        float[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TFloatFloatProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys2 = this._set;
        float[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1 || procedure.execute(keys2[i2], values2[i2])) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TFloatFunction function) {
        byte[] states = this._states;
        float[] values2 = this._values;
        if (states != null) {
            int i2 = states.length;
            while (i2-- > 0) {
                if (states[i2] != 1) continue;
                values2[i2] = function.execute(values2[i2]);
            }
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, 1.0f);
    }

    public boolean adjustValue(float key, float amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n2 = index2;
        this._values[n2] = this._values[n2] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            float val = stream.readFloat();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TFloatFloatProcedure(){

            public boolean execute(float key, float value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TFloatFloatProcedure {
        private final TFloatFloatHashMap _otherMap;

        EqProcedure(TFloatFloatHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(float key, float value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(float v1, float v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TFloatFloatProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, float value) {
            this.h += TFloatFloatHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

