/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TLinkable;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLinkedList<T extends TLinkable>
extends AbstractSequentialList<T>
implements Serializable {
    protected T _head;
    protected T _tail;
    protected int _size;

    @Override
    public ListIterator<T> listIterator(int index2) {
        return new IteratorImpl(index2);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void add(int index2, T linkable) {
        if (index2 < 0 || index2 > this.size()) {
            throw new IndexOutOfBoundsException("index:" + index2);
        }
        this.insert(index2, linkable);
    }

    @Override
    public boolean add(T linkable) {
        this.insert(this._size, linkable);
        return true;
    }

    @Override
    public void addFirst(T linkable) {
        this.insert(0, linkable);
    }

    @Override
    public void addLast(T linkable) {
        this.insert(this.size(), linkable);
    }

    @Override
    public void clear() {
        if (null != this._head) {
            for (TLinkable link = this._head.getNext(); link != null; link = link.getNext()) {
                TLinkable prev = link.getPrevious();
                prev.setNext(null);
                link.setPrevious(null);
            }
            this._tail = null;
            this._head = null;
        }
        this._size = 0;
    }

    @Override
    public Object[] toArray() {
        Object[] o2 = new Object[this._size];
        int i2 = 0;
        for (Object link = this._head; link != null; link = link.getNext()) {
            o2[i2++] = link;
        }
        return o2;
    }

    public Object[] toUnlinkedArray() {
        Object[] o2 = new Object[this._size];
        int i2 = 0;
        Object link = this._head;
        while (link != null) {
            o2[i2] = link;
            T tmp = link;
            link = link.getNext();
            tmp.setNext(null);
            tmp.setPrevious(null);
            ++i2;
        }
        this._size = 0;
        this._tail = null;
        this._head = null;
        return o2;
    }

    @Override
    public boolean contains(Object o2) {
        for (Object link = this._head; link != null; link = link.getNext()) {
            if (!o2.equals(link)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T getFirst() {
        return this._head;
    }

    @Override
    public T getLast() {
        return this._tail;
    }

    @Override
    public T removeFirst() {
        T o2 = this._head;
        TLinkable n2 = o2.getNext();
        o2.setNext(null);
        if (null != n2) {
            n2.setPrevious(null);
        }
        this._head = n2;
        if (--this._size == 0) {
            this._tail = null;
        }
        return o2;
    }

    @Override
    public T removeLast() {
        T o2 = this._tail;
        TLinkable prev = o2.getPrevious();
        o2.setPrevious(null);
        if (null != prev) {
            prev.setNext(null);
        }
        this._tail = prev;
        if (--this._size == 0) {
            this._head = null;
        }
        return o2;
    }

    protected void insert(int index2, T linkable) {
        T newLink = linkable;
        if (this._size == 0) {
            this._tail = newLink;
            this._head = this._tail;
        } else if (index2 == 0) {
            newLink.setNext((TLinkable)this._head);
            this._head.setPrevious((TLinkable)newLink);
            this._head = newLink;
        } else if (index2 == this._size) {
            this._tail.setNext((TLinkable)newLink);
            newLink.setPrevious((TLinkable)this._tail);
            this._tail = newLink;
        } else {
            int pos;
            Object prior;
            if (index2 > this._size >> 1) {
                prior = this._tail;
                for (pos = this._size - 1; pos > index2; --pos) {
                    prior = prior.getPrevious();
                }
            } else {
                prior = this._head;
                for (pos = 0; pos < index2; ++pos) {
                    prior = prior.getNext();
                }
            }
            TLinkable post = prior.getNext();
            newLink.setNext(post);
            newLink.setPrevious((TLinkable)prior);
            post.setPrevious((TLinkable)newLink);
            prior.setNext((TLinkable)newLink);
        }
        ++this._size;
    }

    @Override
    public boolean remove(Object o2) {
        if (o2 instanceof TLinkable) {
            TLinkable link = (TLinkable)o2;
            TLinkable p2 = link.getPrevious();
            TLinkable n2 = link.getNext();
            if (n2 == null && p2 == null) {
                this._tail = null;
                this._head = null;
            } else if (n2 == null) {
                link.setPrevious(null);
                p2.setNext(null);
                this._tail = p2;
            } else if (p2 == null) {
                link.setNext(null);
                n2.setPrevious(null);
                this._head = n2;
            } else {
                p2.setNext(n2);
                n2.setPrevious(p2);
                link.setNext(null);
                link.setPrevious(null);
            }
            --this._size;
            return true;
        }
        return false;
    }

    public void addBefore(T current2, T newElement) {
        if (current2 == this._head) {
            this.addFirst(newElement);
        } else if (current2 == null) {
            this.addLast(newElement);
        } else {
            TLinkable p2 = current2.getPrevious();
            newElement.setNext((TLinkable)current2);
            p2.setNext((TLinkable)newElement);
            newElement.setPrevious(p2);
            current2.setPrevious((TLinkable)newElement);
            ++this._size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class IteratorImpl
    implements ListIterator<T> {
        private int _nextIndex;
        private T _next;
        private T _lastReturned;

        IteratorImpl(int position) {
            if (position < 0 || position > TLinkedList.this._size) {
                throw new IndexOutOfBoundsException();
            }
            this._nextIndex = position;
            if (position == 0) {
                this._next = TLinkedList.this._head;
            } else if (position == TLinkedList.this._size) {
                this._next = null;
            } else if (position < TLinkedList.this._size >> 1) {
                this._next = TLinkedList.this._head;
                for (int pos = 0; pos < position; ++pos) {
                    this._next = this._next.getNext();
                }
            } else {
                this._next = TLinkedList.this._tail;
                for (int pos = TLinkedList.this._size - 1; pos > position; --pos) {
                    this._next = this._next.getPrevious();
                }
            }
        }

        @Override
        public final void add(T linkable) {
            this._lastReturned = null;
            ++this._nextIndex;
            if (TLinkedList.this._size == 0) {
                TLinkedList.this.add(linkable);
            } else {
                TLinkedList.this.addBefore(this._next, linkable);
            }
        }

        @Override
        public final boolean hasNext() {
            return this._nextIndex != TLinkedList.this._size;
        }

        @Override
        public final boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public final T next() {
            if (this._nextIndex == TLinkedList.this._size) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._next;
            this._next = this._next.getNext();
            ++this._nextIndex;
            return this._lastReturned;
        }

        @Override
        public final int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public final T previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            if (this._nextIndex == TLinkedList.this._size) {
                this._next = TLinkedList.this._tail;
                this._lastReturned = this._next;
            } else {
                this._next = this._next.getPrevious();
                this._lastReturned = this._next;
            }
            --this._nextIndex;
            return this._lastReturned;
        }

        @Override
        public final int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public final void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException("must invoke next or previous before invoking remove");
            }
            if (this._lastReturned != this._next) {
                --this._nextIndex;
            }
            this._next = this._lastReturned.getNext();
            TLinkedList.this.remove(this._lastReturned);
            this._lastReturned = null;
        }

        @Override
        public final void set(T linkable) {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            Object l2 = linkable;
            if (this._lastReturned == TLinkedList.this._head) {
                TLinkedList.this._head = l2;
            }
            if (this._lastReturned == TLinkedList.this._tail) {
                TLinkedList.this._tail = l2;
            }
            this.swap(this._lastReturned, l2);
            this._lastReturned = l2;
        }

        private void swap(T from2, T to) {
            TLinkable p2 = from2.getPrevious();
            TLinkable n2 = from2.getNext();
            if (null != p2) {
                to.setPrevious(p2);
                p2.setNext((TLinkable)to);
            }
            if (null != n2) {
                to.setNext(n2);
                n2.setPrevious((TLinkable)to);
            }
            from2.setNext(null);
            from2.setPrevious(null);
        }
    }
}

