/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TObjectHash<T>
extends THash
implements TObjectHashingStrategy<T> {
    protected transient Object[] _set;
    protected final TObjectHashingStrategy<T> _hashingStrategy;
    public static final Object REMOVED = new Object();
    public static final NULL NULL = new NULL();

    public TObjectHash() {
        this._hashingStrategy = this;
    }

    public TObjectHash(TObjectHashingStrategy<T> strategy) {
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, TObjectHashingStrategy<T> strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, float loadFactor, TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TObjectHash<T> clone() {
        TObjectHash h2 = (TObjectHash)super.clone();
        h2._set = this._set == EMPTY_OBJECT_ARRAY ? EMPTY_OBJECT_ARRAY : (Object[])this._set.clone();
        return h2;
    }

    @Override
    protected int capacity() {
        return this._set.length;
    }

    @Override
    protected void removeAt(int index2) {
        this._set[index2] = REMOVED;
        super.removeAt(index2);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = initialCapacity == -1 ? EMPTY_OBJECT_ARRAY : new Object[capacity];
        return capacity;
    }

    public boolean forEach(TObjectProcedure<T> procedure) {
        Object[] set = this._set;
        int i2 = set.length;
        while (i2-- > 0) {
            if (set[i2] == null || set[i2] == REMOVED || procedure.execute(set[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected int index(T obj) {
        Object[] set = this._set;
        if (set == EMPTY_OBJECT_ARRAY) {
            return -1;
        }
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index2 = hash % length;
        Object cur = set[index2];
        if (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while ((cur = set[index2]) != null && (cur == REMOVED || !this._hashingStrategy.equals(cur, obj)));
        }
        return cur == null ? -1 : index2;
    }

    protected int insertionIndex(T obj) {
        int firstRemoved;
        if (this._set == EMPTY_OBJECT_ARRAY) {
            this.setUp(6);
        }
        Object[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index2 = hash % length;
        Object cur = set[index2];
        if (cur == null) {
            return index2;
        }
        if (cur != REMOVED && this._hashingStrategy.equals(cur, obj)) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n2 = firstRemoved = cur == REMOVED ? index2 : -1;
        do {
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            cur = set[index2];
            if (firstRemoved != -1 || cur != REMOVED) continue;
            firstRemoved = index2;
        } while (cur != null && cur != REMOVED && !this._hashingStrategy.equals(cur, obj));
        if (cur == REMOVED) {
            while (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
                if ((index2 -= probe) < 0) {
                    index2 += length;
                }
                cur = set[index2];
            }
        }
        if (cur != null) {
            return -index2 - 1;
        }
        return firstRemoved == -1 ? index2 : firstRemoved;
    }

    @Override
    public final int computeHashCode(T o2) {
        return o2 != null ? o2.hashCode() : 0;
    }

    @Override
    public final boolean equals(T o1, T o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals() or TObjectHashingStrategy.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + (o1 == null ? "" : " (" + o1.getClass() + ")") + ", hashCode=" + this._hashingStrategy.computeHashCode(o1) + "; object #2 =" + o2 + (o2 == null ? "" : " (" + o2.getClass() + ")") + ", hashCode=" + this._hashingStrategy.computeHashCode(o2));
    }

    private static class NULL {
        NULL() {
        }
    }
}

