/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TDoubleFloatHashMap;
import gnu.trove.TDoubleFloatIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDoubleFloatHashMapDecorator
extends AbstractMap<Double, Float> {
    protected final TDoubleFloatHashMap _map;

    public TDoubleFloatHashMapDecorator(TDoubleFloatHashMap map2) {
        this._map = map2;
    }

    @Override
    public Float put(Double key, Float value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e2 = it.next();
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (key instanceof Double && val instanceof Float) {
                    double k2 = this.unwrapKey(key);
                    float v2 = this.unwrapValue(val);
                    if (this._map.containsKey(k2) && v2 == this._map.get(k2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Float get(Object object) {
        return this.get((Double)object);
    }

    public Float get(Double key) {
        double k2 = this.unwrapKey(key);
        float v2 = this._map.get(k2);
        if (v2 == 0.0f) {
            return this._map.containsKey(k2) ? this.wrapValue(v2) : null;
        }
        return this.wrapValue(v2);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Float remove(Double key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Float remove(Object object) {
        return this.remove((Double)object);
    }

    @Override
    public Set<Map.Entry<Double, Float>> entrySet() {
        return new AbstractSet<Map.Entry<Double, Float>>(){

            @Override
            public int size() {
                return TDoubleFloatHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TDoubleFloatHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                if (o2 instanceof Map.Entry) {
                    Object k2 = ((Map.Entry)o2).getKey();
                    Object v2 = ((Map.Entry)o2).getValue();
                    return TDoubleFloatHashMapDecorator.this.containsKey(k2) && TDoubleFloatHashMapDecorator.this.get(k2).equals(v2);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Double, Float>> iterator() {
                return new Iterator<Map.Entry<Double, Float>>(){
                    private final TDoubleFloatIterator it;
                    {
                        this.it = TDoubleFloatHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Double, Float> next() {
                        this.it.advance();
                        final Double key = TDoubleFloatHashMapDecorator.this.wrapKey(this.it.key());
                        final Float v2 = TDoubleFloatHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Double, Float>(){
                            private Float val;
                            {
                                this.val = v2;
                            }

                            @Override
                            public boolean equals(Object o2) {
                                return o2 instanceof Map.Entry && ((Map.Entry)o2).getKey().equals(key) && ((Map.Entry)o2).getValue().equals(this.val);
                            }

                            @Override
                            public Double getKey() {
                                return key;
                            }

                            @Override
                            public Float getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Float setValue(Float value) {
                                this.val = value;
                                return TDoubleFloatHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Double, Float> o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Double, Float>> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TDoubleFloatHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Float> map2) {
        Iterator<Map.Entry<? extends Double, ? extends Float>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<? extends Double, ? extends Float> e2 = it.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    protected Double wrapKey(double k2) {
        return new Double(k2);
    }

    protected double unwrapKey(Object key) {
        return (Double)key;
    }

    protected Float wrapValue(float k2) {
        return new Float(k2);
    }

    protected float unwrapValue(Object value) {
        return ((Float)value).floatValue();
    }
}

