/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntLongIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIntLongHashMapDecorator
extends AbstractMap<Integer, Long> {
    protected final TIntLongHashMap _map;

    public TIntLongHashMapDecorator(TIntLongHashMap map2) {
        this._map = map2;
    }

    @Override
    public Long put(Integer key, Long value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e2 = it.next();
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (key instanceof Integer && val instanceof Long) {
                    int k2 = this.unwrapKey(key);
                    long v2 = this.unwrapValue(val);
                    if (this._map.containsKey(k2) && v2 == this._map.get(k2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Long get(Object object) {
        return this.get((Integer)object);
    }

    public Long get(Integer key) {
        int k2 = this.unwrapKey(key);
        long v2 = this._map.get(k2);
        if (v2 == 0L) {
            return this._map.containsKey(k2) ? this.wrapValue(v2) : null;
        }
        return this.wrapValue(v2);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Long remove(Integer key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Long remove(Object object) {
        return this.remove((Integer)object);
    }

    @Override
    public Set<Map.Entry<Integer, Long>> entrySet() {
        return new AbstractSet<Map.Entry<Integer, Long>>(){

            @Override
            public int size() {
                return TIntLongHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TIntLongHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                if (o2 instanceof Map.Entry) {
                    Object k2 = ((Map.Entry)o2).getKey();
                    Object v2 = ((Map.Entry)o2).getValue();
                    return TIntLongHashMapDecorator.this.containsKey(k2) && TIntLongHashMapDecorator.this.get(k2).equals(v2);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Integer, Long>> iterator() {
                return new Iterator<Map.Entry<Integer, Long>>(){
                    private final TIntLongIterator it;
                    {
                        this.it = TIntLongHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Integer, Long> next() {
                        this.it.advance();
                        final Integer key = TIntLongHashMapDecorator.this.wrapKey(this.it.key());
                        final Long v2 = TIntLongHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Integer, Long>(){
                            private Long val;
                            {
                                this.val = v2;
                            }

                            @Override
                            public boolean equals(Object o2) {
                                return o2 instanceof Map.Entry && ((Map.Entry)o2).getKey().equals(key) && ((Map.Entry)o2).getValue().equals(this.val);
                            }

                            @Override
                            public Integer getKey() {
                                return key;
                            }

                            @Override
                            public Long getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Long setValue(Long value) {
                                this.val = value;
                                return TIntLongHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Integer, Long> o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Integer, Long>> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TIntLongHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Long> map2) {
        Iterator<Map.Entry<? extends Integer, ? extends Long>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<? extends Integer, ? extends Long> e2 = it.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    protected Integer wrapKey(int k2) {
        return new Integer(k2);
    }

    protected int unwrapKey(Object key) {
        return (Integer)key;
    }

    protected Long wrapValue(long k2) {
        return new Long(k2);
    }

    protected long unwrapValue(Object value) {
        return (Long)value;
    }
}

