/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TLongIntHashMap;
import gnu.trove.TLongIntIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLongIntHashMapDecorator
extends AbstractMap<Long, Integer> {
    protected final TLongIntHashMap _map;

    public TLongIntHashMapDecorator(TLongIntHashMap map2) {
        this._map = map2;
    }

    @Override
    public Integer put(Long key, Integer value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e2 = it.next();
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (key instanceof Long && val instanceof Integer) {
                    long k2 = this.unwrapKey(key);
                    int v2 = this.unwrapValue(val);
                    if (this._map.containsKey(k2) && v2 == this._map.get(k2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Integer get(Object object) {
        return this.get((Long)object);
    }

    public Integer get(Long key) {
        long k2 = this.unwrapKey(key);
        int v2 = this._map.get(k2);
        if (v2 == 0) {
            return this._map.containsKey(k2) ? this.wrapValue(v2) : null;
        }
        return this.wrapValue(v2);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Integer remove(Long key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Integer remove(Object object) {
        return this.remove((Long)object);
    }

    @Override
    public Set<Map.Entry<Long, Integer>> entrySet() {
        return new AbstractSet<Map.Entry<Long, Integer>>(){

            @Override
            public int size() {
                return TLongIntHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TLongIntHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                if (o2 instanceof Map.Entry) {
                    Object k2 = ((Map.Entry)o2).getKey();
                    Object v2 = ((Map.Entry)o2).getValue();
                    return TLongIntHashMapDecorator.this.containsKey(k2) && TLongIntHashMapDecorator.this.get(k2).equals(v2);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Long, Integer>> iterator() {
                return new Iterator<Map.Entry<Long, Integer>>(){
                    private final TLongIntIterator it;
                    {
                        this.it = TLongIntHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Long, Integer> next() {
                        this.it.advance();
                        final Long key = TLongIntHashMapDecorator.this.wrapKey(this.it.key());
                        final Integer v2 = TLongIntHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Long, Integer>(){
                            private Integer val;
                            {
                                this.val = v2;
                            }

                            @Override
                            public boolean equals(Object o2) {
                                return o2 instanceof Map.Entry && ((Map.Entry)o2).getKey().equals(key) && ((Map.Entry)o2).getValue().equals(this.val);
                            }

                            @Override
                            public Long getKey() {
                                return key;
                            }

                            @Override
                            public Integer getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Integer setValue(Integer value) {
                                this.val = value;
                                return TLongIntHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Long, Integer> o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Long, Integer>> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TLongIntHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Integer> map2) {
        Iterator<Map.Entry<? extends Long, ? extends Integer>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<? extends Long, ? extends Integer> e2 = it.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    protected Long wrapKey(long k2) {
        return new Long(k2);
    }

    protected long unwrapKey(Object key) {
        return (Long)key;
    }

    protected Integer wrapValue(int k2) {
        return new Integer(k2);
    }

    protected int unwrapValue(Object value) {
        return (Integer)value;
    }
}

