/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TObjectFloatHashMap;
import gnu.trove.TObjectFloatIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectFloatHashMapDecorator<V>
extends AbstractMap<V, Float>
implements Map<V, Float> {
    protected final TObjectFloatHashMap<V> _map;

    public TObjectFloatHashMapDecorator(TObjectFloatHashMap<V> map2) {
        this._map = map2;
    }

    @Override
    public Float put(V key, Float value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e2 = it.next();
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (val instanceof Float) {
                    V k2 = this.unwrapKey(key);
                    float v2 = this.unwrapValue(val);
                    if (this._map.containsKey(k2) && v2 == this._map.get(k2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        V k2 = this.unwrapKey(key);
        float v2 = this._map.get(k2);
        if (v2 == 0.0f) {
            return this._map.containsKey(k2) ? this.wrapValue(v2) : null;
        }
        return this.wrapValue(v2);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Float remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<V, Float>> entrySet() {
        return new AbstractSet<Map.Entry<V, Float>>(){

            @Override
            public int size() {
                return TObjectFloatHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TObjectFloatHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                if (o2 instanceof Map.Entry) {
                    Object k2 = ((Map.Entry)o2).getKey();
                    Object v2 = ((Map.Entry)o2).getValue();
                    return TObjectFloatHashMapDecorator.this.containsKey(k2) && TObjectFloatHashMapDecorator.this.get(k2).equals(v2);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<V, Float>> iterator() {
                return new Iterator<Map.Entry<V, Float>>(){
                    private final TObjectFloatIterator<V> it;
                    {
                        this.it = TObjectFloatHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<V, Float> next() {
                        this.it.advance();
                        final Object key = TObjectFloatHashMapDecorator.this.wrapKey(this.it.key());
                        final Float v2 = TObjectFloatHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<V, Float>(){
                            private Float val;
                            {
                                this.val = v2;
                            }

                            @Override
                            public boolean equals(Object o2) {
                                return o2 instanceof Map.Entry && ((Map.Entry)o2).getKey().equals(key) && ((Map.Entry)o2).getValue().equals(this.val);
                            }

                            @Override
                            public V getKey() {
                                return key;
                            }

                            @Override
                            public Float getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Float setValue(Float value) {
                                this.val = value;
                                return TObjectFloatHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<V, Float> o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<V, Float>> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TObjectFloatHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends V, ? extends Float> map2) {
        Iterator<Map.Entry<V, Float>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<V, Float> e2 = it.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    protected final V wrapKey(Object o2) {
        return (V)o2;
    }

    protected final V unwrapKey(Object key) {
        return (V)key;
    }

    protected Float wrapValue(float k2) {
        return new Float(k2);
    }

    protected float unwrapValue(Object value) {
        return ((Float)value).floatValue();
    }
}

