/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectIntHashMapDecorator<V>
extends AbstractMap<V, Integer>
implements Map<V, Integer> {
    protected final TObjectIntHashMap<V> _map;

    public TObjectIntHashMapDecorator(TObjectIntHashMap<V> map2) {
        this._map = map2;
    }

    @Override
    public Integer put(V key, Integer value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e2 = it.next();
                Object key = e2.getKey();
                Object val = e2.getValue();
                if (val instanceof Integer) {
                    V k2 = this.unwrapKey(key);
                    int v2 = this.unwrapValue(val);
                    if (this._map.containsKey(k2) && v2 == this._map.get(k2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        V k2 = this.unwrapKey(key);
        int v2 = this._map.get(k2);
        if (v2 == 0) {
            return this._map.containsKey(k2) ? this.wrapValue(v2) : null;
        }
        return this.wrapValue(v2);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Integer remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<V, Integer>> entrySet() {
        return new AbstractSet<Map.Entry<V, Integer>>(){

            @Override
            public int size() {
                return TObjectIntHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TObjectIntHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o2) {
                if (o2 instanceof Map.Entry) {
                    Object k2 = ((Map.Entry)o2).getKey();
                    Object v2 = ((Map.Entry)o2).getValue();
                    return TObjectIntHashMapDecorator.this.containsKey(k2) && TObjectIntHashMapDecorator.this.get(k2).equals(v2);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<V, Integer>> iterator() {
                return new Iterator<Map.Entry<V, Integer>>(){
                    private final TObjectIntIterator<V> it;
                    {
                        this.it = TObjectIntHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<V, Integer> next() {
                        this.it.advance();
                        final Object key = TObjectIntHashMapDecorator.this.wrapKey(this.it.key());
                        final Integer v2 = TObjectIntHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<V, Integer>(){
                            private Integer val;
                            {
                                this.val = v2;
                            }

                            @Override
                            public boolean equals(Object o2) {
                                return o2 instanceof Map.Entry && ((Map.Entry)o2).getKey().equals(key) && ((Map.Entry)o2).getValue().equals(this.val);
                            }

                            @Override
                            public V getKey() {
                                return key;
                            }

                            @Override
                            public Integer getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Integer setValue(Integer value) {
                                this.val = value;
                                return TObjectIntHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<V, Integer> o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<V, Integer>> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TObjectIntHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends V, ? extends Integer> map2) {
        Iterator<Map.Entry<V, Integer>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<V, Integer> e2 = it.next();
            this.put(e2.getKey(), e2.getValue());
        }
    }

    protected final V wrapKey(Object o2) {
        return (V)o2;
    }

    protected final V unwrapKey(Object key) {
        return (V)key;
    }

    protected Integer wrapValue(int k2) {
        return new Integer(k2);
    }

    protected int unwrapValue(Object value) {
        return (Integer)value;
    }
}

