/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage.propagation;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class BaggageCodec {
    private static final byte ESCAPE_CHAR = 37;
    private static final int RADIX = 16;

    private BaggageCodec() {
    }

    private static byte[] decode(byte[] bytes2) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            byte b2 = bytes2[i2];
            if (b2 == 37) {
                try {
                    int u2 = BaggageCodec.digit16(bytes2[++i2]);
                    int l2 = BaggageCodec.digit16(bytes2[++i2]);
                    buffer.write((char)((u2 << 4) + l2));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    throw new IllegalArgumentException("Invalid URL encoding: ", e2);
                }
            }
            buffer.write(b2);
        }
        return buffer.toByteArray();
    }

    static String decode(String value, Charset charset) {
        byte[] bytes2 = BaggageCodec.decode(value.getBytes(StandardCharsets.US_ASCII));
        return new String(bytes2, charset);
    }

    private static int digit16(byte b2) {
        int i2 = Character.digit((char)b2, 16);
        if (i2 == -1) {
            throw new IllegalArgumentException("Invalid URL encoding: not a valid digit (radix 16): " + b2);
        }
        return i2;
    }
}

