/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class InternalAttributeKeyImpl<T>
implements AttributeKey<T> {
    private final AttributeType type;
    private final String key;
    private final int hashCode;
    @Nullable
    private byte[] keyUtf8;

    private InternalAttributeKeyImpl(AttributeType type, String key) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        this.key = key;
        this.hashCode = InternalAttributeKeyImpl.buildHashCode(type, key);
    }

    public static <T> AttributeKey<T> create(@Nullable String key, AttributeType type) {
        return new InternalAttributeKeyImpl<T>(type, key != null ? key : "");
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public byte[] getKeyUtf8() {
        byte[] keyUtf8 = this.keyUtf8;
        if (keyUtf8 == null) {
            this.keyUtf8 = keyUtf8 = this.key.getBytes(StandardCharsets.UTF_8);
        }
        return keyUtf8;
    }

    public boolean equals(@Nullable Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof InternalAttributeKeyImpl) {
            InternalAttributeKeyImpl that = (InternalAttributeKeyImpl)o2;
            return this.type.equals((Object)that.getType()) && this.key.equals(that.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.key;
    }

    private int buildHashCode() {
        return InternalAttributeKeyImpl.buildHashCode(this.type, this.key);
    }

    private static int buildHashCode(AttributeType type, String key) {
        int result2 = 1;
        result2 *= 1000003;
        result2 ^= type.hashCode();
        result2 *= 1000003;
        return result2 ^= key.hashCode();
    }
}

