/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

final class MultiTextMapPropagator
implements TextMapPropagator {
    private final TextMapPropagator[] textMapPropagators;
    private final Collection<String> allFields;

    MultiTextMapPropagator(TextMapPropagator ... textMapPropagators) {
        this(Arrays.asList(textMapPropagators));
    }

    MultiTextMapPropagator(List<TextMapPropagator> textMapPropagators) {
        this.textMapPropagators = new TextMapPropagator[textMapPropagators.size()];
        textMapPropagators.toArray(this.textMapPropagators);
        this.allFields = Collections.unmodifiableList(MultiTextMapPropagator.getAllFields(this.textMapPropagators));
    }

    @Override
    public Collection<String> fields() {
        return this.allFields;
    }

    private static List<String> getAllFields(TextMapPropagator[] textPropagators) {
        LinkedHashSet<String> fields2 = new LinkedHashSet<String>();
        for (TextMapPropagator textPropagator : textPropagators) {
            fields2.addAll(textPropagator.fields());
        }
        return new ArrayList<String>(fields2);
    }

    @Override
    public <C> void inject(Context context2, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context2 == null || setter == null) {
            return;
        }
        for (TextMapPropagator textPropagator : this.textMapPropagators) {
            textPropagator.inject(context2, carrier, setter);
        }
    }

    @Override
    public <C> Context extract(Context context2, @Nullable C carrier, TextMapGetter<C> getter) {
        if (context2 == null) {
            return Context.root();
        }
        if (getter == null) {
            return context2;
        }
        for (TextMapPropagator textPropagator : this.textMapPropagators) {
            context2 = textPropagator.extract(context2, carrier, getter);
        }
        return context2;
    }

    public String toString() {
        return "MultiTextMapPropagator{textMapPropagators=" + Arrays.toString(this.textMapPropagators) + '}';
    }
}

