/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.incubator.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.extension.incubator.propagation.CaseInsensitiveMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class ExtendedContextPropagators {
    private static final TextMapGetter<Map<String, String>> TEXT_MAP_GETTER = new TextMapGetter<Map<String, String>>(){

        public Set<String> keys(Map<String, String> carrier) {
            return carrier.keySet();
        }

        @Override
        @Nullable
        public String get(@Nullable Map<String, String> carrier, String key) {
            return carrier == null ? null : carrier.get(key);
        }
    };

    private ExtendedContextPropagators() {
    }

    public static Map<String, String> getTextMapPropagationContext(ContextPropagators propagators) {
        HashMap carrier = new HashMap();
        propagators.getTextMapPropagator().inject(Context.current(), carrier, (map2, key, value) -> {
            if (map2 != null) {
                map2.put(key, value);
            }
        });
        return Collections.unmodifiableMap(carrier);
    }

    public static Context extractTextMapPropagationContext(Map<String, String> carrier, ContextPropagators propagators) {
        Context current2 = Context.current();
        if (carrier == null) {
            return current2;
        }
        CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(carrier);
        return propagators.getTextMapPropagator().extract(current2, caseInsensitiveMap, TEXT_MAP_GETTER);
    }
}

