/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.incubator.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class PassThroughPropagator
implements TextMapPropagator {
    private static final ContextKey<List<String>> EXTRACTED_KEY_VALUES = ContextKey.named("passthroughpropagator-keyvalues");
    private final List<String> fields;

    private PassThroughPropagator(List<String> fields2) {
        this.fields = Collections.unmodifiableList(fields2);
    }

    public static TextMapPropagator create(String ... fields2) {
        Objects.requireNonNull(fields2, "fields");
        return PassThroughPropagator.create(Arrays.asList(fields2));
    }

    public static TextMapPropagator create(Iterable<String> fields2) {
        Objects.requireNonNull(fields2, "fields");
        List<String> fieldsList = StreamSupport.stream(fields2.spliterator(), false).map(field -> Objects.requireNonNull(field, "field")).collect(Collectors.toList());
        if (fieldsList.isEmpty()) {
            return TextMapPropagator.noop();
        }
        return new PassThroughPropagator(fieldsList);
    }

    @Override
    public Collection<String> fields() {
        return this.fields;
    }

    @Override
    public <C> void inject(Context context2, @Nullable C carrier, TextMapSetter<C> setter) {
        List<String> extracted = context2.get(EXTRACTED_KEY_VALUES);
        if (extracted != null) {
            for (int i2 = 0; i2 < extracted.size(); i2 += 2) {
                setter.set(carrier, extracted.get(i2), extracted.get(i2 + 1));
            }
        }
    }

    @Override
    public <C> Context extract(Context context2, @Nullable C carrier, TextMapGetter<C> getter) {
        ArrayList<String> extracted = null;
        for (String field : this.fields) {
            String value = getter.get(carrier, field);
            if (value == null) continue;
            if (extracted == null) {
                extracted = new ArrayList<String>();
            }
            extracted.add(field);
            extracted.add(value);
        }
        return extracted != null ? context2.with(EXTRACTED_KEY_VALUES, extracted) : context2;
    }

    public String toString() {
        return "PassThroughPropagator{fields=" + this.fields + "}";
    }
}

