/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.extension.incubator.metrics.ExtendedDoubleCounterBuilder;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SdkDoubleCounter
extends AbstractInstrument
implements DoubleCounter {
    private static final Logger logger = Logger.getLogger(SdkDoubleCounter.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkDoubleCounter(InstrumentDescriptor descriptor2, WriteableMetricStorage storage) {
        super(descriptor2);
        this.storage = storage;
    }

    @Override
    public void add(double increment, Attributes attributes, Context context2) {
        if (increment < 0.0) {
            this.throttlingLogger.log(Level.WARNING, "Counters can only increase. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(increment, attributes, context2);
    }

    @Override
    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    static final class SdkDoubleCounterBuilder
    implements ExtendedDoubleCounterBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name2, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name2, InstrumentType.COUNTER, InstrumentValueType.DOUBLE, meterProviderSharedState, sharedState).setUnit(unit).setDescription(description).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public SdkDoubleCounter build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1) -> new SdkDoubleCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public DoubleCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_COUNTER, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_COUNTER);
        }

        @Override
        public ExtendedDoubleCounterBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

