/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;

public final class TraceBasedExemplarFilter
implements ExemplarFilter {
    static final ExemplarFilter INSTANCE = new TraceBasedExemplarFilter();

    private TraceBasedExemplarFilter() {
    }

    @Override
    public boolean shouldSampleMeasurement(long value, Attributes attributes, Context context2) {
        return TraceBasedExemplarFilter.hasSampledTrace(context2);
    }

    @Override
    public boolean shouldSampleMeasurement(double value, Attributes attributes, Context context2) {
        return TraceBasedExemplarFilter.hasSampledTrace(context2);
    }

    private static boolean hasSampledTrace(Context context2) {
        return Span.fromContext(context2).getSpanContext().isSampled();
    }
}

