/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

public final class ByteArrays {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final byte[] DEFAULT_EMPTY_ARRAY = new byte[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<byte[]> HASH_STRATEGY = new a(0);

    private ByteArrays() {
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] forceCapacity(byte[] array2, int length, int preserve) {
        void var2_3;
        byte[] byArray;
        byte[] byArray2 = new byte[length];
        System.arraycopy(byArray, 0, byArray2, 0, (int)var2_3);
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] ensureCapacity(byte[] array2, int length) {
        byte[] byArray;
        void var1_1;
        return ByteArrays.ensureCapacity(array2, (int)var1_1, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] ensureCapacity(byte[] array2, int length, int preserve) {
        byte[] byArray;
        if (length > array2.length) {
            void var2_2;
            void var1_1;
            return ByteArrays.forceCapacity(array2, (int)var1_1, (int)var2_2);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] grow(byte[] array2, int length) {
        byte[] byArray;
        void var1_1;
        return ByteArrays.grow(array2, (int)var1_1, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] grow(byte[] array2, int length, int preserve) {
        byte[] byArray;
        if (length > array2.length) {
            void var2_3;
            void var1_1;
            byte[] byArray2 = new byte[(int)Math.max(Math.min((long)array2.length + (long)(array2.length >> 1), 0x7FFFFFF7L), (long)var1_1)];
            System.arraycopy(array2, 0, byArray2, 0, (int)var2_3);
            return byArray2;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] trim(byte[] array2, int length) {
        void var1_1;
        byte[] byArray;
        if (length >= array2.length) {
            return array2;
        }
        byte[] byArray2 = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(byArray, 0, byArray2, 0, (int)var1_1);
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] setLength(byte[] array2, int length) {
        void var1_1;
        byte[] byArray;
        if (length == array2.length) {
            return array2;
        }
        if (length < array2.length) {
            return ByteArrays.trim(array2, length);
        }
        return ByteArrays.ensureCapacity(byArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] copy(byte[] array2, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        ByteArrays.ensureOffsetLength(array2, offset, length);
        byte[] byArray2 = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(byArray, (int)var1_1, byArray2, 0, (int)var2_2);
        return byArray2;
    }

    public static byte[] copy(byte[] array2) {
        return (byte[])array2.clone();
    }

    @Deprecated
    public static void fill(byte[] array2, byte value) {
        int n2 = array2.length;
        while (n2-- != 0) {
            array2[n2] = value;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void fill(byte[] array2, int from2, int to, byte value) {
        ByteArrays.ensureFromTo(array2, from2, to);
        if (from2 == 0) {
            while (to-- != 0) {
                array2[to] = value;
            }
        } else {
            void var1_1;
            while (var1_1 < to) {
                array2[var1_1] = value;
                ++var1_1;
            }
        }
    }

    @Deprecated
    public static boolean equals(byte[] a1, byte[] a2) {
        int n2 = a1.length;
        if (n2 != a2.length) {
            return false;
        }
        while (n2-- != 0) {
            if (a1[n2] == a2[n2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureFromTo(byte[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        Arrays.ensureFromTo(a2.length, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureOffsetLength(byte[] a2, int offset, int length) {
        void var2_2;
        void var1_1;
        Arrays.ensureOffsetLength(a2.length, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureSameLength(byte[] a2, byte[] b2) {
        if (a2.length != b2.length) {
            void var1_1;
            byte[] byArray;
            throw new IllegalArgumentException("Array size mismatch: " + byArray.length + " != " + ((void)var1_1).length);
        }
    }

    private static ForkJoinPool a() {
        ForkJoinPool forkJoinPool = ForkJoinTask.getPool();
        if (forkJoinPool == null) {
            return ForkJoinPool.commonPool();
        }
        return forkJoinPool;
    }

    public static void swap(byte[] x2, int a2, int b2) {
        byte by = x2[a2];
        x2[var1_1] = x2[b2];
        var0[var2_2] = by;
    }

    public static void swap(byte[] x2, int a2, int b2, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            ByteArrays.swap(x2, a2, b2);
            ++n3;
            ++a2;
            ++b2;
        }
    }

    private static int b(byte[] byArray, int n2, int n3, int n4, ByteComparator byteComparator) {
        int n5 = byteComparator.compare(byArray[n2], byArray[n3]);
        int n6 = byteComparator.compare(byArray[n2], byArray[n4]);
        int n7 = byteComparator.compare(byArray[n3], byArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSort(byte[] x2, int from2, int to, ByteComparator comp) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n4 = from2;
                    for (n3 = from2 + 1; n3 < to; ++n3) {
                        if (comp.compare(x2[n3], x2[n4]) >= 0) continue;
                        n4 = n3;
                    }
                    if (n4 != from2) {
                        n3 = x2[from2];
                        x2[from2] = x2[n4];
                        x2[n4] = n3;
                    }
                    ++from2;
                }
                return;
            }
            n3 = from2 + n4 / 2;
            int n5 = from2;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from2;
                n5 = ByteArrays.b(x2, n7, n7 + (n4 /= 8), from2 + 2 * n4, comp);
                int n8 = n3;
                n3 = ByteArrays.b(x2, n3 - n4, n8, n8 + n4, comp);
                n6 = ByteArrays.b(x2, n6 - 2 * n4, n6 - n4, n6, comp);
            }
            n3 = ByteArrays.b(x2, n5, n3, n6, comp);
            n4 = x2[n3];
            n3 = from2;
            n5 = from2;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = comp.compare(x2[n5], (byte)n4)) <= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(x2, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = comp.compare(x2[n6], (byte)n4)) >= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(x2, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ByteArrays.swap(x2, n5++, n6--);
            }
            n2 = Math.min(n3 - from2, n5 - n3);
            ByteArrays.swap(x2, from2, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            ByteArrays.swap(x2, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from2;
                ByteArrays.quickSort(x2, n10, n10 + n2, comp);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void quickSort(byte[] x2, ByteComparator comp) {
        void var1_1;
        byte[] byArray;
        ByteArrays.quickSort(x2, 0, byArray.length, (ByteComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(byte[] x2, int from2, int to, ByteComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        ForkJoinPool forkJoinPool = ByteArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            ByteArrays.quickSort(x2, from2, to, comp);
            return;
        }
        forkJoinPool.invoke(new d(byArray, (int)var1_1, (int)var2_2, (ByteComparator)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(byte[] x2, ByteComparator comp) {
        void var1_1;
        byte[] byArray;
        ByteArrays.parallelQuickSort(x2, 0, byArray.length, (ByteComparator)var1_1);
    }

    private static int b(byte[] byArray, int n2, int n3, int n4) {
        int n5 = Byte.compare(byArray[n2], byArray[n3]);
        int n6 = Byte.compare(byArray[n2], byArray[n4]);
        int n7 = Byte.compare(byArray[n3], byArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSort(byte[] x2, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n4 = from2;
                    for (n3 = from2 + 1; n3 < to; ++n3) {
                        if (x2[n3] >= x2[n4]) continue;
                        n4 = n3;
                    }
                    if (n4 != from2) {
                        n3 = x2[from2];
                        x2[from2] = x2[n4];
                        x2[n4] = n3;
                    }
                    ++from2;
                }
                return;
            }
            n3 = from2 + n4 / 2;
            int n5 = from2;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from2;
                n5 = ByteArrays.b(x2, n7, n7 + (n4 /= 8), from2 + 2 * n4);
                int n8 = n3;
                n3 = ByteArrays.b(x2, n3 - n4, n8, n8 + n4);
                n6 = ByteArrays.b(x2, n6 - 2 * n4, n6 - n4, n6);
            }
            n3 = ByteArrays.b(x2, n5, n3, n6);
            n4 = x2[n3];
            n3 = from2;
            n5 = from2;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = Byte.compare(x2[n5], (byte)n4)) <= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(x2, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = Byte.compare(x2[n6], (byte)n4)) >= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(x2, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ByteArrays.swap(x2, n5++, n6--);
            }
            n2 = Math.min(n3 - from2, n5 - n3);
            ByteArrays.swap(x2, from2, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            ByteArrays.swap(x2, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from2;
                ByteArrays.quickSort(x2, n10, n10 + n2);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from2 = to - n2;
        }
    }

    public static void quickSort(byte[] x2) {
        byte[] byArray;
        ByteArrays.quickSort(x2, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(byte[] x2, int from2, int to) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        ForkJoinPool forkJoinPool = ByteArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            ByteArrays.quickSort(x2, from2, to);
            return;
        }
        forkJoinPool.invoke(new b(byArray, (int)var1_1, (int)var2_2));
    }

    public static void parallelQuickSort(byte[] x2) {
        byte[] byArray;
        ByteArrays.parallelQuickSort(x2, 0, byArray.length);
    }

    private static int b(int[] nArray, byte[] byArray, int n2, int n3, int n4) {
        int n5 = byArray[nArray[n2]];
        byte by = byArray[nArray[n3]];
        int n6 = byArray[nArray[n4]];
        int n7 = Byte.compare((byte)n5, by);
        n5 = Byte.compare((byte)n5, (byte)n6);
        n6 = Byte.compare(by, (byte)n6);
        if (n7 < 0) {
            if (n6 < 0) {
                return n3;
            }
            if (n5 < 0) {
                return n4;
            }
            return n2;
        }
        if (n6 > 0) {
            return n3;
        }
        if (n5 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSortIndirect(int[] perm, byte[] x2, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if ((n6 = to - from2) < 16) {
                n6 = from2;
                while (++n6 < to) {
                    n5 = perm[n6];
                    n4 = n6;
                    n3 = perm[n4 - 1];
                    while (x2[n5] < x2[n3]) {
                        perm[n4] = n3;
                        if (from2 == n4 - 1) {
                            --n4;
                            break;
                        }
                        n3 = perm[--n4 - 1];
                    }
                    perm[n4] = n5;
                }
                return;
            }
            n5 = from2 + n6 / 2;
            n4 = from2;
            n3 = to - 1;
            if (n6 > 128) {
                int n7 = from2;
                n4 = ByteArrays.b(perm, x2, n7, n7 + (n6 /= 8), from2 + 2 * n6);
                int n8 = n5;
                n5 = ByteArrays.b(perm, x2, n5 - n6, n8, n8 + n6);
                n3 = ByteArrays.b(perm, x2, n3 - 2 * n6, n3 - n6, n3);
            }
            n5 = ByteArrays.b(perm, x2, n4, n5, n3);
            n6 = x2[perm[n5]];
            n5 = from2;
            n4 = from2;
            int n9 = n3 = to - 1;
            while (true) {
                if (n4 <= n3 && (n2 = Byte.compare(x2[perm[n4]], (byte)n6)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(perm, n5++, n4);
                    }
                    ++n4;
                    continue;
                }
                while (n3 >= n4 && (n2 = Byte.compare(x2[perm[n3]], (byte)n6)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(perm, n3, n9--);
                    }
                    --n3;
                }
                if (n4 > n3) break;
                IntArrays.swap(perm, n4++, n3--);
            }
            n2 = Math.min(n5 - from2, n4 - n5);
            IntArrays.swap(perm, from2, n4 - n2, n2);
            n2 = Math.min(n9 - n3, to - n9 - 1);
            IntArrays.swap(perm, n4, to - n2, n2);
            n2 = n4 - n5;
            if (n2 > 1) {
                int n10 = from2;
                ByteArrays.quickSortIndirect(perm, x2, n10, n10 + n2);
            }
            if ((n2 = n9 - n3) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void quickSortIndirect(int[] perm, byte[] x2) {
        void var1_1;
        ByteArrays.quickSortIndirect(perm, x2, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSortIndirect(int[] perm, byte[] x2, int from2, int to) {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] nArray;
        ForkJoinPool forkJoinPool = ByteArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            ByteArrays.quickSortIndirect(perm, x2, from2, to);
            return;
        }
        forkJoinPool.invoke(new e(nArray, (byte[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSortIndirect(int[] perm, byte[] x2) {
        void var1_1;
        ByteArrays.parallelQuickSortIndirect(perm, x2, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static void stabilize(int[] perm, byte[] x2, int from2, int to) {
        void var2_2;
        int n2 = from2;
        ++var2_2;
        while (var2_2 < to) {
            if (x2[perm[var2_2]] != x2[perm[n2]]) {
                if (var2_2 - n2 > true) {
                    IntArrays.parallelQuickSort(perm, n2, (int)var2_2);
                }
                n2 = var2_2;
            }
            ++var2_2;
        }
        if (to - n2 > 1) {
            void var3_3;
            int[] nArray;
            IntArrays.parallelQuickSort(nArray, n2, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void stabilize(int[] perm, byte[] x2) {
        int[] nArray;
        void var1_1;
        ByteArrays.stabilize(perm, (byte[])var1_1, 0, nArray.length);
    }

    private static int c(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6 = Byte.compare(byArray[n2], byArray[n3]);
        int n7 = n6 == 0 ? Byte.compare(byArray2[n2], byArray2[n3]) : n6;
        n6 = Byte.compare(byArray[n2], byArray[n4]);
        int n8 = n6 == 0 ? Byte.compare(byArray2[n2], byArray2[n4]) : n6;
        n6 = Byte.compare(byArray[n3], byArray[n4]);
        int n9 = n5 = n6 == 0 ? Byte.compare(byArray2[n3], byArray2[n4]) : n6;
        if (n7 < 0) {
            if (n5 < 0) {
                return n3;
            }
            if (n8 < 0) {
                return n4;
            }
            return n2;
        }
        if (n5 > 0) {
            return n3;
        }
        if (n8 > 0) {
            return n4;
        }
        return n2;
    }

    private static void b(byte[] byArray, byte[] byArray2, int n2, int n3) {
        byte by = byArray[n2];
        byte by2 = byArray2[n2];
        byArray[n2] = byArray[n3];
        byArray2[n2] = byArray2[n3];
        byArray[n3] = by;
        byArray2[n3] = by2;
    }

    private static void d(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            ByteArrays.b(byArray, byArray2, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    public static void quickSort(byte[] x2, byte[] y2, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            byte by;
            int n4;
            int n5;
            if ((n5 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n5 = from2;
                    for (n4 = from2 + 1; n4 < to; ++n4) {
                        by = Byte.compare(x2[n4], x2[n5]);
                        if (by >= 0 && (by != 0 || y2[n4] >= y2[n5])) continue;
                        n5 = n4;
                    }
                    if (n5 != from2) {
                        n4 = x2[from2];
                        x2[from2] = x2[n5];
                        x2[n5] = n4;
                        n4 = y2[from2];
                        y2[from2] = y2[n5];
                        y2[n5] = n4;
                    }
                    ++from2;
                }
                return;
            }
            by = from2 + n5 / 2;
            n4 = from2;
            int n6 = to - 1;
            if (n5 > 128) {
                int n7 = from2;
                n4 = ByteArrays.c(x2, y2, n7, n7 + (n5 /= 8), from2 + 2 * n5);
                byte by2 = by;
                by = ByteArrays.c(x2, y2, by - n5, by2, by2 + n5);
                n6 = ByteArrays.c(x2, y2, n6 - 2 * n5, n6 - n5, n6);
            }
            by = ByteArrays.c(x2, y2, n4, by, n6);
            n5 = x2[by];
            by = y2[by];
            n4 = from2;
            n6 = from2;
            int n8 = n3 = to - 1;
            while (true) {
                if (n6 <= n3 && (n2 = (n2 = Byte.compare(x2[n6], (byte)n5)) == 0 ? Byte.compare(y2[n6], by) : n2) <= 0) {
                    if (n2 == 0) {
                        ByteArrays.b(x2, y2, n4++, n6);
                    }
                    ++n6;
                    continue;
                }
                while (n3 >= n6 && (n2 = (n2 = Byte.compare(x2[n3], (byte)n5)) == 0 ? Byte.compare(y2[n3], by) : n2) >= 0) {
                    if (n2 == 0) {
                        ByteArrays.b(x2, y2, n3, n8--);
                    }
                    --n3;
                }
                if (n6 > n3) break;
                ByteArrays.b(x2, y2, n6++, n3--);
            }
            n2 = Math.min(n4 - from2, n6 - n4);
            ByteArrays.d(x2, y2, from2, n6 - n2, n2);
            n2 = Math.min(n8 - n3, to - n8 - 1);
            ByteArrays.d(x2, y2, n6, to - n2, n2);
            n2 = n6 - n4;
            if (n2 > 1) {
                int n9 = from2;
                ByteArrays.quickSort(x2, y2, n9, n9 + n2);
            }
            if ((n2 = n8 - n3) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void quickSort(byte[] x2, byte[] y2) {
        byte[] byArray;
        void var1_1;
        ByteArrays.ensureSameLength(x2, y2);
        ByteArrays.quickSort(x2, (byte[])var1_1, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(byte[] x2, byte[] y2, int from2, int to) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        ForkJoinPool forkJoinPool = ByteArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            ByteArrays.quickSort(x2, y2, from2, to);
            return;
        }
        forkJoinPool.invoke(new c(byArray, (byte[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelQuickSort(byte[] x2, byte[] y2) {
        byte[] byArray;
        void var1_1;
        ByteArrays.ensureSameLength(x2, y2);
        ByteArrays.parallelQuickSort(x2, (byte[])var1_1, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(byte[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        java.util.Arrays.sort(a2, (int)var1_1, (int)var2_2);
    }

    public static void unstableSort(byte[] a2) {
        byte[] byArray;
        ByteArrays.unstableSort(a2, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(byte[] a2, int from2, int to, ByteComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrays.quickSort(a2, (int)var1_1, (int)var2_2, (ByteComparator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(byte[] a2, ByteComparator comp) {
        void var1_1;
        byte[] byArray;
        ByteArrays.unstableSort(a2, 0, byArray.length, (ByteComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(byte[] a2, int from2, int to, byte[] supp22) {
        byte[] supp22;
        int n2 = to - from2;
        if (n2 < 16) {
            int supp22 = from2;
            while (++supp22 < to) {
                n2 = a2[supp22];
                int n3 = supp22;
                byte by = a2[n3 - 1];
                while (n2 < by) {
                    a2[n3] = by;
                    if (from2 == n3 - 1) {
                        --n3;
                        break;
                    }
                    by = a2[--n3 - 1];
                }
                a2[n3] = n2;
            }
            return;
        }
        if (supp22 == null) {
            supp22 = java.util.Arrays.copyOf(a2, to);
        }
        int n4 = from2 + to >>> 1;
        ByteArrays.mergeSort(supp22, from2, n4, a2);
        ByteArrays.mergeSort(supp22, n4, to, a2);
        if (supp22[n4 - 1] <= supp22[n4]) {
            System.arraycopy(supp22, from2, a2, from2, n2);
            return;
        }
        int n5 = n4;
        for (n2 = from2; n2 < to; ++n2) {
            void var1_1;
            a2[n2] = n5 >= to || var1_1 < n4 && supp22[var1_1] <= supp22[n5] ? supp22[++var1_1] : supp22[n5++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(byte[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        ByteArrays.mergeSort(a2, (int)var1_1, (int)var2_2, null);
    }

    public static void mergeSort(byte[] a2) {
        byte[] byArray;
        ByteArrays.mergeSort(a2, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(byte[] a2, int from2, int to, ByteComparator comp, byte[] supp22) {
        byte[] supp22;
        int n2 = to - from2;
        if (n2 < 16) {
            int supp22 = from2;
            while (++supp22 < to) {
                n2 = a2[supp22];
                int n3 = supp22;
                byte by = a2[n3 - 1];
                while (comp.compare((byte)n2, by) < 0) {
                    a2[n3] = by;
                    if (from2 == n3 - 1) {
                        --n3;
                        break;
                    }
                    by = a2[--n3 - 1];
                }
                a2[n3] = n2;
            }
            return;
        }
        if (supp22 == null) {
            supp22 = java.util.Arrays.copyOf(a2, to);
        }
        int n4 = from2 + to >>> 1;
        ByteArrays.mergeSort(supp22, from2, n4, comp, a2);
        ByteArrays.mergeSort(supp22, n4, to, comp, a2);
        if (comp.compare(supp22[n4 - 1], supp22[n4]) <= 0) {
            System.arraycopy(supp22, from2, a2, from2, n2);
            return;
        }
        int n5 = n4;
        for (n2 = from2; n2 < to; ++n2) {
            void var1_1;
            a2[n2] = n5 >= to || var1_1 < n4 && comp.compare(supp22[var1_1], supp22[n5]) <= 0 ? supp22[++var1_1] : supp22[n5++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(byte[] a2, int from2, int to, ByteComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrays.mergeSort(a2, (int)var1_1, (int)var2_2, (ByteComparator)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(byte[] a2, ByteComparator comp) {
        void var1_1;
        byte[] byArray;
        ByteArrays.mergeSort(a2, 0, byArray.length, (ByteComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(byte[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        ByteArrays.unstableSort(a2, (int)var1_1, (int)var2_2);
    }

    public static void stableSort(byte[] a2) {
        byte[] byArray;
        ByteArrays.stableSort(a2, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(byte[] a2, int from2, int to, ByteComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrays.mergeSort(a2, (int)var1_1, (int)var2_2, (ByteComparator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(byte[] a2, ByteComparator comp) {
        void var1_1;
        byte[] byArray;
        ByteArrays.stableSort(a2, 0, byArray.length, (ByteComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int binarySearch(byte[] a2, int from2, int to, byte key) {
        void var1_1;
        --to;
        while (from2 <= to) {
            int n2 = from2 + to >>> 1;
            byte by = a2[n2];
            if (by < key) {
                from2 = n2 + 1;
                continue;
            }
            if (by > key) {
                to = n2 - 1;
                continue;
            }
            return n2;
        }
        return (int)(-(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static int binarySearch(byte[] a2, byte key) {
        void var1_1;
        byte[] byArray;
        return ByteArrays.binarySearch(a2, 0, byArray.length, (byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int binarySearch(byte[] a2, int from2, int to, byte key, ByteComparator c2) {
        void var1_1;
        --to;
        while (from2 <= to) {
            int n2 = from2 + to >>> 1;
            int n3 = a2[n2];
            if ((n3 = c2.compare((byte)n3, key)) < 0) {
                from2 = n2 + 1;
                continue;
            }
            if (n3 > 0) {
                to = n2 - 1;
                continue;
            }
            return n2;
        }
        return (int)(-(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static int binarySearch(byte[] a2, byte key, ByteComparator c2) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return ByteArrays.binarySearch(a2, 0, byArray.length, (byte)var1_1, (ByteComparator)var2_2);
    }

    public static void radixSort(byte[] a2) {
        byte[] byArray;
        ByteArrays.radixSort(a2, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(byte[] a2, int from2, int to) {
        void var1_1;
        void var2_3;
        if (to - from2 < 1024) {
            ByteArrays.quickSort(a2, from2, to);
            return;
        }
        int n2 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        nArray[0] = from2;
        nArray2[0] = var2_3 - var1_1;
        ++n2;
        nArray3[0] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        while (n2 > 0) {
            int n3;
            int n4 = nArray[--n2];
            int n5 = nArray2[n2];
            int n6 = nArray3[n2];
            int n7 = n4 + n5;
            while (n7-- != n4) {
                int n8 = a2[n7] & 0xFF ^ 0x80;
                nArray4[n8] = nArray4[n8] + 1;
            }
            n7 = -1;
            int n9 = n4;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray4[n3] != 0) {
                    n7 = n3;
                }
                nArray5[n3] = n9 += nArray4[n3];
            }
            n3 = n4 + n5 - nArray4[n7];
            for (n9 = n4; n9 <= n3; n9 += nArray4[n4]) {
                n7 = a2[n9];
                n4 = n7 & 0xFF ^ 0x80;
                if (n9 < n3) {
                    while (true) {
                        int n10 = n4;
                        int n11 = nArray5[n10] - 1;
                        nArray5[n10] = n11;
                        n5 = n11;
                        if (n11 <= n9) break;
                        n4 = n7;
                        n7 = a2[n5];
                        a2[n5] = n4;
                        n4 = n7 & 0xFF ^ 0x80;
                    }
                    a2[n9] = n7;
                }
                if (n6 < 0 && nArray4[n4] > 1) {
                    if (nArray4[n4] < 1024) {
                        int n12 = n9;
                        ByteArrays.quickSort(a2, n12, n12 + nArray4[n4]);
                    } else {
                        nArray[n2] = n9;
                        nArray2[n2] = nArray4[n4];
                        nArray3[n2++] = n6 + 1;
                    }
                }
                nArray4[n4] = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSort(byte[] a2, int from2, int to) {
        void var1_2;
        int n2;
        Object object = ByteArrays.a();
        if (to - from2 < 1024 || ((ForkJoinPool)object).getParallelism() == 1) {
            ByteArrays.quickSort(a2, from2, to);
            return;
        }
        LinkedBlockingQueue<Segment> linkedBlockingQueue = new LinkedBlockingQueue<Segment>();
        linkedBlockingQueue.add(new Segment(from2, (int)(n2 - var1_2), 0));
        AtomicInteger atomicInteger = new AtomicInteger(1);
        n2 = ((ForkJoinPool)object).getParallelism();
        object = new ExecutorCompletionService((Executor)object);
        int n3 = n2;
        while (n3-- != 0) {
            ((ExecutorCompletionService)object).submit(() -> {
                int[] nArray = new int[256];
                int[] nArray2 = new int[256];
                while (true) {
                    int n3;
                    Segment segment;
                    int n4;
                    if (atomicInteger.get() == 0) {
                        n4 = n2;
                        while (n4-- != 0) {
                            linkedBlockingQueue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)linkedBlockingQueue.take()) == POISON_PILL) {
                        return null;
                    }
                    int n5 = segment.a;
                    int n6 = segment.b;
                    n4 = segment.c;
                    int n7 = n5 + n6;
                    while (n7-- != n5) {
                        int n8 = a2[n7] & 0xFF ^ 0x80;
                        nArray[n8] = nArray[n8] + 1;
                    }
                    n7 = -1;
                    int n9 = n5;
                    for (n3 = 0; n3 < 256; ++n3) {
                        if (nArray[n3] != 0) {
                            n7 = n3;
                        }
                        nArray2[n3] = n9 += nArray[n3];
                    }
                    n3 = n5 + n6 - nArray[n7];
                    for (n9 = n5; n9 <= n3; n9 += nArray[n5]) {
                        n7 = a2[n9];
                        n5 = n7 & 0xFF ^ 0x80;
                        if (n9 < n3) {
                            while (true) {
                                int n10 = n5;
                                int n11 = nArray2[n10] - 1;
                                nArray2[n10] = n11;
                                n6 = n11;
                                if (n11 <= n9) break;
                                n5 = n7;
                                n7 = a2[n6];
                                byArray[n6] = n5;
                                n5 = n7 & 0xFF ^ 0x80;
                            }
                            byArray[n9] = n7;
                        }
                        if (n4 < 0 && nArray[n5] > 1) {
                            if (nArray[n5] < 1024) {
                                int n12 = n9;
                                ByteArrays.quickSort(a2, n12, n12 + nArray[n5]);
                            } else {
                                atomicInteger.incrementAndGet();
                                linkedBlockingQueue.add(new Segment(n9, nArray[n5], n4 + 1));
                            }
                        }
                        nArray[n5] = 0;
                    }
                    atomicInteger.decrementAndGet();
                }
            });
        }
        Throwable throwable = null;
        int n4 = n2;
        while (n4-- != 0) {
            try {
                ((ExecutorCompletionService)object).take().get();
            }
            catch (Exception exception) {
                throwable = exception.getCause();
            }
        }
        if (throwable != null) {
            throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
        }
    }

    public static void parallelRadixSort(byte[] a2) {
        byte[] byArray;
        ByteArrays.parallelRadixSort(a2, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSortIndirect(int[] perm, byte[] a2, boolean stable) {
        void var2_2;
        int[] nArray;
        void var1_1;
        ByteArrays.radixSortIndirect(perm, (byte[])var1_1, 0, nArray.length, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSortIndirect(int[] perm, byte[] a2, int from2, int to, boolean stable) {
        int[] nArray;
        void var2_2;
        void var3_4;
        if (to - from2 < 1024) {
            ByteArrays.quickSortIndirect(perm, a2, from2, to);
            if (stable) {
                ByteArrays.stabilize(perm, a2, from2, to);
            }
            return;
        }
        int n2 = 0;
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        nArray2[0] = from2;
        nArray3[0] = var3_4 - var2_2;
        ++n2;
        nArray4[0] = 0;
        int[] nArray5 = new int[256];
        int[] nArray6 = new int[256];
        int[] nArray7 = nArray = stable ? new int[perm.length] : null;
        while (n2 > 0) {
            int n3;
            int n4;
            int n5 = nArray2[--n2];
            int n6 = nArray3[n2];
            int n7 = nArray4[n2];
            int n8 = n5 + n6;
            while (n8-- != n5) {
                int n9 = a2[perm[n8]] & 0xFF ^ 0x80;
                nArray5[n9] = nArray5[n9] + 1;
            }
            n8 = -1;
            int n10 = n4 = stable ? 0 : n5;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray5[n3] != 0) {
                    n8 = n3;
                }
                nArray6[n3] = n4 += nArray5[n3];
            }
            if (stable) {
                n3 = n5 + n6;
                while (n3-- != n5) {
                    int n11 = a2[perm[n3]] & 0xFF ^ 0x80;
                    int n12 = nArray6[n11] - 1;
                    nArray6[n11] = n12;
                    nArray[n12] = perm[n3];
                }
                System.arraycopy(nArray, 0, perm, n5, n6);
                n4 = n5;
                for (n3 = 0; n3 <= n8; ++n3) {
                    if (n7 < 0 && nArray5[n3] > 1) {
                        if (nArray5[n3] < 1024) {
                            int n13 = n4;
                            ByteArrays.quickSortIndirect(perm, a2, n13, n13 + nArray5[n3]);
                            if (stable) {
                                int n14 = n4;
                                ByteArrays.stabilize(perm, a2, n14, n14 + nArray5[n3]);
                            }
                        } else {
                            nArray2[n2] = n4;
                            nArray3[n2] = nArray5[n3];
                            nArray4[n2++] = n7 + 1;
                        }
                    }
                    n4 += nArray5[n3];
                }
                java.util.Arrays.fill(nArray5, 0);
                continue;
            }
            n3 = n5 + n6 - nArray5[n8];
            for (n4 = n5; n4 <= n3; n4 += nArray5[n5]) {
                n8 = perm[n4];
                n5 = a2[n8] & 0xFF ^ 0x80;
                if (n4 < n3) {
                    while (true) {
                        int n15 = n5;
                        int n16 = nArray6[n15] - 1;
                        nArray6[n15] = n16;
                        n6 = n16;
                        if (n16 <= n4) break;
                        n5 = n8;
                        n8 = perm[n6];
                        perm[n6] = n5;
                        n5 = a2[n8] & 0xFF ^ 0x80;
                    }
                    perm[n4] = n8;
                }
                if (n7 < 0 && nArray5[n5] > 1) {
                    if (nArray5[n5] < 1024) {
                        int n17 = n4;
                        ByteArrays.quickSortIndirect(perm, a2, n17, n17 + nArray5[n5]);
                        if (stable) {
                            int n18 = n4;
                            ByteArrays.stabilize(perm, a2, n18, n18 + nArray5[n5]);
                        }
                    } else {
                        nArray2[n2] = n4;
                        nArray3[n2] = nArray5[n5];
                        nArray4[n2++] = n7 + 1;
                    }
                }
                nArray5[n5] = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSortIndirect(int[] perm, byte[] a2, int from2, int to, boolean stable) {
        void var2_3;
        int n2;
        Object object = ByteArrays.a();
        if (to - from2 < 1024 || ((ForkJoinPool)object).getParallelism() == 1) {
            ByteArrays.radixSortIndirect(perm, a2, from2, to, stable);
            return;
        }
        LinkedBlockingQueue<Segment> linkedBlockingQueue = new LinkedBlockingQueue<Segment>();
        linkedBlockingQueue.add(new Segment(from2, (int)(n2 - var2_3), 0));
        AtomicInteger atomicInteger = new AtomicInteger(1);
        n2 = ((ForkJoinPool)object).getParallelism();
        object = new ExecutorCompletionService((Executor)object);
        int[] nArray = stable ? new int[perm.length] : null;
        int n3 = n2;
        while (n3-- != 0) {
            ((ExecutorCompletionService)object).submit(() -> {
                int[] nArray3 = new int[256];
                int[] nArray4 = new int[256];
                while (true) {
                    int n3;
                    Segment segment;
                    int n4;
                    if (atomicInteger.get() == 0) {
                        n4 = n2;
                        while (n4-- != 0) {
                            linkedBlockingQueue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)linkedBlockingQueue.take()) == POISON_PILL) {
                        return null;
                    }
                    int n5 = segment.a;
                    int n6 = segment.b;
                    n4 = segment.c;
                    int n7 = n5 + n6;
                    while (n7-- != n5) {
                        int n8 = a2[perm[n7]] & 0xFF ^ 0x80;
                        nArray3[n8] = nArray3[n8] + 1;
                    }
                    n7 = -1;
                    int n9 = n5;
                    for (n3 = 0; n3 < 256; ++n3) {
                        if (nArray3[n3] != 0) {
                            n7 = n3;
                        }
                        nArray4[n3] = n9 += nArray3[n3];
                    }
                    if (stable) {
                        n3 = n5 + n6;
                        while (n3-- != n5) {
                            int n10 = a2[perm[n3]] & 0xFF ^ 0x80;
                            int n11 = nArray4[n10] - 1;
                            nArray4[n10] = n11;
                            nArray2[n11] = perm[n3];
                        }
                        System.arraycopy(nArray, n5, perm, n5, n6);
                        n9 = n5;
                        for (n3 = 0; n3 <= n7; ++n3) {
                            if (n4 < 0 && nArray3[n3] > 1) {
                                if (nArray3[n3] < 1024) {
                                    int n12 = n9;
                                    ByteArrays.radixSortIndirect(perm, a2, n12, n12 + nArray3[n3], stable);
                                } else {
                                    atomicInteger.incrementAndGet();
                                    linkedBlockingQueue.add(new Segment(n9, nArray3[n3], n4 + 1));
                                }
                            }
                            n9 += nArray3[n3];
                        }
                        java.util.Arrays.fill(nArray3, 0);
                    } else {
                        n3 = n5 + n6 - nArray3[n7];
                        for (n9 = n5; n9 <= n3; n9 += nArray3[n5]) {
                            n7 = perm[n9];
                            n5 = a2[n7] & 0xFF ^ 0x80;
                            if (n9 < n3) {
                                while (true) {
                                    int n13 = n5;
                                    int n14 = nArray4[n13] - 1;
                                    nArray4[n13] = n14;
                                    n6 = n14;
                                    if (n14 <= n9) break;
                                    n5 = n7;
                                    n7 = perm[n6];
                                    nArray[n6] = n5;
                                    n5 = a2[n7] & 0xFF ^ 0x80;
                                }
                                nArray[n9] = n7;
                            }
                            if (n4 < 0 && nArray3[n5] > 1) {
                                if (nArray3[n5] < 1024) {
                                    int n15 = n9;
                                    ByteArrays.radixSortIndirect(perm, a2, n15, n15 + nArray3[n5], stable);
                                } else {
                                    atomicInteger.incrementAndGet();
                                    linkedBlockingQueue.add(new Segment(n9, nArray3[n5], n4 + 1));
                                }
                            }
                            nArray3[n5] = 0;
                        }
                    }
                    atomicInteger.decrementAndGet();
                }
            });
        }
        Throwable throwable = null;
        int n4 = n2;
        while (n4-- != 0) {
            try {
                ((ExecutorCompletionService)object).take().get();
            }
            catch (Exception exception) {
                throwable = exception.getCause();
            }
        }
        if (throwable != null) {
            throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSortIndirect(int[] perm, byte[] a2, boolean stable) {
        void var2_2;
        void var1_1;
        ByteArrays.parallelRadixSortIndirect(perm, a2, 0, ((void)var1_1).length, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(byte[] a2, byte[] b2) {
        byte[] byArray;
        void var1_1;
        ByteArrays.ensureSameLength(a2, b2);
        ByteArrays.radixSort(a2, (byte[])var1_1, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(byte[] a2, byte[] b2, int from2, int to) {
        void var2_2;
        void var3_4;
        if (to - from2 < 1024) {
            ByteArrays.quickSort(a2, b2, from2, to);
            return;
        }
        int n2 = 0;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        nArray[0] = from2;
        nArray2[0] = var3_4 - var2_2;
        ++n2;
        nArray3[0] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        while (n2 > 0) {
            int n3;
            int n4 = nArray[--n2];
            int n5 = nArray2[n2];
            int n6 = nArray3[n2];
            byte[] byArray = n6 <= 0 ? a2 : b2;
            int n7 = n4 + n5;
            while (n7-- != n4) {
                int n8 = byArray[n7] & 0xFF ^ 0x80;
                nArray4[n8] = nArray4[n8] + 1;
            }
            n7 = -1;
            int n9 = n4;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray4[n3] != 0) {
                    n7 = n3;
                }
                nArray5[n3] = n9 += nArray4[n3];
            }
            n3 = n4 + n5 - nArray4[n7];
            for (n9 = n4; n9 <= n3; n9 += nArray4[n4]) {
                n7 = a2[n9];
                int n10 = b2[n9];
                n4 = byArray[n9] & 0xFF ^ 0x80;
                if (n9 < n3) {
                    while (true) {
                        int n11 = n4;
                        int n12 = nArray5[n11] - 1;
                        nArray5[n11] = n12;
                        n5 = n12;
                        if (n12 <= n9) break;
                        n4 = byArray[n5] & 0xFF ^ 0x80;
                        int n13 = n7;
                        n7 = a2[n5];
                        a2[n5] = n13;
                        n13 = n10;
                        n10 = b2[n5];
                        b2[n5] = n13;
                    }
                    a2[n9] = n7;
                    b2[n9] = n10;
                }
                if (n6 <= 0 && nArray4[n4] > 1) {
                    if (nArray4[n4] < 1024) {
                        int n14 = n9;
                        ByteArrays.quickSort(a2, b2, n14, n14 + nArray4[n4]);
                    } else {
                        nArray[n2] = n9;
                        nArray2[n2] = nArray4[n4];
                        nArray3[n2++] = n6 + 1;
                    }
                }
                nArray4[n4] = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSort(byte[] a2, byte[] b2, int from2, int to) {
        void var2_3;
        int n2;
        Object object = ByteArrays.a();
        if (to - from2 < 1024 || ((ForkJoinPool)object).getParallelism() == 1) {
            ByteArrays.quickSort(a2, b2, from2, to);
            return;
        }
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        LinkedBlockingQueue<Segment> linkedBlockingQueue = new LinkedBlockingQueue<Segment>();
        linkedBlockingQueue.add(new Segment(from2, (int)(n2 - var2_3), 0));
        AtomicInteger atomicInteger = new AtomicInteger(1);
        n2 = ((ForkJoinPool)object).getParallelism();
        object = new ExecutorCompletionService((Executor)object);
        int n3 = n2;
        while (n3-- != 0) {
            ((ExecutorCompletionService)object).submit(() -> {
                int[] nArray = new int[256];
                int[] nArray2 = new int[256];
                while (true) {
                    int n3;
                    Segment segment;
                    int n4;
                    if (atomicInteger.get() == 0) {
                        n4 = n2;
                        while (n4-- != 0) {
                            linkedBlockingQueue.add(POISON_PILL);
                        }
                    }
                    if ((segment = (Segment)linkedBlockingQueue.take()) == POISON_PILL) {
                        return null;
                    }
                    int n5 = segment.a;
                    int n6 = segment.b;
                    n4 = segment.c;
                    byte[] byArray3 = n4 <= 0 ? a2 : b2;
                    int n7 = n5 + n6;
                    while (n7-- != n5) {
                        int n8 = byArray3[n7] & 0xFF ^ 0x80;
                        nArray[n8] = nArray[n8] + 1;
                    }
                    n7 = -1;
                    int n9 = n5;
                    for (n3 = 0; n3 < 256; ++n3) {
                        if (nArray[n3] != 0) {
                            n7 = n3;
                        }
                        nArray2[n3] = n9 += nArray[n3];
                    }
                    n3 = n5 + n6 - nArray[n7];
                    for (n9 = n5; n9 <= n3; n9 += nArray[n5]) {
                        n7 = a2[n9];
                        byte by = b2[n9];
                        n5 = byArray3[n9] & 0xFF ^ 0x80;
                        if (n9 < n3) {
                            while (true) {
                                int n10 = n5;
                                int n11 = nArray2[n10] - 1;
                                nArray2[n10] = n11;
                                n6 = n11;
                                if (n11 <= n9) break;
                                n5 = byArray3[n6] & 0xFF ^ 0x80;
                                int n12 = n7;
                                byte by2 = by;
                                n7 = a2[n6];
                                by = b2[n6];
                                byArray[n6] = n12;
                                byArray2[n6] = by2;
                            }
                            byArray[n9] = n7;
                            byArray2[n9] = by;
                        }
                        if (n4 <= 0 && nArray[n5] > 1) {
                            if (nArray[n5] < 1024) {
                                int n13 = n9;
                                ByteArrays.quickSort(a2, b2, n13, n13 + nArray[n5]);
                            } else {
                                atomicInteger.incrementAndGet();
                                linkedBlockingQueue.add(new Segment(n9, nArray[n5], n4 + 1));
                            }
                        }
                        nArray[n5] = 0;
                    }
                    atomicInteger.decrementAndGet();
                }
            });
        }
        Throwable throwable = null;
        int n4 = n2;
        while (n4-- != 0) {
            try {
                ((ExecutorCompletionService)object).take().get();
            }
            catch (Exception exception) {
                throwable = exception.getCause();
            }
        }
        if (throwable != null) {
            throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void parallelRadixSort(byte[] a2, byte[] b2) {
        byte[] byArray;
        void var1_1;
        ByteArrays.ensureSameLength(a2, b2);
        ByteArrays.parallelRadixSort(a2, (byte[])var1_1, 0, byArray.length);
    }

    private static void a(int[] nArray, byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = n2;
        while (++n4 < n3) {
            int n5 = nArray[n4];
            int n6 = n4;
            int n7 = nArray[n6 - 1];
            while (byArray[n5] < byArray[n7] || byArray[n5] == byArray[n7] && byArray2[n5] < byArray2[n7]) {
                nArray[n6] = n7;
                if (n2 == n6 - 1) {
                    --n6;
                    break;
                }
                n7 = nArray[--n6 - 1];
            }
            nArray[n6] = n5;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSortIndirect(int[] perm, byte[] a2, byte[] b2, boolean stable) {
        void var3_3;
        void var1_1;
        void var2_2;
        int[] nArray;
        ByteArrays.ensureSameLength(a2, b2);
        ByteArrays.radixSortIndirect(nArray, a2, (byte[])var2_2, 0, ((void)var1_1).length, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSortIndirect(int[] perm, byte[] a2, byte[] b2, int from2, int to, boolean stable) {
        int[] nArray;
        void var3_3;
        if (to - from2 < 64) {
            ByteArrays.a(perm, a2, b2, from2, to);
            return;
        }
        int n2 = 0;
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        int[] nArray4 = new int[256];
        nArray2[0] = from2;
        nArray3[0] = to - var3_3;
        ++n2;
        nArray4[0] = 0;
        int[] nArray5 = new int[256];
        int[] nArray6 = new int[256];
        int[] nArray7 = nArray = stable ? new int[perm.length] : null;
        while (n2 > 0) {
            int n3;
            int n4;
            int n5 = nArray2[--n2];
            int n6 = nArray3[n2];
            int n7 = nArray4[n2];
            byte[] byArray = n7 <= 0 ? a2 : b2;
            int n8 = n5 + n6;
            while (n8-- != n5) {
                int n9 = byArray[perm[n8]] & 0xFF ^ 0x80;
                nArray5[n9] = nArray5[n9] + 1;
            }
            n8 = -1;
            int n10 = n4 = stable ? 0 : n5;
            for (n3 = 0; n3 < 256; ++n3) {
                if (nArray5[n3] != 0) {
                    n8 = n3;
                }
                nArray6[n3] = n4 += nArray5[n3];
            }
            if (stable) {
                n3 = n5 + n6;
                while (n3-- != n5) {
                    int n11 = byArray[perm[n3]] & 0xFF ^ 0x80;
                    int n12 = nArray6[n11] - 1;
                    nArray6[n11] = n12;
                    nArray[n12] = perm[n3];
                }
                System.arraycopy(nArray, 0, perm, n5, n6);
                n4 = n5;
                for (n3 = 0; n3 < 256; ++n3) {
                    if (n7 <= 0 && nArray5[n3] > 1) {
                        if (nArray5[n3] < 64) {
                            int n13 = n4;
                            ByteArrays.a(perm, a2, b2, n13, n13 + nArray5[n3]);
                        } else {
                            nArray2[n2] = n4;
                            nArray3[n2] = nArray5[n3];
                            nArray4[n2++] = n7 + 1;
                        }
                    }
                    n4 += nArray5[n3];
                }
                java.util.Arrays.fill(nArray5, 0);
                continue;
            }
            n3 = n5 + n6 - nArray5[n8];
            for (n4 = n5; n4 <= n3; n4 += nArray5[n5]) {
                n8 = perm[n4];
                n5 = byArray[n8] & 0xFF ^ 0x80;
                if (n4 < n3) {
                    while (true) {
                        int n14 = n5;
                        int n15 = nArray6[n14] - 1;
                        nArray6[n14] = n15;
                        n6 = n15;
                        if (n15 <= n4) break;
                        n5 = n8;
                        n8 = perm[n6];
                        perm[n6] = n5;
                        n5 = byArray[n8] & 0xFF ^ 0x80;
                    }
                    perm[n4] = n8;
                }
                if (n7 <= 0 && nArray5[n5] > 1) {
                    if (nArray5[n5] < 64) {
                        int n16 = n4;
                        ByteArrays.a(perm, a2, b2, n16, n16 + nArray5[n5]);
                    } else {
                        nArray2[n2] = n4;
                        nArray3[n2] = nArray5[n5];
                        nArray4[n2++] = n7 + 1;
                    }
                }
                nArray5[n5] = 0;
            }
        }
    }

    private static void a(byte[][] byArray, int n2, int n3, int n4) {
        int n5 = byArray.length;
        while (n2 < n3 - 1) {
            int n6;
            int n7;
            int n8 = n2;
            block1: for (n7 = n2 + 1; n7 < n3; ++n7) {
                for (n6 = n4; n6 < n5; ++n6) {
                    if (byArray[n6][n7] < byArray[n6][n8]) {
                        n8 = n7;
                        continue block1;
                    }
                    if (byArray[n6][n7] > byArray[n6][n8]) continue block1;
                }
            }
            if (n8 != n2) {
                n7 = n5;
                while (n7-- != 0) {
                    n6 = byArray[n7][n2];
                    byArray[n7][n2] = byArray[n7][n8];
                    byArray[n7][n8] = n6;
                }
            }
            ++n2;
        }
    }

    public static void radixSort(byte[][] a2) {
        byte[][] byArray;
        ByteArrays.radixSort(a2, 0, byArray[0].length);
    }

    /*
     * WARNING - void declaration
     */
    public static void radixSort(byte[][] a2, int from2, int to) {
        void var1_1;
        void var2_3;
        if (to - from2 < 64) {
            ByteArrays.a(a2, from2, to, 0);
            return;
        }
        int n2 = a2.length;
        int n3 = 1 * n2 - 1;
        int n4 = n2;
        int n5 = a2[0].length;
        while (n4-- != 0) {
            if (a2[n4].length == n5) continue;
            throw new IllegalArgumentException("The array of index " + n4 + " has not the same length of the array of index 0.");
        }
        n4 = 255 * (n2 - 1) + 1;
        n5 = 0;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        nArray[0] = from2;
        nArray2[0] = var2_3 - var1_1;
        ++n5;
        nArray3[0] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        byte[] byArray = new byte[n2];
        while (n5 > 0) {
            int n6;
            int n7 = nArray[--n5];
            int n8 = nArray2[n5];
            int n9 = nArray3[n5];
            byte[] byArray2 = a2[n9];
            int n10 = n7 + n8;
            while (n10-- != n7) {
                int n11 = byArray2[n10] & 0xFF ^ 0x80;
                nArray4[n11] = nArray4[n11] + 1;
            }
            n10 = -1;
            int n12 = n7;
            for (n6 = 0; n6 < 256; ++n6) {
                if (nArray4[n6] != 0) {
                    n10 = n6;
                }
                nArray5[n6] = n12 += nArray4[n6];
            }
            n6 = n7 + n8 - nArray4[n10];
            for (n12 = n7; n12 <= n6; n12 += nArray4[n7]) {
                n10 = n2;
                while (n10-- != 0) {
                    byArray[n10] = a2[n10][n12];
                }
                n7 = byArray2[n12] & 0xFF ^ 0x80;
                if (n12 < n6) {
                    block6: while (true) {
                        int n13 = n7;
                        int n14 = nArray5[n13] - 1;
                        nArray5[n13] = n14;
                        n8 = n14;
                        if (n14 <= n12) break;
                        n7 = byArray2[n8] & 0xFF ^ 0x80;
                        n10 = n2;
                        while (true) {
                            if (n10-- == 0) continue block6;
                            byte by = byArray[n10];
                            byArray[n10] = a2[n10][n8];
                            a2[n10][n8] = by;
                        }
                        break;
                    }
                    n10 = n2;
                    while (n10-- != 0) {
                        a2[n10][n12] = byArray[n10];
                    }
                }
                if (n9 < n3 && nArray4[n7] > 1) {
                    if (nArray4[n7] < 64) {
                        int n15 = n12;
                        ByteArrays.a(a2, n15, n15 + nArray4[n7], n9 + 1);
                    } else {
                        nArray[n5] = n12;
                        nArray2[n5] = nArray4[n7];
                        nArray3[n5++] = n9 + 1;
                    }
                }
                nArray4[n7] = 0;
            }
        }
    }

    public static byte[] shuffle(byte[] a2, int from2, int to, Random random2) {
        byte[] byArray;
        int n2 = to - from2;
        while (n2-- != 0) {
            int n3 = random2.nextInt(n2 + 1);
            byte by = a2[from2 + n2];
            a2[from2 + n2] = a2[from2 + n3];
            a2[from2 + n3] = by;
        }
        return byArray;
    }

    public static byte[] shuffle(byte[] a2, Random random2) {
        byte[] byArray;
        int n2 = a2.length;
        while (n2-- != 0) {
            int n3 = random2.nextInt(n2 + 1);
            byte by = a2[n2];
            a2[n2] = a2[n3];
            a2[n3] = by;
        }
        return byArray;
    }

    public static byte[] reverse(byte[] a2) {
        byte[] byArray;
        int n2 = a2.length;
        int n3 = n2 / 2;
        while (n3-- != 0) {
            byte by = a2[n2 - n3 - 1];
            a2[n2 - n3 - 1] = a2[n3];
            a2[n3] = by;
        }
        return byArray;
    }

    public static byte[] reverse(byte[] a2, int from2, int to) {
        byte[] byArray;
        int n2 = to - from2;
        int n3 = n2 / 2;
        while (n3-- != 0) {
            byte by = a2[from2 + n2 - n3 - 1];
            a2[from2 + n2 - n3 - 1] = a2[from2 + n3];
            a2[from2 + n3] = by;
        }
        return byArray;
    }

    protected static final class d
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final byte[] c;
        private final ByteComparator d;

        public d(byte[] byArray, int n2, int n3, ByteComparator byteComparator) {
            this.a = n2;
            this.b = n3;
            this.c = byArray;
            this.d = byteComparator;
        }

        @Override
        protected final void compute() {
            int n2;
            byte[] byArray = this.c;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                ByteArrays.quickSort(byArray, this.a, this.b, this.d);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = ByteArrays.b(byArray, n7, n7 + (n3 /= 8), n5 + 2 * n3, this.d);
            int n8 = n4;
            n4 = ByteArrays.b(byArray, n4 - n3, n8, n8 + n3, this.d);
            n6 = ByteArrays.b(byArray, n6 - 2 * n3, n6 - n3, n6, this.d);
            n4 = ByteArrays.b(byArray, n5, n4, n6, this.d);
            n3 = byArray[n4];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = this.d.compare(byArray[n5], (byte)n3)) <= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(byArray, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = this.d.compare(byArray[n6], (byte)n3)) >= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(byArray, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ByteArrays.swap(byArray, n5++, n6--);
            }
            n3 = Math.min(n4 - this.a, n5 - n4);
            ByteArrays.swap(byArray, this.a, n5 - n3, n3);
            n3 = Math.min(n9 - n6, this.b - n9 - 1);
            ByteArrays.swap(byArray, n5, this.b - n3, n3);
            n3 = n5 - n4;
            n2 = n9 - n6;
            if (n3 > 1 && n2 > 1) {
                it.unimi.dsi.fastutil.bytes.ByteArrays$d.invokeAll(new d(byArray, this.a, this.a + n3, this.d), new d(byArray, this.b - n2, this.b, this.d));
                return;
            }
            if (n3 > 1) {
                it.unimi.dsi.fastutil.bytes.ByteArrays$d.invokeAll(new d(byArray, this.a, this.a + n3, this.d));
                return;
            }
            it.unimi.dsi.fastutil.bytes.ByteArrays$d.invokeAll(new d(byArray, this.b - n2, this.b, this.d));
        }
    }

    protected static final class b
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final byte[] c;

        public b(byte[] byArray, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.c = byArray;
        }

        @Override
        protected final void compute() {
            int n2;
            byte[] byArray = this.c;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                ByteArrays.quickSort(byArray, this.a, this.b);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = ByteArrays.b(byArray, n7, n7 + (n3 /= 8), n5 + 2 * n3);
            int n8 = n4;
            n4 = ByteArrays.b(byArray, n4 - n3, n8, n8 + n3);
            n6 = ByteArrays.b(byArray, n6 - 2 * n3, n6 - n3, n6);
            n4 = ByteArrays.b(byArray, n5, n4, n6);
            n3 = byArray[n4];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = Byte.compare(byArray[n5], (byte)n3)) <= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(byArray, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = Byte.compare(byArray[n6], (byte)n3)) >= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(byArray, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ByteArrays.swap(byArray, n5++, n6--);
            }
            n3 = Math.min(n4 - this.a, n5 - n4);
            ByteArrays.swap(byArray, this.a, n5 - n3, n3);
            n3 = Math.min(n9 - n6, this.b - n9 - 1);
            ByteArrays.swap(byArray, n5, this.b - n3, n3);
            n3 = n5 - n4;
            n2 = n9 - n6;
            if (n3 > 1 && n2 > 1) {
                it.unimi.dsi.fastutil.bytes.ByteArrays$b.invokeAll(new b(byArray, this.a, this.a + n3), new b(byArray, this.b - n2, this.b));
                return;
            }
            if (n3 > 1) {
                it.unimi.dsi.fastutil.bytes.ByteArrays$b.invokeAll(new b(byArray, this.a, this.a + n3));
                return;
            }
            it.unimi.dsi.fastutil.bytes.ByteArrays$b.invokeAll(new b(byArray, this.b - n2, this.b));
        }
    }

    protected static final class e
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final int[] c;
        private final byte[] d;

        public e(int[] nArray, byte[] byArray, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.d = byArray;
            this.c = nArray;
        }

        @Override
        protected final void compute() {
            int n2;
            byte[] byArray = this.d;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                ByteArrays.quickSortIndirect(this.c, byArray, this.a, this.b);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = ByteArrays.b(this.c, byArray, n7, n7 + (n3 /= 8), n5 + 2 * n3);
            int n8 = n4;
            n4 = ByteArrays.b(this.c, byArray, n4 - n3, n8, n8 + n3);
            n6 = ByteArrays.b(this.c, byArray, n6 - 2 * n3, n6 - n3, n6);
            n4 = ByteArrays.b(this.c, byArray, n5, n4, n6);
            n3 = byArray[this.c[n4]];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = Byte.compare(byArray[this.c[n5]], (byte)n3)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(this.c, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = Byte.compare(byArray[this.c[n6]], (byte)n3)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(this.c, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(this.c, n5++, n6--);
            }
            n3 = Math.min(n4 - this.a, n5 - n4);
            IntArrays.swap(this.c, this.a, n5 - n3, n3);
            n3 = Math.min(n9 - n6, this.b - n9 - 1);
            IntArrays.swap(this.c, n5, this.b - n3, n3);
            n3 = n5 - n4;
            n2 = n9 - n6;
            if (n3 > 1 && n2 > 1) {
                e.invokeAll(new e(this.c, byArray, this.a, this.a + n3), new e(this.c, byArray, this.b - n2, this.b));
                return;
            }
            if (n3 > 1) {
                e.invokeAll(new e(this.c, byArray, this.a, this.a + n3));
                return;
            }
            e.invokeAll(new e(this.c, byArray, this.b - n2, this.b));
        }
    }

    protected static final class c
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final byte[] c;
        private final byte[] d;

        public c(byte[] byArray, byte[] byArray2, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.c = byArray;
            this.d = byArray2;
        }

        @Override
        protected final void compute() {
            int n2;
            int n3;
            byte[] byArray = this.c;
            byte[] byArray2 = this.d;
            int n4 = this.b - this.a;
            if (n4 < 8192) {
                ByteArrays.quickSort(byArray, byArray2, this.a, this.b);
                return;
            }
            byte by = this.a + n4 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = ByteArrays.c(byArray, byArray2, n7, n7 + (n4 /= 8), n5 + 2 * n4);
            byte by2 = by;
            by = ByteArrays.c(byArray, byArray2, by - n4, (int)by2, by2 + n4);
            n6 = ByteArrays.c(byArray, byArray2, n6 - 2 * n4, n6 - n4, n6);
            by = ByteArrays.c(byArray, byArray2, n5, (int)by, n6);
            n4 = byArray[by];
            by = byArray2[by];
            n6 = n5 = this.a;
            int n8 = n3 = this.b - 1;
            while (true) {
                if (n6 <= n3 && (n2 = (n2 = Byte.compare(byArray[n6], (byte)n4)) == 0 ? Byte.compare(byArray2[n6], by) : n2) <= 0) {
                    if (n2 == 0) {
                        ByteArrays.b(byArray, byArray2, n5++, n6);
                    }
                    ++n6;
                    continue;
                }
                while (n3 >= n6 && (n2 = (n2 = Byte.compare(byArray[n3], (byte)n4)) == 0 ? Byte.compare(byArray2[n3], by) : n2) >= 0) {
                    if (n2 == 0) {
                        ByteArrays.b(byArray, byArray2, n3, n8--);
                    }
                    --n3;
                }
                if (n6 > n3) break;
                ByteArrays.b(byArray, byArray2, n6++, n3--);
            }
            n4 = Math.min(n5 - this.a, n6 - n5);
            ByteArrays.d(byArray, byArray2, this.a, n6 - n4, n4);
            n4 = Math.min(n8 - n3, this.b - n8 - 1);
            ByteArrays.d(byArray, byArray2, n6, this.b - n4, n4);
            n4 = n6 - n5;
            n2 = n8 - n3;
            if (n4 > 1 && n2 > 1) {
                it.unimi.dsi.fastutil.bytes.ByteArrays$c.invokeAll(new c(byArray, byArray2, this.a, this.a + n4), new c(byArray, byArray2, this.b - n2, this.b));
                return;
            }
            if (n4 > 1) {
                it.unimi.dsi.fastutil.bytes.ByteArrays$c.invokeAll(new c(byArray, byArray2, this.a, this.a + n4));
                return;
            }
            it.unimi.dsi.fastutil.bytes.ByteArrays$c.invokeAll(new c(byArray, byArray2, this.b - n2, this.b));
        }
    }

    protected static final class Segment {
        protected final int a;
        protected final int b;
        protected final int c;

        /*
         * WARNING - void declaration
         */
        protected Segment(int offset, int length, int level) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
        }

        public final String toString() {
            return "Segment [offset=" + this.a + ", length=" + this.b + ", level=" + this.c + "]";
        }
    }

    private static final class a
    implements Hash.Strategy<byte[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

