/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.h;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.longs.LongSpliterator;
import it.unimi.dsi.fastutil.longs.N;
import it.unimi.dsi.fastutil.longs.U;
import it.unimi.dsi.fastutil.longs.aa;
import it.unimi.dsi.fastutil.longs.ah;
import it.unimi.dsi.fastutil.longs.j;
import it.unimi.dsi.fastutil.longs.n;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;

public class LongLinkedOpenHashSet
extends n
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient long[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(int expected, float f2) {
        void var2_2;
        void var1_1;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        LongLinkedOpenHashSet longLinkedOpenHashSet = this;
        longLinkedOpenHashSet.minN = longLinkedOpenHashSet.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new long[this.n + 1];
        this.link = new long[this.n + 1];
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(int expected) {
        this((int)var1_1, 0.75f);
        void var1_1;
    }

    public LongLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(Collection<? extends Long> c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((j)this).addAll((Collection<? extends Long>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(Collection<? extends Long> c2) {
        this((Collection<? extends Long>)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(LongCollection c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((j)this).addAll((LongCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(LongCollection c2) {
        this((LongCollection)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(LongIterator i2, float f2) {
        this(16, (float)var2_2);
        void var2_2;
        while (i2.hasNext()) {
            ((j)this).add(i2.nextLong());
        }
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(LongIterator i2) {
        this((LongIterator)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(Iterator<?> i2, float f2) {
        this(aa.a((Iterator)var1_1), (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(Iterator<?> i2) {
        this(aa.a((Iterator)var1_1));
        void var1_1;
    }

    public LongLinkedOpenHashSet(long[] a2, int offset, int length, float f2) {
        this(length < 0 ? 0 : length, f2);
        N.c(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            ((j)this).add(a2[offset + i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(long[] a2, int offset, int length) {
        this((long[])var1_1, (int)var2_2, (int)var3_3, 0.75f);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(long[] a2, float f2) {
        this(a2, 0, ((void)var1_1).length, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LongLinkedOpenHashSet(long[] a2) {
        this((long[])var1_1, 0.75f);
        void var1_1;
    }

    public static LongLinkedOpenHashSet of() {
        return new LongLinkedOpenHashSet();
    }

    public static LongLinkedOpenHashSet of(long e2) {
        long l2;
        LongLinkedOpenHashSet longLinkedOpenHashSet = new LongLinkedOpenHashSet(1, 0.75f);
        ((j)longLinkedOpenHashSet).add(l2);
        return longLinkedOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static LongLinkedOpenHashSet of(long e0, long e1) {
        long l2;
        LongLinkedOpenHashSet longLinkedOpenHashSet = new LongLinkedOpenHashSet(2, 0.75f);
        ((j)longLinkedOpenHashSet).add(l2);
        if (!((j)longLinkedOpenHashSet).add(e1)) {
            void var2_1;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((long)var2_1)));
        }
        return longLinkedOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static LongLinkedOpenHashSet of(long e0, long e1, long e2) {
        long l2;
        LongLinkedOpenHashSet longLinkedOpenHashSet = new LongLinkedOpenHashSet(3, 0.75f);
        ((j)longLinkedOpenHashSet).add(l2);
        if (!((j)longLinkedOpenHashSet).add(e1)) {
            void var2_2;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((long)var2_2)));
        }
        if (!((j)longLinkedOpenHashSet).add(e2)) {
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf(e2)));
        }
        return longLinkedOpenHashSet;
    }

    public static LongLinkedOpenHashSet of(long ... a2) {
        long[] lArray;
        LongLinkedOpenHashSet longLinkedOpenHashSet = new LongLinkedOpenHashSet(a2.length, 0.75f);
        for (long l2 : lArray) {
            if (((j)longLinkedOpenHashSet).add(l2)) continue;
            throw new IllegalArgumentException("Duplicate element ".concat(String.valueOf(l2)));
        }
        return longLinkedOpenHashSet;
    }

    public static LongLinkedOpenHashSet toSet(LongStream stream) {
        return stream.collect(LongLinkedOpenHashSet::new, LongLinkedOpenHashSet::add, LongLinkedOpenHashSet::addAll);
    }

    /*
     * WARNING - void declaration
     */
    public static LongLinkedOpenHashSet toSetWithExpectedSize(LongStream stream, int expectedSize) {
        void var1_1;
        LongStream longStream;
        if (expectedSize <= 16) {
            return LongLinkedOpenHashSet.toSet(stream);
        }
        return longStream.collect(new U.b<LongLinkedOpenHashSet>((int)var1_1, n2 -> {
            if (n2 <= 16) {
                return new LongLinkedOpenHashSet();
            }
            return new LongLinkedOpenHashSet(n2);
        }), LongLinkedOpenHashSet::add, LongLinkedOpenHashSet::addAll);
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private void a(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(LongCollection c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.a((long)(longLinkedOpenHashSet.size() + c2.size()));
        }
        return super.addAll((LongCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends Long> c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.a((long)(longLinkedOpenHashSet.size() + c2.size()));
        }
        return super.addAll((Collection<? extends Long>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(long k2) {
        int n2;
        if (k2 == 0L) {
            if (this.containsNull) {
                return false;
            }
            n2 = this.n;
            this.containsNull = true;
        } else {
            void var1_1;
            long[] lArray = this.key;
            n2 = (int)HashCommon.mix(k2) & this.mask;
            long l2 = this.key[n2];
            if (l2 != 0L) {
                if (l2 == k2) {
                    return false;
                }
                while ((l2 = lArray[n2 = n2 + 1 & this.mask]) != 0L) {
                    if (l2 != k2) continue;
                    return false;
                }
            }
            lArray[n2] = var1_1;
        }
        if (this.size == 0) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.first = longLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.last;
            this.link[n3] = this.link[n3] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.rehash(HashCommon.arraySize(longLinkedOpenHashSet.size + 1, this.f));
        }
        return true;
    }

    private void a(int n2) {
        long[] lArray = this.key;
        while (true) {
            long l2;
            int n3 = n2;
            n2 = n3 + 1 & this.mask;
            while (true) {
                if ((l2 = lArray[n2]) == 0L) {
                    lArray[n3] = 0L;
                    return;
                }
                int n4 = (int)HashCommon.mix(l2) & this.mask;
                if (n3 > n2 ? n3 >= n4 && n4 > n2 : n3 >= n4 || n4 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            lArray[n3] = l2;
            this.a(n2, n3);
        }
    }

    private boolean b(int n2) {
        --this.size;
        this.e(n2);
        this.a(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.rehash(longLinkedOpenHashSet.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(long k222) {
        long k222;
        if (k222 == 0L) {
            if (this.containsNull) {
                LongLinkedOpenHashSet k222 = this;
                this.containsNull = false;
                k222.key[k222.n] = 0L;
                --k222.size;
                LongLinkedOpenHashSet longLinkedOpenHashSet = k222;
                longLinkedOpenHashSet.e(longLinkedOpenHashSet.n);
                if (k222.n > k222.minN && k222.size < k222.maxFill / 4 && k222.n > 16) {
                    LongLinkedOpenHashSet longLinkedOpenHashSet2 = k222;
                    longLinkedOpenHashSet2.rehash(longLinkedOpenHashSet2.n / 2);
                }
                return true;
            }
            return false;
        }
        long[] lArray = this.key;
        int n2 = (int)HashCommon.mix(k222) & this.mask;
        long l2 = this.key[n2];
        if (l2 == 0L) {
            return false;
        }
        if (k222 == l2) {
            return this.b(n2);
        }
        do {
            if ((l2 = lArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k222 != l2);
        return this.b(n2);
    }

    @Override
    public boolean contains(long k2) {
        if (k2 == 0L) {
            return this.containsNull;
        }
        long[] lArray = this.key;
        int n2 = (int)HashCommon.mix(k2) & this.mask;
        long l2 = this.key[n2];
        if (l2 == 0L) {
            return false;
        }
        if (k2 == l2) {
            return true;
        }
        do {
            if ((l2 = lArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k2 != l2);
        return true;
    }

    public long removeFirstLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int n2 = this.first;
        if (this.size == 1) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.last = -1;
            longLinkedOpenHashSet.first = -1;
        } else {
            this.first = (int)this.link[n2];
            if (this.first >= 0) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
        }
        long l2 = this.key[n2];
        --this.size;
        if (l2 == 0L) {
            this.containsNull = false;
            this.key[this.n] = 0L;
        } else {
            this.a(n2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.rehash(longLinkedOpenHashSet.n / 2);
        }
        return l2;
    }

    public long removeLastLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int n2 = this.last;
        if (this.size == 1) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.last = -1;
            longLinkedOpenHashSet.first = -1;
        } else {
            this.last = (int)(this.link[n2] >>> 32);
            if (this.last >= 0) {
                int n3 = this.last;
                this.link[n3] = this.link[n3] | 0xFFFFFFFFL;
            }
        }
        long l2 = this.key[n2];
        --this.size;
        if (l2 == 0L) {
            this.containsNull = false;
            this.key[this.n] = 0L;
        } else {
            this.a(n2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.rehash(longLinkedOpenHashSet.n / 2);
        }
        return l2;
    }

    private void c(int n2) {
        if (this.size == 1 || this.first == n2) {
            return;
        }
        if (this.last == n2) {
            int n3 = this.last = (int)(this.link[n2] >>> 32);
            this.link[n3] = this.link[n3] | 0xFFFFFFFFL;
        } else {
            long l2 = this.link[n2];
            int n4 = (int)(l2 >>> 32);
            int n5 = (int)l2;
            int n6 = n4;
            this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n7 = n5;
            this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n8 = this.first;
        this.link[n8] = this.link[n8] ^ (this.link[this.first] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = n2;
    }

    private void d(int n2) {
        if (this.size == 1 || this.last == n2) {
            return;
        }
        if (this.first == n2) {
            int n3 = this.first = (int)this.link[n2];
            this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
        } else {
            long l2 = this.link[n2];
            int n4 = (int)(l2 >>> 32);
            int n5 = (int)l2;
            int n6 = n4;
            this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n7 = n5;
            this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n8 = this.last;
        this.link[n8] = this.link[n8] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = n2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAndMoveToFirst(long k2) {
        void var1_1;
        int n2;
        if (k2 == 0L) {
            if (this.containsNull) {
                LongLinkedOpenHashSet longLinkedOpenHashSet = this;
                longLinkedOpenHashSet.c(longLinkedOpenHashSet.n);
                return false;
            }
            this.containsNull = true;
            n2 = this.n;
        } else {
            long[] lArray = this.key;
            n2 = (int)HashCommon.mix(k2) & this.mask;
            while (lArray[n2] != 0L) {
                if (k2 == lArray[n2]) {
                    this.c(n2);
                    return false;
                }
                n2 = n2 + 1 & this.mask;
            }
        }
        this.key[n2] = var1_1;
        if (this.size == 0) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.first = longLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.first;
            this.link[n3] = this.link[n3] ^ (this.link[this.first] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = n2;
        }
        if (this.size++ >= this.maxFill) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.rehash(HashCommon.arraySize(longLinkedOpenHashSet.size, this.f));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAndMoveToLast(long k2) {
        void var1_1;
        int n2;
        if (k2 == 0L) {
            if (this.containsNull) {
                LongLinkedOpenHashSet longLinkedOpenHashSet = this;
                longLinkedOpenHashSet.d(longLinkedOpenHashSet.n);
                return false;
            }
            this.containsNull = true;
            n2 = this.n;
        } else {
            long[] lArray = this.key;
            n2 = (int)HashCommon.mix(k2) & this.mask;
            while (lArray[n2] != 0L) {
                if (k2 == lArray[n2]) {
                    this.d(n2);
                    return false;
                }
                n2 = n2 + 1 & this.mask;
            }
        }
        this.key[n2] = var1_1;
        if (this.size == 0) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.first = longLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.last;
            this.link[n3] = this.link[n3] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.rehash(HashCommon.arraySize(longLinkedOpenHashSet.size, this.f));
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0L);
        LongLinkedOpenHashSet longLinkedOpenHashSet = this;
        longLinkedOpenHashSet.last = -1;
        longLinkedOpenHashSet.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void e(int n2) {
        if (this.size == 0) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.last = -1;
            longLinkedOpenHashSet.first = -1;
            return;
        }
        if (this.first == n2) {
            this.first = (int)this.link[n2];
            if (this.first >= 0) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == n2) {
            this.last = (int)(this.link[n2] >>> 32);
            if (this.last >= 0) {
                int n4 = this.last;
                this.link[n4] = this.link[n4] | 0xFFFFFFFFL;
            }
            return;
        }
        long l2 = this.link[n2];
        n2 = (int)(l2 >>> 32);
        int n5 = (int)l2;
        int n6 = n2;
        this.link[n6] = this.link[n6] ^ (this.link[n2] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n7 = n5;
        this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected final void a(int n2, int n3) {
        if (this.size == 1) {
            LongLinkedOpenHashSet longLinkedOpenHashSet = this;
            longLinkedOpenHashSet.first = longLinkedOpenHashSet.last = n3;
            this.link[n3] = -1L;
            return;
        }
        if (this.first == n2) {
            this.first = n3;
            int n4 = (int)this.link[n2];
            this.link[n4] = this.link[n4] ^ (this.link[(int)this.link[n2]] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n3] = this.link[n2];
            return;
        }
        if (this.last == n2) {
            this.last = n3;
            int n5 = (int)(this.link[n2] >>> 32);
            this.link[n5] = this.link[n5] ^ (this.link[(int)(this.link[n2] >>> 32)] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n3] = this.link[n2];
            return;
        }
        long l2 = this.link[n2];
        n2 = (int)(l2 >>> 32);
        int n6 = (int)l2;
        int n7 = n2;
        this.link[n7] = this.link[n7] ^ (this.link[n2] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n8 = n6;
        this.link[n8] = this.link[n8] ^ (this.link[n6] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n3] = l2;
    }

    @Override
    public long firstLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public long lastLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public LongSortedSet tailSet(long from2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongSortedSet headSet(long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongSortedSet subSet(long from2, long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongComparator comparator() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public LongListIterator iterator(long from2) {
        void var1_1;
        return new a(this, (long)var1_1);
    }

    @Override
    public LongListIterator iterator() {
        return new a(this);
    }

    @Override
    public LongSpliterator spliterator() {
        return ah.a((LongIterator)this.iterator(), h.a(this), 337);
    }

    @Override
    public void forEach(LongConsumer action2) {
        int n2 = this.first;
        while (n2 != -1) {
            int n3 = n2;
            n2 = (int)this.link[n3];
            action2.accept(this.key[n3]);
        }
    }

    public boolean trim() {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this;
        return longLinkedOpenHashSet.trim(longLinkedOpenHashSet.size);
    }

    public boolean trim(int n2) {
        int n3 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (n3 >= this.n || this.size > HashCommon.maxFill(n3, this.f)) {
            return true;
        }
        try {
            this.rehash(n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        long[] lArray = this.key;
        int n2 = newN - 1;
        long[] lArray2 = new long[newN + 1];
        int n3 = this.first;
        int n4 = -1;
        int n5 = -1;
        long[] lArray3 = this.link;
        long[] lArray4 = new long[newN + 1];
        this.first = -1;
        int n6 = this.size;
        while (n6-- != 0) {
            int n7;
            if (lArray[n3] == 0L) {
                n7 = newN;
            } else {
                n7 = (int)HashCommon.mix(lArray[n3]) & n2;
                while (lArray2[n7] != 0L) {
                    n7 = n7 + 1 & n2;
                }
            }
            lArray2[n7] = lArray[n3];
            if (n4 != -1) {
                int n8 = n5;
                lArray4[n8] = lArray4[n8] ^ (lArray4[n5] ^ (long)n7 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n9 = n7;
                lArray4[n9] = lArray4[n9] ^ (lArray4[n7] ^ ((long)n5 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n5 = n7;
            } else {
                n5 = this.first = n7;
                lArray4[n7] = -1L;
            }
            n4 = n3;
            n3 = (int)lArray3[n3];
        }
        this.link = lArray4;
        this.last = n5;
        if (n5 != -1) {
            int n10 = n5;
            lArray4[n10] = lArray4[n10] | 0xFFFFFFFFL;
        }
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = lArray2;
    }

    public LongLinkedOpenHashSet clone() {
        LongLinkedOpenHashSet longLinkedOpenHashSet;
        try {
            longLinkedOpenHashSet = (LongLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        longLinkedOpenHashSet.key = (long[])this.key.clone();
        longLinkedOpenHashSet.containsNull = this.containsNull;
        longLinkedOpenHashSet.link = (long[])this.link.clone();
        return longLinkedOpenHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        LongLinkedOpenHashSet longLinkedOpenHashSet = this;
        int n3 = longLinkedOpenHashSet.containsNull ? longLinkedOpenHashSet.size - 1 : longLinkedOpenHashSet.size;
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0L) {
                ++n4;
            }
            n2 += HashCommon.long2int(this.key[n4]);
            ++n4;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        LongListIterator longListIterator = this.iterator();
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            s2.writeLong(longListIterator.nextLong());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new long[this.n + 1];
        long[] lArray = this.key;
        this.link = new long[this.n + 1];
        long[] lArray2 = this.link;
        int n2 = -1;
        LongLinkedOpenHashSet longLinkedOpenHashSet = this;
        longLinkedOpenHashSet.last = -1;
        longLinkedOpenHashSet.first = -1;
        int n3 = this.size;
        while (n3-- != 0) {
            int n4;
            long l2 = s2.readLong();
            if (l2 == 0L) {
                n4 = this.n;
                this.containsNull = true;
            } else {
                n4 = (int)HashCommon.mix(l2) & this.mask;
                if (lArray[n4] != 0L) {
                    while (lArray[n4 = n4 + 1 & this.mask] != 0L) {
                    }
                }
            }
            lArray[n4] = l2;
            if (this.first != -1) {
                int n5 = n2;
                lArray2[n5] = lArray2[n5] ^ (lArray2[n2] ^ (long)n4 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n6 = n4;
                lArray2[n6] = lArray2[n6] ^ (lArray2[n4] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n2 = n4;
                continue;
            }
            n2 = this.first = n4;
            int n7 = n4;
            lArray2[n7] = lArray2[n7] | 0xFFFFFFFF00000000L;
        }
        this.last = n2;
        if (n2 != -1) {
            int n8 = n2;
            lArray2[n8] = lArray2[n8] | 0xFFFFFFFFL;
        }
    }

    private final class a
    implements LongListIterator {
        private int a = -1;
        private int b = -1;
        private int c = -1;
        private int d = -1;
        private /* synthetic */ LongLinkedOpenHashSet e;

        a(LongLinkedOpenHashSet longLinkedOpenHashSet) {
            this.e = longLinkedOpenHashSet;
            this.b = longLinkedOpenHashSet.first;
            this.d = 0;
        }

        a(LongLinkedOpenHashSet longLinkedOpenHashSet, long l2) {
            this.e = longLinkedOpenHashSet;
            if (l2 == 0L) {
                if (longLinkedOpenHashSet.containsNull) {
                    this.b = (int)longLinkedOpenHashSet.link[longLinkedOpenHashSet.n];
                    this.a = longLinkedOpenHashSet.n;
                    return;
                }
                throw new NoSuchElementException("The key " + l2 + " does not belong to this set.");
            }
            if (longLinkedOpenHashSet.key[longLinkedOpenHashSet.last] == l2) {
                this.a = longLinkedOpenHashSet.last;
                this.d = longLinkedOpenHashSet.size;
                return;
            }
            long[] lArray = longLinkedOpenHashSet.key;
            int n2 = (int)HashCommon.mix(l2) & longLinkedOpenHashSet.mask;
            while (lArray[n2] != 0L) {
                if (lArray[n2] == l2) {
                    this.b = (int)longLinkedOpenHashSet.link[n2];
                    this.a = n2;
                    return;
                }
                n2 = n2 + 1 & longLinkedOpenHashSet.mask;
            }
            throw new NoSuchElementException("The key " + l2 + " does not belong to this set.");
        }

        @Override
        public final boolean hasNext() {
            return this.b != -1;
        }

        @Override
        public final boolean hasPrevious() {
            return this.a != -1;
        }

        @Override
        public final long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.c = this.b;
            this.b = (int)this.e.link[this.c];
            this.a = this.c;
            if (this.d >= 0) {
                ++this.d;
            }
            return this.e.key[this.c];
        }

        @Override
        public final long a() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.c = this.a;
            this.a = (int)(this.e.link[this.c] >>> 32);
            this.b = this.c;
            if (this.d >= 0) {
                --this.d;
            }
            return this.e.key[this.c];
        }

        @Override
        public final void forEachRemaining(LongConsumer action2) {
            long[] lArray = this.e.key;
            long[] lArray2 = this.e.link;
            while (this.b != -1) {
                this.c = this.b;
                this.b = (int)lArray2[this.c];
                this.a = this.c;
                if (this.d >= 0) {
                    ++this.d;
                }
                action2.accept(lArray[this.c]);
            }
        }

        private final void b() {
            if (this.d >= 0) {
                return;
            }
            if (this.a == -1) {
                this.d = 0;
                return;
            }
            if (this.b == -1) {
                this.d = this.e.size;
                return;
            }
            int n2 = this.e.first;
            this.d = 1;
            while (n2 != this.a) {
                n2 = (int)this.e.link[n2];
                ++this.d;
            }
        }

        @Override
        public final int nextIndex() {
            this.b();
            return this.d;
        }

        @Override
        public final int previousIndex() {
            this.b();
            return this.d - 1;
        }

        @Override
        public final void remove() {
            this.b();
            if (this.c == -1) {
                throw new IllegalStateException();
            }
            if (this.c == this.a) {
                --this.d;
                this.a = (int)(this.e.link[this.c] >>> 32);
            } else {
                this.b = (int)this.e.link[this.c];
            }
            --this.e.size;
            if (this.a == -1) {
                this.e.first = this.b;
            } else {
                int n2 = this.a;
                this.e.link[n2] = this.e.link[n2] ^ (this.e.link[this.a] ^ (long)this.b & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.b == -1) {
                this.e.last = this.a;
            } else {
                int n3 = this.b;
                this.e.link[n3] = this.e.link[n3] ^ (this.e.link[this.b] ^ ((long)this.a & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int n4 = this.c;
            this.c = -1;
            if (n4 == this.e.n) {
                this.e.containsNull = false;
                this.e.key[this.e.n] = 0L;
                return;
            }
            long[] lArray = this.e.key;
            while (true) {
                long l2;
                int n5 = n4;
                n4 = n5 + 1 & this.e.mask;
                while (true) {
                    if ((l2 = lArray[n4]) == 0L) {
                        lArray[n5] = 0L;
                        return;
                    }
                    int n6 = (int)HashCommon.mix(l2) & this.e.mask;
                    if (n5 > n4 ? n5 >= n6 && n6 > n4 : n5 >= n6 || n6 > n4) break;
                    n4 = n4 + 1 & this.e.mask;
                }
                lArray[n5] = l2;
                if (this.b == n4) {
                    this.b = n5;
                }
                if (this.a == n4) {
                    this.a = n5;
                }
                this.e.a(n4, n5);
            }
        }
    }
}

