/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;

class SecuritySupport {
    private SecuritySupport() {
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    public static InputStream getResourceAsStream(final Class c2, final String name2) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return c2.getResourceAsStream(name2);
                }
            });
        }
        catch (PrivilegedActionException e2) {
            throw (IOException)e2.getException();
        }
    }

    public static URL[] getResources(final ClassLoader cl, final String name2) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL[] ret = null;
                try {
                    ArrayList<URL> v2 = new ArrayList<URL>();
                    Enumeration<URL> e2 = cl.getResources(name2);
                    while (e2 != null && e2.hasMoreElements()) {
                        URL url = e2.nextElement();
                        if (url == null) continue;
                        v2.add(url);
                    }
                    if (v2.size() > 0) {
                        ret = new URL[v2.size()];
                        ret = v2.toArray(ret);
                    }
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    public static URL[] getSystemResources(final String name2) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL[] ret = null;
                try {
                    ArrayList<URL> v2 = new ArrayList<URL>();
                    Enumeration<URL> e2 = ClassLoader.getSystemResources(name2);
                    while (e2 != null && e2.hasMoreElements()) {
                        URL url = e2.nextElement();
                        if (url == null) continue;
                        v2.add(url);
                    }
                    if (v2.size() > 0) {
                        ret = new URL[v2.size()];
                        ret = v2.toArray(ret);
                    }
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    public static InputStream openStream(final URL url) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return url.openStream();
                }
            });
        }
        catch (PrivilegedActionException e2) {
            throw (IOException)e2.getException();
        }
    }
}

