/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.Arrays;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.ULong;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0004\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a@\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0000\u001a@\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0000\u001a \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u001a,\u0010\u0016\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a,\u0010\u001b\u001a\u00020\u001c*\u00020\u00032\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u001c\u0010!\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002\u001a\u0014\u0010\"\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\tH\u0002\u001a*\u0010#\u001a\u00020$*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010#\u001a\u00020$*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010'\u001a\u00020(*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010'\u001a\u00020(*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010)\u001a\u00020\t*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010)\u001a\u00020\t*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010*\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010*\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a0\u0010+\u001a\u00020\u0006*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\tH\u0003\u001a*\u0010,\u001a\u00020-*\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0003\u001a\u0016\u0010,\u001a\u00020-*\u00020\u00032\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a*\u0010.\u001a\u00020\u0003*\u00020(2\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020(2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020\t2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020\u00062\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u0016\u0010.\u001a\u00020\u0003*\u00020-2\b\b\u0002\u0010%\u001a\u00020&H\u0007\u001a\u001c\u0010/\u001a\u00020\u0003*\u00020\u00062\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u00020\tH\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"HEX_DIGITS_TO_DECIMAL", "", "LOWER_CASE_HEX_DIGITS", "", "UPPER_CASE_HEX_DIGITS", "charsPerSet", "", "charsPerElement", "elementsPerSet", "", "elementSeparatorLength", "formattedStringLength", "totalBytes", "bytesPerLine", "bytesPerGroup", "groupSeparatorLength", "byteSeparatorLength", "bytePrefixLength", "byteSuffixLength", "parsedByteArrayMaxSize", "stringLength", "wholeElementsPerSet", "checkContainsAt", "part", "index", "endIndex", "partName", "checkHexLength", "", "startIndex", "maxDigits", "requireMaxLength", "", "checkNewLineAt", "decimalFromHexDigitAt", "hexToByte", "", "format", "Lkotlin/text/HexFormat;", "hexToByteArray", "", "hexToInt", "hexToLong", "hexToLongImpl", "hexToShort", "", "toHexString", "toHexStringImpl", "bits", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nHexExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexExtensions.kt\nkotlin/text/HexExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,591:1\n1#2:592\n1183#3,3:593\n1183#3,3:596\n*S KotlinDebug\n*F\n+ 1 HexExtensions.kt\nkotlin/text/HexExtensionsKt\n*L\n13#1:593,3\n14#1:596,3\n*E\n"})
public final class HexExtensionsKt {
    @NotNull
    private static final String LOWER_CASE_HEX_DIGITS = "0123456789abcdef";
    @NotNull
    private static final String UPPER_CASE_HEX_DIGITS = "0123456789ABCDEF";
    @NotNull
    private static final int[] HEX_DIGITS_TO_DECIMAL;

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$toHexString, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.toHexString($this$toHexString, 0, $this$toHexString.length, format);
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(byArray, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString, int startIndex, int endIndex, @NotNull HexFormat format) {
        boolean bl2;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$toHexString, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$toHexString.length);
        if (startIndex == endIndex) {
            return "";
        }
        String digits = format.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        HexFormat.BytesHexFormat bytesFormat = format.getBytes();
        int bytesPerLine = bytesFormat.getBytesPerLine();
        int bytesPerGroup = bytesFormat.getBytesPerGroup();
        String bytePrefix = bytesFormat.getBytePrefix();
        String byteSuffix = bytesFormat.getByteSuffix();
        String byteSeparator = bytesFormat.getByteSeparator();
        String groupSeparator = bytesFormat.getGroupSeparator();
        int formatLength = HexExtensionsKt.formattedStringLength(endIndex - startIndex, bytesPerLine, bytesPerGroup, groupSeparator.length(), byteSeparator.length(), bytePrefix.length(), byteSuffix.length());
        int indexInLine = 0;
        int indexInGroup = 0;
        StringBuilder $this$toHexString_u24lambda_u243 = stringBuilder = new StringBuilder(formatLength);
        boolean bl3 = false;
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            int n2 = $this$toHexString[i2] & 0xFF;
            if (indexInLine == bytesPerLine) {
                $this$toHexString_u24lambda_u243.append('\n');
                indexInLine = 0;
                indexInGroup = 0;
            } else if (indexInGroup == bytesPerGroup) {
                $this$toHexString_u24lambda_u243.append(groupSeparator);
                indexInGroup = 0;
            }
            if (indexInGroup != 0) {
                $this$toHexString_u24lambda_u243.append(byteSeparator);
            }
            $this$toHexString_u24lambda_u243.append(bytePrefix);
            $this$toHexString_u24lambda_u243.append(digits.charAt(n2 >> 4));
            $this$toHexString_u24lambda_u243.append(digits.charAt(n2 & 0xF));
            $this$toHexString_u24lambda_u243.append(byteSuffix);
            ++indexInGroup;
            ++indexInLine;
        }
        boolean bl4 = bl2 = formatLength == $this$toHexString_u24lambda_u243.length();
        if (!bl2) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = byArray.length;
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(byArray, n2, n3, hexFormat);
    }

    public static final int formattedStringLength(int totalBytes, int bytesPerLine, int bytesPerGroup, int groupSeparatorLength, int byteSeparatorLength, int bytePrefixLength, int byteSuffixLength) {
        int n2;
        boolean bl2;
        boolean bl3 = bl2 = totalBytes > 0;
        if (!bl2) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int lineSeparators = (totalBytes - 1) / bytesPerLine;
        boolean bl4 = false;
        int groupSeparatorsPerLine = (bytesPerLine - 1) / bytesPerGroup;
        int it = n2 = totalBytes % bytesPerLine;
        boolean bl5 = false;
        int bytesInLastLine = it == 0 ? bytesPerLine : it;
        int groupSeparatorsInLastLine = (bytesInLastLine - 1) / bytesPerGroup;
        int groupSeparators = lineSeparators * groupSeparatorsPerLine + groupSeparatorsInLastLine;
        int byteSeparators = totalBytes - 1 - lineSeparators - groupSeparators;
        long totalLength = (long)lineSeparators + (long)groupSeparators * (long)groupSeparatorLength + (long)byteSeparators * (long)byteSeparatorLength + (long)totalBytes * ((long)bytePrefixLength + 2L + (long)byteSuffixLength);
        if (!RangesKt.intRangeContains((ClosedRange<Integer>)new IntRange(0, Integer.MAX_VALUE), totalLength)) {
            throw new IllegalArgumentException("The resulting string length is too big: " + ULong.toString-impl(ULong.constructor-impl(totalLength)));
        }
        return (int)totalLength;
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final byte[] hexToByteArray(@NotNull String $this$hexToByteArray, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToByteArray, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToByteArray($this$hexToByteArray, 0, $this$hexToByteArray.length(), format);
    }

    public static /* synthetic */ byte[] hexToByteArray$default(String string2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByteArray(string2, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final byte[] hexToByteArray(String $this$hexToByteArray, int startIndex, int endIndex, HexFormat format) {
        byte[] byArray;
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$hexToByteArray.length());
        if (startIndex == endIndex) {
            return new byte[0];
        }
        HexFormat.BytesHexFormat bytesFormat = format.getBytes();
        int bytesPerLine = bytesFormat.getBytesPerLine();
        int bytesPerGroup = bytesFormat.getBytesPerGroup();
        String bytePrefix = bytesFormat.getBytePrefix();
        String byteSuffix = bytesFormat.getByteSuffix();
        String byteSeparator = bytesFormat.getByteSeparator();
        String groupSeparator = bytesFormat.getGroupSeparator();
        int resultCapacity = HexExtensionsKt.parsedByteArrayMaxSize(endIndex - startIndex, bytesPerLine, bytesPerGroup, groupSeparator.length(), byteSeparator.length(), bytePrefix.length(), byteSuffix.length());
        byte[] result2 = new byte[resultCapacity];
        int i2 = startIndex;
        int byteIndex = 0;
        int indexInLine = 0;
        int indexInGroup = 0;
        while (i2 < endIndex) {
            if (indexInLine == bytesPerLine) {
                i2 = HexExtensionsKt.checkNewLineAt($this$hexToByteArray, i2, endIndex);
                indexInLine = 0;
                indexInGroup = 0;
            } else if (indexInGroup == bytesPerGroup) {
                i2 = HexExtensionsKt.checkContainsAt($this$hexToByteArray, groupSeparator, i2, endIndex, "group separator");
                indexInGroup = 0;
            } else if (indexInGroup != 0) {
                i2 = HexExtensionsKt.checkContainsAt($this$hexToByteArray, byteSeparator, i2, endIndex, "byte separator");
            }
            ++indexInLine;
            ++indexInGroup;
            i2 = HexExtensionsKt.checkContainsAt($this$hexToByteArray, bytePrefix, i2, endIndex, "byte prefix");
            HexExtensionsKt.checkHexLength($this$hexToByteArray, i2, RangesKt.coerceAtMost(i2 + 2, endIndex), 2, true);
            result2[byteIndex++] = (byte)(HexExtensionsKt.decimalFromHexDigitAt($this$hexToByteArray, i2++) << 4 | HexExtensionsKt.decimalFromHexDigitAt($this$hexToByteArray, i2++));
            i2 = HexExtensionsKt.checkContainsAt($this$hexToByteArray, byteSuffix, i2, endIndex, "byte suffix");
        }
        if (byteIndex == result2.length) {
            byArray = result2;
        } else {
            byte[] byArray2 = Arrays.copyOf(result2, byteIndex);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
        }
        return byArray;
    }

    static /* synthetic */ byte[] hexToByteArray$default(String string2, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string2.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByteArray(string2, n2, n3, hexFormat);
    }

    public static final int parsedByteArrayMaxSize(int stringLength, int bytesPerLine, int bytesPerGroup, int groupSeparatorLength, int byteSeparatorLength, int bytePrefixLength, int byteSuffixLength) {
        long l2;
        boolean bl2;
        boolean bl3 = bl2 = stringLength > 0;
        if (!bl2) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long charsPerByte = (long)bytePrefixLength + 2L + (long)byteSuffixLength;
        long charsPerGroup = HexExtensionsKt.charsPerSet(charsPerByte, bytesPerGroup, byteSeparatorLength);
        if (bytesPerLine <= bytesPerGroup) {
            l2 = HexExtensionsKt.charsPerSet(charsPerByte, bytesPerLine, byteSeparatorLength);
        } else {
            int groupsPerLine = bytesPerLine / bytesPerGroup;
            long result2 = HexExtensionsKt.charsPerSet(charsPerGroup, groupsPerLine, groupSeparatorLength);
            int bytesPerLastGroupInLine = bytesPerLine % bytesPerGroup;
            if (bytesPerLastGroupInLine != 0) {
                result2 += (long)groupSeparatorLength;
                result2 += HexExtensionsKt.charsPerSet(charsPerByte, bytesPerLastGroupInLine, byteSeparatorLength);
            }
            l2 = result2;
        }
        long charsPerLine = l2;
        long numberOfChars = stringLength;
        long wholeLines = HexExtensionsKt.wholeElementsPerSet(numberOfChars, charsPerLine, 1);
        long wholeGroupsInLastLine = HexExtensionsKt.wholeElementsPerSet(numberOfChars -= wholeLines * (charsPerLine + 1L), charsPerGroup, groupSeparatorLength);
        long wholeBytesInLastGroup = HexExtensionsKt.wholeElementsPerSet(numberOfChars -= wholeGroupsInLastLine * (charsPerGroup + (long)groupSeparatorLength), charsPerByte, byteSeparatorLength);
        int spare = (numberOfChars -= wholeBytesInLastGroup * (charsPerByte + (long)byteSeparatorLength)) > 0L ? 1 : 0;
        return (int)(wholeLines * (long)bytesPerLine + wholeGroupsInLastLine * (long)bytesPerGroup + wholeBytesInLastGroup + (long)spare);
    }

    private static final long charsPerSet(long charsPerElement, int elementsPerSet, int elementSeparatorLength) {
        boolean bl2;
        boolean bl3 = bl2 = elementsPerSet > 0;
        if (!bl2) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return charsPerElement * (long)elementsPerSet + (long)elementSeparatorLength * ((long)elementsPerSet - 1L);
    }

    private static final long wholeElementsPerSet(long charsPerSet, long charsPerElement, int elementSeparatorLength) {
        return charsPerSet <= 0L || charsPerElement <= 0L ? 0L : (charsPerSet + (long)elementSeparatorLength) / (charsPerElement + (long)elementSeparatorLength);
    }

    private static final int checkNewLineAt(String $this$checkNewLineAt, int index2, int endIndex) {
        int n2;
        if ($this$checkNewLineAt.charAt(index2) == '\r') {
            n2 = index2 + 1 < endIndex && $this$checkNewLineAt.charAt(index2 + 1) == '\n' ? index2 + 2 : index2 + 1;
        } else if ($this$checkNewLineAt.charAt(index2) == '\n') {
            n2 = index2 + 1;
        } else {
            throw new NumberFormatException("Expected a new line at index " + index2 + ", but was " + $this$checkNewLineAt.charAt(index2));
        }
        return n2;
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(byte $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.toHexStringImpl($this$toHexString, format, 8);
    }

    public static /* synthetic */ String toHexString$default(byte by, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(by, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final byte hexToByte(@NotNull String $this$hexToByte, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToByte, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToByte($this$hexToByte, 0, $this$hexToByte.length(), format);
    }

    public static /* synthetic */ byte hexToByte$default(String string2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByte(string2, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final byte hexToByte(String $this$hexToByte, int startIndex, int endIndex, HexFormat format) {
        return (byte)HexExtensionsKt.hexToLongImpl($this$hexToByte, startIndex, endIndex, format, 2);
    }

    static /* synthetic */ byte hexToByte$default(String string2, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string2.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByte(string2, n2, n3, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(short $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.toHexStringImpl($this$toHexString, format, 16);
    }

    public static /* synthetic */ String toHexString$default(short s2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(s2, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final short hexToShort(@NotNull String $this$hexToShort, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToShort, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToShort($this$hexToShort, 0, $this$hexToShort.length(), format);
    }

    public static /* synthetic */ short hexToShort$default(String string2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToShort(string2, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final short hexToShort(String $this$hexToShort, int startIndex, int endIndex, HexFormat format) {
        return (short)HexExtensionsKt.hexToLongImpl($this$hexToShort, startIndex, endIndex, format, 4);
    }

    static /* synthetic */ short hexToShort$default(String string2, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string2.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToShort(string2, n2, n3, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(int $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.toHexStringImpl($this$toHexString, format, 32);
    }

    public static /* synthetic */ String toHexString$default(int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(n2, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final int hexToInt(@NotNull String $this$hexToInt, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToInt, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToInt($this$hexToInt, 0, $this$hexToInt.length(), format);
    }

    public static /* synthetic */ int hexToInt$default(String string2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToInt(string2, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final int hexToInt(String $this$hexToInt, int startIndex, int endIndex, HexFormat format) {
        return (int)HexExtensionsKt.hexToLongImpl($this$hexToInt, startIndex, endIndex, format, 8);
    }

    static /* synthetic */ int hexToInt$default(String string2, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string2.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToInt(string2, n2, n3, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(long $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.toHexStringImpl($this$toHexString, format, 64);
    }

    public static /* synthetic */ String toHexString$default(long l2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(l2, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final long hexToLong(@NotNull String $this$hexToLong, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToLong, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToLong($this$hexToLong, 0, $this$hexToLong.length(), format);
    }

    public static /* synthetic */ long hexToLong$default(String string2, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string2, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final long hexToLong(String $this$hexToLong, int startIndex, int endIndex, HexFormat format) {
        return HexExtensionsKt.hexToLongImpl($this$hexToLong, startIndex, endIndex, format, 16);
    }

    static /* synthetic */ long hexToLong$default(String string2, int n2, int n3, HexFormat hexFormat, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string2.length();
        }
        if ((n4 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string2, n2, n3, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final String toHexStringImpl(long $this$toHexStringImpl, HexFormat format, int bits) {
        StringBuilder stringBuilder;
        boolean bl2;
        boolean bl3 = bl2 = (bits & 3) == 0;
        if (!bl2) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String digits = format.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        long value = $this$toHexStringImpl;
        String prefix = format.getNumber().getPrefix();
        String suffix = format.getNumber().getSuffix();
        int formatLength = prefix.length() + (bits >> 2) + suffix.length();
        boolean removeZeros = false;
        removeZeros = format.getNumber().getRemoveLeadingZeros();
        StringBuilder $this$toHexStringImpl_u24lambda_u246 = stringBuilder = new StringBuilder(formatLength);
        boolean bl4 = false;
        $this$toHexStringImpl_u24lambda_u246.append(prefix);
        int shift = bits;
        while (shift > 0) {
            int decimal = (int)(value >> (shift -= 4) & 0xFL);
            if (removeZeros = removeZeros && decimal == 0 && shift > 0) continue;
            $this$toHexStringImpl_u24lambda_u246.append(digits.charAt(decimal));
        }
        $this$toHexStringImpl_u24lambda_u246.append(suffix);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    @ExperimentalStdlibApi
    private static final long hexToLongImpl(String $this$hexToLongImpl, int startIndex, int endIndex, HexFormat format, int maxDigits) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$hexToLongImpl.length());
        String prefix = format.getNumber().getPrefix();
        String suffix = format.getNumber().getSuffix();
        if (prefix.length() + suffix.length() >= endIndex - startIndex) {
            StringBuilder stringBuilder = new StringBuilder().append("Expected a hexadecimal number with prefix \"").append(prefix).append("\" and suffix \"").append(suffix).append("\", but was ");
            String string2 = $this$hexToLongImpl;
            Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
            String string3 = string2.substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            throw new NumberFormatException(stringBuilder.append(string3).toString());
        }
        int digitsStartIndex = HexExtensionsKt.checkContainsAt($this$hexToLongImpl, prefix, startIndex, endIndex, "prefix");
        int digitsEndIndex = endIndex - suffix.length();
        HexExtensionsKt.checkContainsAt($this$hexToLongImpl, suffix, digitsEndIndex, endIndex, "suffix");
        HexExtensionsKt.checkHexLength($this$hexToLongImpl, digitsStartIndex, digitsEndIndex, maxDigits, false);
        long result2 = 0L;
        for (int i2 = digitsStartIndex; i2 < digitsEndIndex; ++i2) {
            result2 = result2 << 4 | (long)HexExtensionsKt.decimalFromHexDigitAt($this$hexToLongImpl, i2);
        }
        return result2;
    }

    static /* synthetic */ long hexToLongImpl$default(String string2, int n2, int n3, HexFormat hexFormat, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n2 = 0;
        }
        if ((n5 & 2) != 0) {
            n3 = string2.length();
        }
        return HexExtensionsKt.hexToLongImpl(string2, n2, n3, hexFormat, n4);
    }

    private static final int checkContainsAt(String $this$checkContainsAt, String part, int index2, int endIndex, String partName) {
        int end = index2 + part.length();
        if (end > endIndex || !StringsKt.regionMatches($this$checkContainsAt, index2, part, 0, part.length(), true)) {
            StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(partName).append(" \"").append(part).append("\" at index ").append(index2).append(", but was ");
            String string2 = $this$checkContainsAt;
            int n2 = RangesKt.coerceAtMost(end, endIndex);
            Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
            String string3 = string2.substring(index2, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            throw new NumberFormatException(stringBuilder.append(string3).toString());
        }
        return end;
    }

    private static final void checkHexLength(String $this$checkHexLength, int startIndex, int endIndex, int maxDigits, boolean requireMaxLength) {
        boolean isCorrectLength;
        int digitsLength = endIndex - startIndex;
        boolean bl2 = requireMaxLength ? digitsLength == maxDigits : (isCorrectLength = digitsLength <= maxDigits);
        if (!isCorrectLength) {
            String specifier = requireMaxLength ? "exactly" : "at most";
            String string2 = $this$checkHexLength;
            Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
            String string3 = string2.substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            String substring = string3;
            throw new NumberFormatException("Expected " + specifier + ' ' + maxDigits + " hexadecimal digits at index " + startIndex + ", but was " + substring + " of length " + digitsLength);
        }
    }

    private static final int decimalFromHexDigitAt(String $this$decimalFromHexDigitAt, int index2) {
        char code = $this$decimalFromHexDigitAt.charAt(index2);
        if (code > '\u007f' || HEX_DIGITS_TO_DECIMAL[code] < 0) {
            throw new NumberFormatException("Expected a hexadecimal digit at index " + index2 + ", but was " + $this$decimalFromHexDigitAt.charAt(index2));
        }
        return HEX_DIGITS_TO_DECIMAL[code];
    }

    static {
        int index2;
        char item$iv;
        int n2;
        int[] nArray;
        int n3 = 0;
        int[] nArray2 = new int[128];
        while (n3 < 128) {
            int n4 = n3++;
            nArray2[n4] = -1;
        }
        int[] $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242 = nArray = nArray2;
        boolean bl2 = false;
        CharSequence $this$forEachIndexed$iv = LOWER_CASE_HEX_DIGITS;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (n2 = 0; n2 < $this$forEachIndexed$iv.length(); ++n2) {
            item$iv = $this$forEachIndexed$iv.charAt(n2);
            int n5 = index$iv++;
            char c2 = item$iv;
            index2 = n5;
            boolean bl3 = false;
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[c3] = index2;
        }
        $this$forEachIndexed$iv = UPPER_CASE_HEX_DIGITS;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (n2 = 0; n2 < $this$forEachIndexed$iv.length(); ++n2) {
            item$iv = $this$forEachIndexed$iv.charAt(n2);
            int n6 = index$iv++;
            char c3 = item$iv;
            index2 = n6;
            boolean bl4 = false;
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[c3] = index2;
        }
        HEX_DIGITS_TO_DECIMAL = nArray;
    }
}

