/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.implementations.immutableList.ObjectRef;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorMutableIterator;
import kotlinx.collections.immutable.implementations.immutableList.SingleElementListIterator;
import kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.ListImplementation;
import kotlinx.collections.immutable.internal.MutabilityOwnership;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010)\n\u0000\n\u0002\u0010*\n\u0000\n\u0002\u0010+\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0018\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B=\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010\u001c\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u001e\u0010#\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u0016\u0010#\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u001d\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010!\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J=\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010+\u001a\u00020\u000b2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0-H\u0002\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u00100J\r\u00101\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b2JG\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u00104\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u00105\u001a\u000206H\u0002\u00a2\u0006\u0002\u00107J[\u00103\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010!\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000b2\u0016\u00109\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u00072\u0006\u0010:\u001a\u00020\u000b2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0002\u00a2\u0006\u0002\u0010<J/\u0010=\u001a\u00020 2\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010>J\u001d\u0010?\u001a\u00020\u001d2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0002\u00a2\u0006\u0002\u0010@J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00000BH\u0096\u0002J\u001e\u0010C\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070D2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000FH\u0016J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000F2\u0006\u0010!\u001a\u00020\u000bH\u0016J'\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0010\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010HJ-\u0010I\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010J\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010KJ\u0015\u0010L\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010NJ5\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010!\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010PJ?\u0010Q\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u00104\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\u000b2\u0006\u0010S\u001a\u000206H\u0002\u00a2\u0006\u0002\u0010TJ/\u0010U\u001a\u00020 2\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010R\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010VJM\u0010W\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010R\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b2\u0014\u0010X\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070-H\u0002\u00a2\u0006\u0002\u0010YJE\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010R\u001a\u00020\u000b2\u0014\u00109\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0007H\u0002\u00a2\u0006\u0002\u0010[J?\u0010\\\u001a\u00020 2\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u000e\u0010]\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010^\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0002\u00a2\u0006\u0002\u0010_J?\u0010`\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u00104\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010aJu\u0010b\u001a\u00020\u000b2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001d0d2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010e\u001a\u00020\u000b2\u0006\u0010f\u001a\u00020\u000b2\u0006\u0010g\u001a\u0002062\u0014\u0010h\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070i2\u0014\u00109\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070iH\u0002\u00a2\u0006\u0002\u0010jJ\u001c\u0010k\u001a\u00020\u001d2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001d0dH\u0002JA\u0010k\u001a\u00020\u000b2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001d0d2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010e\u001a\u00020\u000b2\u0006\u0010g\u001a\u000206H\u0002\u00a2\u0006\u0002\u0010lJ\u0016\u0010k\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J,\u0010m\u001a\u00020\u000b2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001d0d2\u0006\u0010n\u001a\u00020\u000b2\u0006\u0010g\u001a\u000206H\u0002J\u001a\u0010o\u001a\u00020\u001d2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001d0dJ\u0015\u0010p\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u00100J=\u0010q\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u00104\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010S\u001a\u000206H\u0002\u00a2\u0006\u0002\u0010TJ9\u0010r\u001a\u0004\u0018\u00010\b2\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010R\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010sJ/\u0010t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u0018\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010KJ\b\u0010R\u001a\u00020\u000bH\u0002J\u001e\u0010u\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010vJE\u0010w\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u00104\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010x\u001a\u00028\u00002\u0006\u0010y\u001a\u000206H\u0002\u00a2\u0006\u0002\u00107JU\u0010z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010{\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000b2\u0016\u00109\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u00072\u0006\u0010:\u001a\u00020\u000b2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0002\u00a2\u0006\u0002\u0010|Jl\u0010}\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010!\u001a\u00020\u000b2\u000e\u0010~\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u007f\u001a\u00020\u000b2\u0016\u00109\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u00072\u0006\u0010:\u001a\u00020\u000b2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0002\u00a2\u0006\u0003\u0010\u0080\u0001J\b\u0010n\u001a\u00020\u000bH\u0002J\u0010\u0010n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007@BX\u0080\u000e\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R0\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007@BX\u0080\u000e\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u001b\u0010\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u0081\u0001"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "E", "Lkotlin/collections/AbstractMutableList;", "Lkotlinx/collections/immutable/PersistentList$Builder;", "vector", "Lkotlinx/collections/immutable/PersistentList;", "vectorRoot", "", "", "vectorTail", "rootShift", "", "(Lkotlinx/collections/immutable/PersistentList;[Ljava/lang/Object;[Ljava/lang/Object;I)V", "ownership", "Lkotlinx/collections/immutable/internal/MutabilityOwnership;", "<set-?>", "root", "getRoot$kotlinx_collections_immutable", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getRootShift$kotlinx_collections_immutable", "()I", "setRootShift$kotlinx_collections_immutable", "(I)V", "size", "getSize", "tail", "getTail$kotlinx_collections_immutable", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "bufferFor", "(I)[Ljava/lang/Object;", "build", "copyToBuffer", "buffer", "bufferIndex", "sourceIterator", "", "([Ljava/lang/Object;ILjava/util/Iterator;)[Ljava/lang/Object;", "get", "(I)Ljava/lang/Object;", "getModCount", "getModCount$kotlinx_collections_immutable", "insertIntoRoot", "shift", "elementCarry", "Lkotlinx/collections/immutable/implementations/immutableList/ObjectRef;", "([Ljava/lang/Object;IILjava/lang/Object;Lkotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "rightShift", "buffers", "nullBuffers", "nextBuffer", "(Ljava/util/Collection;II[[Ljava/lang/Object;I[Ljava/lang/Object;)V", "insertIntoTail", "([Ljava/lang/Object;ILjava/lang/Object;)V", "isMutable", "([Ljava/lang/Object;)Z", "iterator", "", "leafBufferIterator", "", "listIterator", "", "makeMutable", "([Ljava/lang/Object;)[Ljava/lang/Object;", "makeMutableShiftingRight", "distance", "([Ljava/lang/Object;I)[Ljava/lang/Object;", "mutableBuffer", "mutableBufferWith", "(Ljava/lang/Object;)[Ljava/lang/Object;", "nullifyAfter", "([Ljava/lang/Object;II)[Ljava/lang/Object;", "pullLastBuffer", "rootSize", "tailCarry", "([Ljava/lang/Object;IILkotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "pullLastBufferFromRoot", "([Ljava/lang/Object;II)V", "pushBuffers", "buffersIterator", "([Ljava/lang/Object;IILjava/util/Iterator;)[Ljava/lang/Object;", "pushBuffersIncreasingHeightIfNeeded", "([Ljava/lang/Object;I[[Ljava/lang/Object;)[Ljava/lang/Object;", "pushFilledTail", "filledTail", "newTail", "([Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)V", "pushTail", "([Ljava/lang/Object;[Ljava/lang/Object;I)[Ljava/lang/Object;", "recyclableRemoveAll", "predicate", "Lkotlin/Function1;", "bufferSize", "toBufferSize", "bufferRef", "recyclableBuffers", "", "(Lkotlin/jvm/functions/Function1;[Ljava/lang/Object;IILkotlinx/collections/immutable/implementations/immutableList/ObjectRef;Ljava/util/List;Ljava/util/List;)I", "removeAll", "(Lkotlin/jvm/functions/Function1;[Ljava/lang/Object;ILkotlinx/collections/immutable/implementations/immutableList/ObjectRef;)I", "removeAllFromTail", "tailSize", "removeAllWithPredicate", "removeAt", "removeFromRootAt", "removeFromTailAt", "([Ljava/lang/Object;III)Ljava/lang/Object;", "retainFirst", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "setInRoot", "e", "oldElementCarry", "shiftLeafBuffers", "startLeafIndex", "(II[[Ljava/lang/Object;I[Ljava/lang/Object;)[Ljava/lang/Object;", "splitToBuffers", "startBuffer", "startBufferSize", "(Ljava/util/Collection;I[Ljava/lang/Object;I[[Ljava/lang/Object;I[Ljava/lang/Object;)V", "kotlinx-collections-immutable"})
@SourceDebugExtension(value={"SMAP\nPersistentVectorBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentVectorBuilder.kt\nkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,992:1\n26#2:993\n*S KotlinDebug\n*F\n+ 1 PersistentVectorBuilder.kt\nkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder\n*L\n623#1:993\n*E\n"})
public final class PersistentVectorBuilder<E>
extends AbstractMutableList<E>
implements PersistentList.Builder<E> {
    @NotNull
    private PersistentList<? extends E> vector;
    @Nullable
    private Object[] vectorRoot;
    @NotNull
    private Object[] vectorTail;
    private int rootShift;
    @NotNull
    private MutabilityOwnership ownership;
    @Nullable
    private Object[] root;
    @NotNull
    private Object[] tail;
    private int size;

    public PersistentVectorBuilder(@NotNull PersistentList<? extends E> vector, @Nullable Object[] vectorRoot, @NotNull Object[] vectorTail, int rootShift) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        Intrinsics.checkNotNullParameter(vectorTail, "vectorTail");
        this.vector = vector;
        this.vectorRoot = vectorRoot;
        this.vectorTail = vectorTail;
        this.rootShift = rootShift;
        this.ownership = new MutabilityOwnership();
        this.root = this.vectorRoot;
        this.tail = this.vectorTail;
        this.size = this.vector.size();
    }

    public final int getRootShift$kotlinx_collections_immutable() {
        return this.rootShift;
    }

    public final void setRootShift$kotlinx_collections_immutable(int n2) {
        this.rootShift = n2;
    }

    @Nullable
    public final Object[] getRoot$kotlinx_collections_immutable() {
        return this.root;
    }

    @NotNull
    public final Object[] getTail$kotlinx_collections_immutable() {
        return this.tail;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public final int getModCount$kotlinx_collections_immutable() {
        return this.modCount;
    }

    @Override
    @NotNull
    public PersistentList<E> build() {
        PersistentList<Object> persistentList;
        if (this.root == this.vectorRoot && this.tail == this.vectorTail) {
            persistentList = this.vector;
        } else {
            this.ownership = new MutabilityOwnership();
            this.vectorRoot = this.root;
            this.vectorTail = this.tail;
            if (this.root == null) {
                if (this.tail.length == 0) {
                    persistentList = UtilsKt.persistentVectorOf();
                } else {
                    Object[] objectArray = Arrays.copyOf(this.tail, this.size());
                    Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
                    persistentList = new SmallPersistentVector(objectArray);
                }
            } else {
                Intrinsics.checkNotNull(this.root);
                persistentList = new PersistentVector(this.root, this.tail, this.size(), this.rootShift);
            }
        }
        this.vector = persistentList;
        return this.vector;
    }

    private final int rootSize() {
        if (this.size() <= 32) {
            return 0;
        }
        return UtilsKt.rootSize(this.size());
    }

    private final int tailSize(int size) {
        if (size <= 32) {
            return size;
        }
        return size - UtilsKt.rootSize(size);
    }

    private final int tailSize() {
        return this.tailSize(this.size());
    }

    private final boolean isMutable(Object[] buffer) {
        return buffer.length == 33 && buffer[32] == this.ownership;
    }

    private final Object[] makeMutable(Object[] buffer) {
        if (buffer == null) {
            return this.mutableBuffer();
        }
        if (this.isMutable(buffer)) {
            return buffer;
        }
        return ArraysKt.copyInto$default(buffer, this.mutableBuffer(), 0, 0, RangesKt.coerceAtMost(buffer.length, 32), 6, null);
    }

    private final Object[] makeMutableShiftingRight(Object[] buffer, int distance) {
        if (this.isMutable(buffer)) {
            return ArraysKt.copyInto(buffer, buffer, distance, 0, 32 - distance);
        }
        return ArraysKt.copyInto(buffer, this.mutableBuffer(), distance, 0, 32 - distance);
    }

    private final Object[] mutableBufferWith(Object element) {
        Object[] buffer = new Object[33];
        buffer[0] = element;
        buffer[32] = this.ownership;
        return buffer;
    }

    private final Object[] mutableBuffer() {
        Object[] buffer = new Object[33];
        buffer[32] = this.ownership;
        return buffer;
    }

    @Override
    public boolean add(E element) {
        ++this.modCount;
        int tailSize = this.tailSize();
        if (tailSize < 32) {
            Object[] mutableTail = this.makeMutable(this.tail);
            mutableTail[tailSize] = element;
            this.tail = mutableTail;
            this.size = this.size() + 1;
        } else {
            Object[] newTail = this.mutableBufferWith(element);
            this.pushFilledTail(this.root, this.tail, newTail);
        }
        return true;
    }

    private final void pushFilledTail(Object[] root, Object[] filledTail, Object[] newTail) {
        if (this.size() >> 5 > 1 << this.rootShift) {
            this.root = this.pushTail(this.mutableBufferWith(root), filledTail, this.rootShift + 5);
            this.tail = newTail;
            this.rootShift += 5;
            this.size = this.size() + 1;
        } else if (root == null) {
            this.root = filledTail;
            this.tail = newTail;
            this.size = this.size() + 1;
        } else {
            this.root = this.pushTail(root, filledTail, this.rootShift);
            this.tail = newTail;
            this.size = this.size() + 1;
        }
    }

    private final Object[] pushTail(Object[] root, Object[] tail, int shift) {
        int index2 = UtilsKt.indexSegment(this.size() - 1, shift);
        Object[] mutableRoot = this.makeMutable(root);
        mutableRoot[index2] = shift == 5 ? tail : this.pushTail((Object[])mutableRoot[index2], tail, shift - 5);
        return mutableRoot;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements.isEmpty()) {
            return false;
        }
        int n2 = this.modCount;
        this.modCount = n2 + 1;
        int tailSize = this.tailSize();
        Iterator<? extends E> elementsIterator = elements.iterator();
        if (32 - tailSize >= elements.size()) {
            this.tail = this.copyToBuffer(this.makeMutable(this.tail), tailSize, elementsIterator);
            this.size = this.size() + elements.size();
        } else {
            int buffersSize = (elements.size() + tailSize - 1) / 32;
            Object[][] buffers = new Object[buffersSize][];
            buffers[0] = this.copyToBuffer(this.makeMutable(this.tail), tailSize, elementsIterator);
            for (int index2 = 1; index2 < buffersSize; ++index2) {
                buffers[index2] = this.copyToBuffer(this.mutableBuffer(), 0, elementsIterator);
            }
            this.root = this.pushBuffersIncreasingHeightIfNeeded(this.root, this.rootSize(), buffers);
            this.tail = this.copyToBuffer(this.mutableBuffer(), 0, elementsIterator);
            this.size = this.size() + elements.size();
        }
        return true;
    }

    private final Object[] copyToBuffer(Object[] buffer, int bufferIndex, Iterator<? extends Object> sourceIterator) {
        int index2 = bufferIndex;
        while (index2 < 32 && sourceIterator.hasNext()) {
            buffer[index2++] = sourceIterator.next();
        }
        return buffer;
    }

    private final Object[] pushBuffersIncreasingHeightIfNeeded(Object[] root, int rootSize, Object[][] buffers) {
        Object[] mutableRoot;
        Iterator<Object> buffersIterator = ArrayIteratorKt.iterator((Object[])buffers);
        Object[] objectArray = mutableRoot = rootSize >> 5 < 1 << this.rootShift ? this.pushBuffers(root, rootSize, this.rootShift, buffersIterator) : this.makeMutable(root);
        while (buffersIterator.hasNext()) {
            this.rootShift += 5;
            mutableRoot = this.mutableBufferWith(mutableRoot);
            this.pushBuffers(mutableRoot, 1 << this.rootShift, this.rootShift, buffersIterator);
        }
        return mutableRoot;
    }

    private final Object[] pushBuffers(Object[] root, int rootSize, int shift, Iterator<Object[]> buffersIterator) {
        if (!buffersIterator.hasNext()) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        if (!(shift >= 0)) {
            String string3 = "Check failed.";
            throw new IllegalStateException(string3.toString());
        }
        if (shift == 0) {
            return buffersIterator.next();
        }
        Object[] mutableRoot = this.makeMutable(root);
        int index2 = UtilsKt.indexSegment(rootSize, shift);
        mutableRoot[index2] = this.pushBuffers((Object[])mutableRoot[index2], rootSize, shift - 5, buffersIterator);
        while (++index2 < 32 && buffersIterator.hasNext()) {
            mutableRoot[index2] = this.pushBuffers((Object[])mutableRoot[index2], 0, shift - 5, buffersIterator);
        }
        return mutableRoot;
    }

    @Override
    public void add(int index2, E element) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        if (index2 == this.size()) {
            this.add(element);
            return;
        }
        ++this.modCount;
        int rootSize = this.rootSize();
        if (index2 >= rootSize) {
            this.insertIntoTail(this.root, index2 - rootSize, element);
            return;
        }
        ObjectRef elementCarry = new ObjectRef(null);
        Intrinsics.checkNotNull(this.root);
        Object[] newRest = this.insertIntoRoot(this.root, this.rootShift, index2, element, elementCarry);
        this.insertIntoTail(newRest, 0, elementCarry.getValue());
    }

    private final void insertIntoTail(Object[] root, int index2, E element) {
        int tailSize = this.tailSize();
        Object[] mutableTail = this.makeMutable(this.tail);
        if (tailSize < 32) {
            ArraysKt.copyInto(this.tail, mutableTail, index2 + 1, index2, tailSize);
            mutableTail[index2] = element;
            this.root = root;
            this.tail = mutableTail;
            this.size = this.size() + 1;
        } else {
            Object lastElement = this.tail[31];
            ArraysKt.copyInto(this.tail, mutableTail, index2 + 1, index2, 31);
            mutableTail[index2] = element;
            this.pushFilledTail(root, mutableTail, this.mutableBufferWith(lastElement));
        }
    }

    private final Object[] insertIntoRoot(Object[] root, int shift, int index2, Object element, ObjectRef elementCarry) {
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        if (shift == 0) {
            elementCarry.setValue(root[31]);
            Object[] mutableRoot = ArraysKt.copyInto(root, this.makeMutable(root), bufferIndex + 1, bufferIndex, 31);
            mutableRoot[bufferIndex] = element;
            return mutableRoot;
        }
        Object[] mutableRoot = this.makeMutable(root);
        int lowerLevelShift = shift - 5;
        Object object = mutableRoot[bufferIndex];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        mutableRoot[bufferIndex] = this.insertIntoRoot((Object[])object, lowerLevelShift, index2, element, elementCarry);
        for (int i2 = bufferIndex + 1; i2 < 32 && mutableRoot[i2] != null; ++i2) {
            Object object2 = mutableRoot[i2];
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            mutableRoot[i2] = this.insertIntoRoot((Object[])object2, lowerLevelShift, 0, elementCarry.getValue(), elementCarry);
        }
        return mutableRoot;
    }

    @Override
    public boolean addAll(int index2, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        if (index2 == this.size()) {
            return this.addAll(elements);
        }
        if (elements.isEmpty()) {
            return false;
        }
        int n2 = this.modCount;
        this.modCount = n2 + 1;
        int unaffectedElementsCount = index2 >> 5 << 5;
        int buffersSize = (this.size() - unaffectedElementsCount + elements.size() - 1) / 32;
        if (buffersSize == 0) {
            CommonFunctionsKt.assert(index2 >= this.rootSize());
            int startIndex = index2 & 0x1F;
            int endIndex = index2 + elements.size() - 1 & 0x1F;
            Object[] newTail = ArraysKt.copyInto(this.tail, this.makeMutable(this.tail), endIndex + 1, startIndex, this.tailSize());
            this.copyToBuffer(newTail, startIndex, elements.iterator());
            this.tail = newTail;
            this.size = this.size() + elements.size();
            return true;
        }
        Object[][] buffers = new Object[buffersSize][];
        int tailSize = this.tailSize();
        int newTailSize = this.tailSize(this.size() + elements.size());
        Object[] newTail = null;
        if (index2 >= this.rootSize()) {
            newTail = this.mutableBuffer();
            this.splitToBuffers(elements, index2, this.tail, tailSize, buffers, buffersSize, newTail);
        } else if (newTailSize > tailSize) {
            int rightShift = newTailSize - tailSize;
            newTail = this.makeMutableShiftingRight(this.tail, rightShift);
            this.insertIntoRoot(elements, index2, rightShift, buffers, buffersSize, newTail);
        } else {
            newTail = ArraysKt.copyInto(this.tail, this.mutableBuffer(), 0, tailSize - newTailSize, tailSize);
            int rightShift = 32 - (tailSize - newTailSize);
            Object[] lastBuffer = this.makeMutableShiftingRight(this.tail, rightShift);
            buffers[buffersSize - 1] = lastBuffer;
            this.insertIntoRoot(elements, index2, rightShift, buffers, buffersSize - 1, lastBuffer);
        }
        this.root = this.pushBuffersIncreasingHeightIfNeeded(this.root, unaffectedElementsCount, buffers);
        this.tail = newTail;
        this.size = this.size() + elements.size();
        return true;
    }

    private final void insertIntoRoot(Collection<? extends E> elements, int index2, int rightShift, Object[][] buffers, int nullBuffers, Object[] nextBuffer) {
        Object[] objectArray;
        Object[] objectArray2 = this.root;
        if (this.root == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        int startLeafIndex = index2 >> 5;
        Object[] startLeaf = this.shiftLeafBuffers(startLeafIndex, rightShift, buffers, nullBuffers, nextBuffer);
        int lastLeafIndex = (this.rootSize() >> 5) - 1;
        int newNullBuffers = nullBuffers - (lastLeafIndex - startLeafIndex);
        if (newNullBuffers < nullBuffers) {
            Object[] objectArray3 = buffers[newNullBuffers];
            objectArray = objectArray3;
            Intrinsics.checkNotNull(objectArray3);
        } else {
            objectArray = nextBuffer;
        }
        Object[] newNextBuffer = objectArray;
        this.splitToBuffers(elements, index2, startLeaf, 32, buffers, newNullBuffers, newNextBuffer);
    }

    private final Object[] shiftLeafBuffers(int startLeafIndex, int rightShift, Object[][] buffers, int nullBuffers, Object[] nextBuffer) {
        Object[] objectArray = this.root;
        if (this.root == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        int leafCount = this.rootSize() >> 5;
        ListIterator<Object[]> leafBufferIterator = this.leafBufferIterator(leafCount);
        int bufferIndex = nullBuffers;
        Object[] buffer = nextBuffer;
        while (leafBufferIterator.previousIndex() != startLeafIndex) {
            Object[] currentBuffer = leafBufferIterator.previous();
            ArraysKt.copyInto(currentBuffer, buffer, 0, 32 - rightShift, 32);
            buffer = this.makeMutableShiftingRight(currentBuffer, rightShift);
            buffers[--bufferIndex] = buffer;
        }
        return leafBufferIterator.previous();
    }

    private final void splitToBuffers(Collection<? extends E> elements, int index2, Object[] startBuffer, int startBufferSize, Object[][] buffers, int nullBuffers, Object[] nextBuffer) {
        int elementsToShift;
        if (!(nullBuffers >= 1)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        Object[] firstBuffer = this.makeMutable(startBuffer);
        buffers[0] = firstBuffer;
        Object[] newNextBuffer = nextBuffer;
        int newNullBuffers = nullBuffers;
        int startBufferStartIndex = index2 & 0x1F;
        int endBufferEndIndex = index2 + elements.size() - 1 & 0x1F;
        if (endBufferEndIndex + (elementsToShift = startBufferSize - startBufferStartIndex) < 32) {
            ArraysKt.copyInto(firstBuffer, newNextBuffer, endBufferEndIndex + 1, startBufferStartIndex, startBufferSize);
        } else {
            int toCopyToLast = endBufferEndIndex + elementsToShift - 32 + 1;
            if (nullBuffers == 1) {
                newNextBuffer = firstBuffer;
            } else {
                newNextBuffer = this.mutableBuffer();
                buffers[--newNullBuffers] = newNextBuffer;
            }
            ArraysKt.copyInto(firstBuffer, nextBuffer, 0, startBufferSize - toCopyToLast, startBufferSize);
            ArraysKt.copyInto(firstBuffer, newNextBuffer, endBufferEndIndex + 1, startBufferStartIndex, startBufferSize - toCopyToLast);
        }
        Iterator<? extends E> elementsIterator = elements.iterator();
        this.copyToBuffer(firstBuffer, startBufferStartIndex, elementsIterator);
        int n2 = newNullBuffers;
        for (int i2 = 1; i2 < n2; ++i2) {
            buffers[i2] = this.copyToBuffer(this.mutableBuffer(), 0, elementsIterator);
        }
        this.copyToBuffer(newNextBuffer, 0, elementsIterator);
    }

    @Override
    public E get(int index2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        Object[] buffer = this.bufferFor(index2);
        return (E)buffer[index2 & 0x1F];
    }

    private final Object[] bufferFor(int index2) {
        if (this.rootSize() <= index2) {
            return this.tail;
        }
        Intrinsics.checkNotNull(this.root);
        Object[] buffer = this.root;
        for (int shift = this.rootShift; shift > 0; shift -= 5) {
            Object object = buffer[UtilsKt.indexSegment(index2, shift)];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            buffer = (Object[])object;
        }
        return buffer;
    }

    @Override
    public E removeAt(int index2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        ++this.modCount;
        int rootSize = this.rootSize();
        if (index2 >= rootSize) {
            return (E)this.removeFromTailAt(this.root, rootSize, this.rootShift, index2 - rootSize);
        }
        ObjectRef elementCarry = new ObjectRef(this.tail[0]);
        Intrinsics.checkNotNull(this.root);
        Object[] newRoot = this.removeFromRootAt(this.root, this.rootShift, index2, elementCarry);
        this.removeFromTailAt(newRoot, rootSize, this.rootShift, 0);
        return (E)elementCarry.getValue();
    }

    private final Object removeFromTailAt(Object[] root, int rootSize, int shift, int index2) {
        int tailSize = this.size() - rootSize;
        CommonFunctionsKt.assert(index2 < tailSize);
        Object removedElement = null;
        if (tailSize == 1) {
            removedElement = this.tail[0];
            this.pullLastBufferFromRoot(root, rootSize, shift);
        } else {
            removedElement = this.tail[index2];
            Object[] mutableTail = ArraysKt.copyInto(this.tail, this.makeMutable(this.tail), index2, index2 + 1, tailSize);
            mutableTail[tailSize - 1] = null;
            this.root = root;
            this.tail = mutableTail;
            this.size = rootSize + tailSize - 1;
            this.rootShift = shift;
        }
        return removedElement;
    }

    private final Object[] removeFromRootAt(Object[] root, int shift, int index2, ObjectRef tailCarry) {
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        if (shift == 0) {
            Object removedElement = root[bufferIndex];
            Object[] mutableRoot = ArraysKt.copyInto(root, this.makeMutable(root), bufferIndex, bufferIndex + 1, 32);
            mutableRoot[31] = tailCarry.getValue();
            tailCarry.setValue(removedElement);
            return mutableRoot;
        }
        int bufferLastIndex = 31;
        if (root[bufferLastIndex] == null) {
            bufferLastIndex = UtilsKt.indexSegment(this.rootSize() - 1, shift);
        }
        Object[] mutableRoot = this.makeMutable(root);
        int lowerLevelShift = shift - 5;
        int n2 = bufferIndex + 1;
        int i2 = bufferLastIndex;
        if (n2 <= i2) {
            while (true) {
                Object object = mutableRoot[i2];
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                mutableRoot[i2] = this.removeFromRootAt((Object[])object, lowerLevelShift, 0, tailCarry);
                if (i2 == n2) break;
                --i2;
            }
        }
        Object object = mutableRoot[bufferIndex];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        mutableRoot[bufferIndex] = this.removeFromRootAt((Object[])object, lowerLevelShift, index2, tailCarry);
        return mutableRoot;
    }

    private final void pullLastBufferFromRoot(Object[] root, int rootSize, int shift) {
        if (shift == 0) {
            this.root = null;
            Object[] objectArray = root;
            if (root == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new Object[]{};
            }
            this.tail = objectArray;
            this.size = rootSize;
            this.rootShift = shift;
            return;
        }
        ObjectRef tailCarry = new ObjectRef(null);
        Intrinsics.checkNotNull(root);
        Object[] objectArray = this.pullLastBuffer(root, shift, rootSize, tailCarry);
        Intrinsics.checkNotNull(objectArray);
        Object[] newRoot = objectArray;
        Object object = tailCarry.getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        this.tail = (Object[])object;
        this.size = rootSize;
        if (newRoot[1] == null) {
            this.root = (Object[])newRoot[0];
            this.rootShift = shift - 5;
        } else {
            this.root = newRoot;
            this.rootShift = shift;
        }
    }

    private final Object[] pullLastBuffer(Object[] root, int shift, int rootSize, ObjectRef tailCarry) {
        Object[] newBufferAtIndex;
        Object[] objectArray;
        int bufferIndex = UtilsKt.indexSegment(rootSize - 1, shift);
        if (shift == 5) {
            tailCarry.setValue(root[bufferIndex]);
            objectArray = null;
        } else {
            Object object = root[bufferIndex];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = newBufferAtIndex = this.pullLastBuffer((Object[])object, shift - 5, rootSize, tailCarry);
        }
        if (newBufferAtIndex == null && bufferIndex == 0) {
            return null;
        }
        Object[] mutableRoot = this.makeMutable(root);
        mutableRoot[bufferIndex] = newBufferAtIndex;
        return mutableRoot;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.removeAllWithPredicate(new Function1<E, Boolean>(elements){
            final /* synthetic */ Collection<E> $elements;
            {
                this.$elements = $elements;
                super(1);
            }

            @NotNull
            public final Boolean invoke(E it) {
                return this.$elements.contains(it);
            }
        });
    }

    public final boolean removeAllWithPredicate(@NotNull Function1<? super E, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean anyRemoved = this.removeAll(predicate);
        if (anyRemoved) {
            int n2 = this.modCount;
            this.modCount = n2 + 1;
        }
        return anyRemoved;
    }

    private final boolean removeAll(Function1<? super E, Boolean> predicate) {
        Object[] objectArray;
        int tailSize = this.tailSize();
        ObjectRef bufferRef = new ObjectRef(null);
        if (this.root == null) {
            return this.removeAllFromTail(predicate, tailSize, bufferRef) != tailSize;
        }
        ListIterator<Object[]> leafIterator = this.leafBufferIterator(0);
        int bufferSize = 32;
        while (bufferSize == 32 && leafIterator.hasNext()) {
            bufferSize = this.removeAll(predicate, leafIterator.next(), 32, bufferRef);
        }
        if (bufferSize == 32) {
            CommonFunctionsKt.assert(!leafIterator.hasNext());
            int newTailSize = this.removeAllFromTail(predicate, tailSize, bufferRef);
            if (newTailSize == 0) {
                this.pullLastBufferFromRoot(this.root, this.size(), this.rootShift);
            }
            return newTailSize != tailSize;
        }
        int unaffectedElementsCount = leafIterator.previousIndex() << 5;
        List buffers = new ArrayList();
        List recyclableBuffers = new ArrayList();
        while (leafIterator.hasNext()) {
            Object[] leaf = leafIterator.next();
            bufferSize = this.recyclableRemoveAll(predicate, leaf, 32, bufferSize, bufferRef, recyclableBuffers, buffers);
        }
        int newTailSize = this.recyclableRemoveAll(predicate, this.tail, tailSize, bufferSize, bufferRef, recyclableBuffers, buffers);
        Object object = bufferRef.getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newTail = (Object[])object;
        ArraysKt.fill(newTail, null, newTailSize, 32);
        if (buffers.isEmpty()) {
            objectArray = this.root;
            Intrinsics.checkNotNull(this.root);
        } else {
            objectArray = this.pushBuffers(this.root, unaffectedElementsCount, this.rootShift, buffers.iterator());
        }
        Object[] newRoot = objectArray;
        int newRootSize = unaffectedElementsCount + (buffers.size() << 5);
        this.root = this.retainFirst(newRoot, newRootSize);
        this.tail = newTail;
        this.size = newRootSize + newTailSize;
        return true;
    }

    private final Object[] retainFirst(Object[] root, int size) {
        if (!((size & 0x1F) == 0)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        if (size == 0) {
            this.rootShift = 0;
            return null;
        }
        int lastIndex = size - 1;
        Object[] newRoot = root;
        while (lastIndex >> this.rootShift == 0) {
            this.rootShift -= 5;
            Object object = newRoot[0];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot = (Object[])object;
        }
        return this.nullifyAfter(newRoot, lastIndex, this.rootShift);
    }

    private final Object[] nullifyAfter(Object[] root, int index2, int shift) {
        if (!(shift >= 0)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        if (shift == 0) {
            return root;
        }
        int lastIndex = UtilsKt.indexSegment(index2, shift);
        Object object = root[lastIndex];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newChild = this.nullifyAfter((Object[])object, index2, shift - 5);
        Object[] newRoot = root;
        if (lastIndex < 31 && newRoot[lastIndex + 1] != null) {
            if (this.isMutable(newRoot)) {
                ArraysKt.fill(newRoot, null, lastIndex + 1, 32);
            }
            newRoot = ArraysKt.copyInto(newRoot, this.mutableBuffer(), 0, 0, lastIndex + 1);
        }
        if (newChild != newRoot[lastIndex]) {
            newRoot = this.makeMutable(newRoot);
            newRoot[lastIndex] = newChild;
        }
        return newRoot;
    }

    private final int removeAllFromTail(Function1<? super E, Boolean> predicate, int tailSize, ObjectRef bufferRef) {
        int newTailSize = this.removeAll(predicate, this.tail, tailSize, bufferRef);
        if (newTailSize == tailSize) {
            CommonFunctionsKt.assert(bufferRef.getValue() == this.tail);
            return tailSize;
        }
        Object object = bufferRef.getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newTail = (Object[])object;
        ArraysKt.fill(newTail, null, newTailSize, tailSize);
        this.tail = newTail;
        this.size = this.size() - (tailSize - newTailSize);
        return newTailSize;
    }

    private final int removeAll(Function1<? super E, Boolean> predicate, Object[] buffer, int bufferSize, ObjectRef bufferRef) {
        Object[] newBuffer = buffer;
        int newBufferSize = bufferSize;
        boolean anyRemoved = false;
        for (int index2 = 0; index2 < bufferSize; ++index2) {
            Object element = buffer[index2];
            if (predicate.invoke(element).booleanValue()) {
                if (anyRemoved) continue;
                newBuffer = this.makeMutable(buffer);
                newBufferSize = index2;
                anyRemoved = true;
                continue;
            }
            if (!anyRemoved) continue;
            newBuffer[newBufferSize++] = element;
        }
        bufferRef.setValue(newBuffer);
        return newBufferSize;
    }

    private final int recyclableRemoveAll(Function1<? super E, Boolean> predicate, Object[] buffer, int bufferSize, int toBufferSize, ObjectRef bufferRef, List<Object[]> recyclableBuffers, List<Object[]> buffers) {
        Object[] toBuffer;
        if (this.isMutable(buffer)) {
            recyclableBuffers.add(buffer);
        }
        Object object = bufferRef.getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newToBuffer = toBuffer = (Object[])object;
        int newToBufferSize = toBufferSize;
        for (int index2 = 0; index2 < bufferSize; ++index2) {
            Object element = buffer[index2];
            if (predicate.invoke(element).booleanValue()) continue;
            if (newToBufferSize == 32) {
                newToBuffer = !((Collection)recyclableBuffers).isEmpty() ? recyclableBuffers.remove(recyclableBuffers.size() - 1) : this.mutableBuffer();
                newToBufferSize = 0;
            }
            newToBuffer[newToBufferSize++] = element;
        }
        bufferRef.setValue(newToBuffer);
        if (toBuffer != bufferRef.getValue()) {
            buffers.add(toBuffer);
        }
        return newToBufferSize;
    }

    @Override
    public E set(int index2, E element) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        if (this.rootSize() <= index2) {
            Object[] mutableTail = this.makeMutable(this.tail);
            if (mutableTail != this.tail) {
                int n2 = this.modCount;
                this.modCount = n2 + 1;
            }
            int tailIndex = index2 & 0x1F;
            Object oldElement = mutableTail[tailIndex];
            mutableTail[tailIndex] = element;
            this.tail = mutableTail;
            return (E)oldElement;
        }
        ObjectRef oldElementCarry = new ObjectRef(null);
        Intrinsics.checkNotNull(this.root);
        this.root = this.setInRoot(this.root, this.rootShift, index2, element, oldElementCarry);
        return (E)oldElementCarry.getValue();
    }

    private final Object[] setInRoot(Object[] root, int shift, int index2, E e2, ObjectRef oldElementCarry) {
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        Object[] mutableRoot = this.makeMutable(root);
        if (shift == 0) {
            if (mutableRoot != root) {
                int n2 = this.modCount;
                this.modCount = n2 + 1;
            }
            oldElementCarry.setValue(mutableRoot[bufferIndex]);
            mutableRoot[bufferIndex] = e2;
            return mutableRoot;
        }
        Object object = mutableRoot[bufferIndex];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        mutableRoot[bufferIndex] = this.setInRoot((Object[])object, shift - 5, index2, e2, oldElementCarry);
        return mutableRoot;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index2) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        return new PersistentVectorMutableIterator(this, index2);
    }

    private final ListIterator<Object[]> leafBufferIterator(int index2) {
        Object[] objectArray = this.root;
        if (this.root == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        int leafCount = this.rootSize() >> 5;
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, leafCount);
        if (this.rootShift == 0) {
            Intrinsics.checkNotNull(this.root);
            return new SingleElementListIterator<Object[]>(this.root, index2);
        }
        int trieHeight = this.rootShift / 5;
        Intrinsics.checkNotNull(this.root);
        return new TrieIterator(this.root, index2, leafCount, trieHeight);
    }
}

