/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import one.util.streamex.Internals;

abstract class ConstSpliterator<T, S extends ConstSpliterator<T, ?>>
extends Internals.CloneableSpliterator<T, S> {
    long remaining;
    private final boolean ordered;

    public ConstSpliterator(long remaining, boolean ordered) {
        this.remaining = remaining;
        this.ordered = ordered;
    }

    public S trySplit() {
        long remaining = this.remaining;
        if (remaining >= 2L) {
            ConstSpliterator clone = (ConstSpliterator)this.doClone();
            clone.remaining = remaining >>= 1;
            this.remaining -= remaining;
            return (S)clone;
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.remaining;
    }

    @Override
    public int characteristics() {
        return 0x4440 | (this.ordered ? 16 : 0);
    }

    static final class OfDouble
    extends ConstSpliterator<Double, OfDouble>
    implements Spliterator.OfDouble {
        private final double value;

        OfDouble(double value, long count2, boolean ordered) {
            super(count2, ordered);
            this.value = value;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action2) {
            if (this.remaining <= 0L) {
                return false;
            }
            action2.accept(this.value);
            --this.remaining;
            return true;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action2) {
            for (long r2 = this.remaining; r2 > 0L; --r2) {
                action2.accept(this.value);
            }
            this.remaining = 0L;
        }
    }

    static final class OfLong
    extends ConstSpliterator<Long, OfLong>
    implements Spliterator.OfLong {
        private final long value;

        OfLong(long value, long count2, boolean ordered) {
            super(count2, ordered);
            this.value = value;
        }

        @Override
        public boolean tryAdvance(LongConsumer action2) {
            if (this.remaining <= 0L) {
                return false;
            }
            action2.accept(this.value);
            --this.remaining;
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action2) {
            for (long r2 = this.remaining; r2 > 0L; --r2) {
                action2.accept(this.value);
            }
            this.remaining = 0L;
        }
    }

    static final class OfInt
    extends ConstSpliterator<Integer, OfInt>
    implements Spliterator.OfInt {
        private final int value;

        OfInt(int value, long count2, boolean ordered) {
            super(count2, ordered);
            this.value = value;
        }

        @Override
        public boolean tryAdvance(IntConsumer action2) {
            if (this.remaining <= 0L) {
                return false;
            }
            action2.accept(this.value);
            --this.remaining;
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer action2) {
            for (long r2 = this.remaining; r2 > 0L; --r2) {
                action2.accept(this.value);
            }
            this.remaining = 0L;
        }
    }

    static final class OfRef<T>
    extends ConstSpliterator<T, OfRef<T>> {
        private final T value;

        OfRef(T value, long count2, boolean ordered) {
            super(count2, ordered);
            this.value = value;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action2) {
            if (this.remaining <= 0L) {
                return false;
            }
            action2.accept(this.value);
            --this.remaining;
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action2) {
            for (long r2 = this.remaining; r2 > 0L; --r2) {
                action2.accept(this.value);
            }
            this.remaining = 0L;
        }
    }
}

