/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import one.util.streamex.Internals;

abstract class PrefixOps<T, S extends Spliterator<T>>
extends Internals.CloneableSpliterator<T, PrefixOps<T, S>> {
    private static final int BUF_SIZE = 128;
    S source;
    int idx = 0;

    PrefixOps(S source) {
        this.source = source;
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0x5450;
    }

    static final class OfUnordLong
    extends PrefixOps<Long, Spliterator.OfLong>
    implements LongConsumer,
    Spliterator.OfLong {
        private final LongBinaryOperator op;
        private boolean started;
        private MyAtomicLong accRef;
        private long acc;
        private LongPrefixBuffer buffer;

        OfUnordLong(Spliterator.OfLong source, LongBinaryOperator op) {
            super(source);
            this.op = op;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            if (this.started) {
                return null;
            }
            Spliterator.OfLong prefix = ((Spliterator.OfLong)this.source).trySplit();
            if (prefix == null) {
                return null;
            }
            if (this.accRef == null) {
                this.accRef = new MyAtomicLong();
                this.buffer = new LongPrefixBuffer();
            }
            OfUnordLong pref = (OfUnordLong)this.doClone();
            pref.source = prefix;
            pref.buffer = new LongPrefixBuffer();
            return pref;
        }

        @Override
        public boolean tryAdvance(LongConsumer action2) {
            if (this.accRef == null) {
                if (!((Spliterator.OfLong)this.source).tryAdvance(this)) {
                    return false;
                }
                action2.accept(this.acc);
            } else {
                if (!this.buffer.init((Spliterator.OfLong)this.source)) {
                    return false;
                }
                this.buffer.drainOne(action2);
            }
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action2) {
            if (this.accRef == null) {
                ((Spliterator.OfLong)this.source).forEachRemaining((long next) -> {
                    if (this.started) {
                        this.acc = this.op.applyAsLong(this.acc, next);
                    } else {
                        this.acc = next;
                        this.started = true;
                    }
                    action2.accept(this.acc);
                });
            } else {
                this.buffer.drainAll(action2);
                long[] buf = new long[128];
                ((Spliterator.OfLong)this.source).forEachRemaining((long next) -> {
                    if (this.idx == 0) {
                        buf[this.idx++] = next;
                    } else {
                        long prev = buf[this.idx - 1];
                        buf[this.idx++] = this.op.applyAsLong(prev, next);
                        if (this.idx == buf.length) {
                            this.drain(action2, buf);
                            this.idx = 0;
                        }
                    }
                });
                if (this.idx > 0) {
                    this.drain(action2, buf);
                }
            }
        }

        private void drain(LongConsumer action2, long[] buf) {
            long last2 = buf[this.idx - 1];
            boolean accRefJustInitialized = this.accRef.initialize(last2);
            if (accRefJustInitialized) {
                for (int i2 = 0; i2 < this.idx; ++i2) {
                    action2.accept(buf[i2]);
                }
            } else {
                long acc = this.accRef.getAndAccumulate(last2, this.op);
                for (int i3 = 0; i3 < this.idx; ++i3) {
                    action2.accept(this.op.applyAsLong(buf[i3], acc));
                }
            }
        }

        @Override
        public void accept(long next) {
            if (this.started) {
                this.acc = this.op.applyAsLong(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }

        private static final class MyAtomicLong
        extends AtomicLong {
            private boolean init;

            private MyAtomicLong() {
            }

            public synchronized boolean initialize(long x2) {
                if (!this.init) {
                    this.init = true;
                    this.set(x2);
                    return true;
                }
                return false;
            }
        }

        private final class LongPrefixBuffer
        extends PrefixBuffer
        implements LongConsumer {
            private final long[] buf = new long[128];
            private long prevBufferLast;

            private LongPrefixBuffer() {
            }

            boolean init(Spliterator.OfLong source) {
                if (this.idx == 0) {
                    for (int i2 = 0; i2 < 128 && source.tryAdvance(this); ++i2) {
                    }
                    if (this.idx == 0) {
                        return false;
                    }
                    long last2 = this.buf[this.idx - 1];
                    boolean bl2 = this.isFirst = this.isFirst || OfUnordLong.this.accRef.initialize(last2);
                    if (!this.isFirst) {
                        this.prevBufferLast = OfUnordLong.this.accRef.getAndAccumulate(last2, OfUnordLong.this.op);
                    }
                }
                return true;
            }

            void drainOne(LongConsumer action2) {
                long value = this.buf[--this.idx];
                if (this.isFirst) {
                    action2.accept(value);
                    if (this.idx == 0) {
                        this.isFirst = false;
                    }
                } else {
                    action2.accept(OfUnordLong.this.op.applyAsLong(value, this.prevBufferLast));
                }
            }

            void drainAll(LongConsumer action2) {
                if (!this.isInit()) {
                    return;
                }
                if (this.isFirst) {
                    for (int i2 = 0; i2 < this.idx; ++i2) {
                        action2.accept(this.buf[i2]);
                    }
                    this.isFirst = false;
                } else {
                    for (int i3 = 0; i3 < this.idx; ++i3) {
                        action2.accept(OfUnordLong.this.op.applyAsLong(this.buf[i3], this.prevBufferLast));
                    }
                }
                this.idx = 0;
            }

            @Override
            public void accept(long value) {
                if (this.idx == 0) {
                    this.buf[this.idx++] = value;
                } else {
                    long prev = this.buf[this.idx - 1];
                    this.buf[this.idx++] = OfUnordLong.this.op.applyAsLong(prev, value);
                }
            }
        }
    }

    static final class OfUnordInt
    extends PrefixOps<Integer, Spliterator.OfInt>
    implements IntConsumer,
    Spliterator.OfInt {
        private final LongBinaryOperator op;
        private final IntBinaryOperator localOp;
        private boolean started;
        private int acc;
        private AtomicLong accRef;
        private IntPrefixBuffer buffer;

        OfUnordInt(Spliterator.OfInt source, IntBinaryOperator op) {
            super(source);
            this.localOp = op;
            this.op = (a2, b2) -> a2 == Long.MAX_VALUE ? b2 : (long)op.applyAsInt((int)a2, (int)b2);
        }

        @Override
        public Spliterator.OfInt trySplit() {
            if (this.started) {
                return null;
            }
            Spliterator.OfInt prefix = ((Spliterator.OfInt)this.source).trySplit();
            if (prefix == null) {
                return null;
            }
            if (this.accRef == null) {
                this.accRef = new AtomicLong(Long.MAX_VALUE);
                this.buffer = new IntPrefixBuffer();
            }
            OfUnordInt pref = (OfUnordInt)this.doClone();
            pref.source = prefix;
            pref.buffer = new IntPrefixBuffer();
            return pref;
        }

        @Override
        public boolean tryAdvance(IntConsumer action2) {
            if (this.accRef == null) {
                if (!((Spliterator.OfInt)this.source).tryAdvance(this)) {
                    return false;
                }
                action2.accept(this.acc);
            } else {
                if (!this.buffer.init((Spliterator.OfInt)this.source)) {
                    return false;
                }
                this.buffer.drainOne(action2);
            }
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer action2) {
            if (this.accRef == null) {
                ((Spliterator.OfInt)this.source).forEachRemaining((int next) -> {
                    if (this.started) {
                        this.acc = this.localOp.applyAsInt(this.acc, next);
                    } else {
                        this.acc = next;
                        this.started = true;
                    }
                    action2.accept(this.acc);
                });
            } else {
                this.buffer.drainAll(action2);
                int[] buf = new int[128];
                ((Spliterator.OfInt)this.source).forEachRemaining((int next) -> {
                    if (this.idx == 0) {
                        buf[this.idx++] = next;
                    } else {
                        int prev = buf[this.idx - 1];
                        buf[this.idx++] = this.localOp.applyAsInt(prev, next);
                        if (this.idx == buf.length) {
                            this.drain(action2, buf);
                            this.idx = 0;
                        }
                    }
                });
                if (this.idx > 0) {
                    this.drain(action2, buf);
                }
            }
        }

        private void drain(IntConsumer action2, int[] buf) {
            int last2 = buf[this.idx - 1];
            if (this.accRef.compareAndSet(Long.MAX_VALUE, last2)) {
                for (int i2 = 0; i2 < this.idx; ++i2) {
                    action2.accept(buf[i2]);
                }
            } else {
                int acc = (int)this.accRef.getAndAccumulate(last2, this.op);
                for (int i3 = 0; i3 < this.idx; ++i3) {
                    action2.accept(this.localOp.applyAsInt(buf[i3], acc));
                }
            }
        }

        @Override
        public void accept(int next) {
            if (this.started) {
                this.acc = this.localOp.applyAsInt(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }

        private final class IntPrefixBuffer
        extends PrefixBuffer
        implements IntConsumer {
            private final int[] buf = new int[128];
            private int prevBufferLast;

            private IntPrefixBuffer() {
            }

            boolean init(Spliterator.OfInt source) {
                if (this.idx == 0) {
                    for (int i2 = 0; i2 < 128 && source.tryAdvance(this); ++i2) {
                    }
                    if (this.idx == 0) {
                        return false;
                    }
                    int last2 = this.buf[this.idx - 1];
                    boolean bl2 = this.isFirst = this.isFirst || OfUnordInt.this.accRef.compareAndSet(Long.MAX_VALUE, last2);
                    if (!this.isFirst) {
                        this.prevBufferLast = (int)OfUnordInt.this.accRef.getAndAccumulate(last2, OfUnordInt.this.op);
                    }
                }
                return true;
            }

            void drainOne(IntConsumer action2) {
                int value = this.buf[--this.idx];
                if (this.isFirst) {
                    action2.accept(value);
                    if (this.idx == 0) {
                        this.isFirst = false;
                    }
                } else {
                    action2.accept(OfUnordInt.this.localOp.applyAsInt(value, this.prevBufferLast));
                }
            }

            void drainAll(IntConsumer action2) {
                if (!this.isInit()) {
                    return;
                }
                if (this.isFirst) {
                    for (int i2 = 0; i2 < this.idx; ++i2) {
                        action2.accept(this.buf[i2]);
                    }
                    this.isFirst = false;
                } else {
                    for (int i3 = 0; i3 < this.idx; ++i3) {
                        action2.accept(OfUnordInt.this.localOp.applyAsInt(this.buf[i3], this.prevBufferLast));
                    }
                }
                this.idx = 0;
            }

            @Override
            public void accept(int value) {
                if (this.idx == 0) {
                    this.buf[this.idx++] = value;
                } else {
                    int prev = this.buf[this.idx - 1];
                    this.buf[this.idx++] = OfUnordInt.this.localOp.applyAsInt(prev, value);
                }
            }
        }
    }

    static final class OfUnordRef<T>
    extends PrefixOps<T, Spliterator<T>>
    implements Consumer<T> {
        private final BinaryOperator<T> localOp;
        private AtomicReference<T> accRef;
        private T acc = Internals.none();
        private final BinaryOperator<T> op;
        private RefPrefixBuffer buffer;

        OfUnordRef(Spliterator<T> source, BinaryOperator<T> op) {
            super(source);
            this.localOp = op;
            this.op = (a2, b2) -> a2 == Internals.NONE ? b2 : op.apply(a2, b2);
        }

        @Override
        public Spliterator<T> trySplit() {
            if (this.acc != Internals.NONE) {
                return null;
            }
            Spliterator prefix = this.source.trySplit();
            if (prefix == null) {
                return null;
            }
            if (this.accRef == null) {
                this.accRef = new AtomicReference(Internals.none());
                this.buffer = new RefPrefixBuffer();
            }
            OfUnordRef pref = (OfUnordRef)this.doClone();
            pref.source = prefix;
            pref.buffer = new RefPrefixBuffer();
            return pref;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action2) {
            if (this.accRef == null) {
                if (!this.source.tryAdvance(this)) {
                    return false;
                }
                action2.accept(this.acc);
            } else {
                if (!this.buffer.init(this.source)) {
                    return false;
                }
                this.buffer.drainOne(action2);
            }
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action2) {
            if (this.accRef == null) {
                this.source.forEachRemaining(next -> {
                    this.acc = this.op.apply(this.acc, next);
                    action2.accept((T)this.acc);
                });
            } else {
                this.buffer.drainAll(action2);
                Object[] buf = new Object[128];
                this.source.forEachRemaining(next -> {
                    if (this.idx == 0) {
                        buf[this.idx++] = next;
                    } else {
                        Object prev = buf[this.idx - 1];
                        buf[this.idx++] = this.localOp.apply(prev, next);
                        if (this.idx == buf.length) {
                            this.drain(action2, buf);
                            this.idx = 0;
                        }
                    }
                });
                if (this.idx > 0) {
                    this.drain(action2, buf);
                }
            }
        }

        private void drain(Consumer<? super T> action2, T[] buf) {
            T last2 = buf[this.idx - 1];
            T acc = this.accRef.getAndAccumulate(last2, this.op);
            if (acc != Internals.NONE) {
                for (int i2 = 0; i2 < this.idx; ++i2) {
                    action2.accept(this.localOp.apply(buf[i2], acc));
                }
            } else {
                for (int i3 = 0; i3 < this.idx; ++i3) {
                    action2.accept(buf[i3]);
                }
            }
        }

        @Override
        public void accept(T next) {
            this.acc = this.op.apply(this.acc, next);
        }

        private final class RefPrefixBuffer
        extends PrefixBuffer
        implements Consumer<T> {
            private final T[] buf = new Object[128];
            private T prevBufferLast;

            private RefPrefixBuffer() {
            }

            boolean init(Spliterator<T> source) {
                if (this.idx == 0) {
                    for (int i2 = 0; i2 < 128 && source.tryAdvance(this); ++i2) {
                    }
                    if (this.idx == 0) {
                        return false;
                    }
                    Object last2 = this.buf[this.idx - 1];
                    boolean bl2 = this.isFirst = this.isFirst || OfUnordRef.this.accRef.compareAndSet(Internals.none(), last2);
                    if (!this.isFirst) {
                        this.prevBufferLast = OfUnordRef.this.accRef.getAndAccumulate(last2, OfUnordRef.this.op);
                    }
                }
                return true;
            }

            void drainOne(Consumer<? super T> action2) {
                Object value = this.buf[--this.idx];
                if (this.isFirst) {
                    action2.accept(value);
                    if (this.idx == 0) {
                        this.isFirst = false;
                    }
                } else {
                    action2.accept(OfUnordRef.this.localOp.apply(value, this.prevBufferLast));
                }
            }

            void drainAll(Consumer<? super T> action2) {
                if (!this.isInit()) {
                    return;
                }
                if (this.isFirst) {
                    for (int i2 = 0; i2 < this.idx; ++i2) {
                        action2.accept(this.buf[i2]);
                    }
                    this.isFirst = false;
                } else {
                    for (int i3 = 0; i3 < this.idx; ++i3) {
                        action2.accept(OfUnordRef.this.localOp.apply(this.buf[i3], this.prevBufferLast));
                    }
                }
                this.idx = 0;
            }

            @Override
            public void accept(T value) {
                if (this.idx == 0) {
                    this.buf[this.idx++] = value;
                } else {
                    Object prev = this.buf[this.idx - 1];
                    this.buf[this.idx++] = OfUnordRef.this.localOp.apply(prev, value);
                }
            }
        }
    }

    static final class OfDouble
    extends Spliterators.AbstractDoubleSpliterator
    implements DoubleConsumer {
        private final DoubleBinaryOperator op;
        private final Spliterator.OfDouble source;
        private boolean started;
        private double acc;

        OfDouble(Spliterator.OfDouble source, DoubleBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action2) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action2.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action2) {
            this.source.forEachRemaining((double next) -> {
                this.accept(next);
                action2.accept(this.acc);
            });
        }

        @Override
        public void accept(double next) {
            if (this.started) {
                this.acc = this.op.applyAsDouble(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfLong
    extends Spliterators.AbstractLongSpliterator
    implements LongConsumer {
        private final LongBinaryOperator op;
        private final Spliterator.OfLong source;
        private boolean started;
        private long acc;

        OfLong(Spliterator.OfLong source, LongBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(LongConsumer action2) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action2.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action2) {
            this.source.forEachRemaining((long next) -> {
                this.accept(next);
                action2.accept(this.acc);
            });
        }

        @Override
        public void accept(long next) {
            if (this.started) {
                this.acc = this.op.applyAsLong(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfInt
    extends Spliterators.AbstractIntSpliterator
    implements IntConsumer {
        private final IntBinaryOperator op;
        private final Spliterator.OfInt source;
        private boolean started;
        private int acc;

        OfInt(Spliterator.OfInt source, IntBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(IntConsumer action2) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action2.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer action2) {
            this.source.forEachRemaining((int next) -> {
                this.accept(next);
                action2.accept(this.acc);
            });
        }

        @Override
        public void accept(int next) {
            if (this.started) {
                this.acc = this.op.applyAsInt(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfRef<T>
    extends Spliterators.AbstractSpliterator<T>
    implements Consumer<T> {
        private final BinaryOperator<T> op;
        private final Spliterator<T> source;
        private boolean started;
        private T acc;

        OfRef(Spliterator<T> source, BinaryOperator<T> op) {
            super(source.estimateSize(), source.characteristics() & 0x1450);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action2) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action2.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action2) {
            this.source.forEachRemaining(next -> {
                this.accept(next);
                action2.accept((T)this.acc);
            });
        }

        @Override
        public void accept(T next) {
            if (this.started) {
                this.acc = this.op.apply(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static abstract class PrefixBuffer {
        protected int idx;
        protected boolean isFirst;

        PrefixBuffer() {
        }

        public boolean isInit() {
            return this.idx != 0;
        }
    }
}

