/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;

public final class IOUtils {
    private static final int COPY_BUF_SIZE = 8024;
    private static final int SKIP_BUF_SIZE = 4096;
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];
    private static final byte[] SKIP_BUF = new byte[4096];

    public static void closeQuietly(Closeable c2) {
        if (c2 != null) {
            try {
                c2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copy(File sourceFile, OutputStream outputStream) throws IOException {
        Files.copy(sourceFile.toPath(), outputStream);
    }

    public static long copy(InputStream input2, OutputStream output) throws IOException {
        return IOUtils.copy(input2, output, 8024);
    }

    public static long copy(InputStream input2, OutputStream output, int bufferSize) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must be bigger than 0");
        }
        byte[] buffer = new byte[bufferSize];
        int n2 = 0;
        long count2 = 0L;
        while (-1 != (n2 = input2.read(buffer))) {
            if (output != null) {
                output.write(buffer, 0, n2);
            }
            count2 += (long)n2;
        }
        return count2;
    }

    public static long copyRange(InputStream input2, long len, OutputStream output) throws IOException {
        return IOUtils.copyRange(input2, len, output, 8024);
    }

    public static long copyRange(InputStream input2, long len, OutputStream output, int bufferSize) throws IOException {
        long count2;
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must be bigger than 0");
        }
        byte[] buffer = new byte[(int)Math.min((long)bufferSize, len)];
        int n2 = 0;
        for (count2 = 0L; count2 < len && -1 != (n2 = input2.read(buffer, 0, (int)Math.min(len - count2, (long)buffer.length))); count2 += (long)n2) {
            if (output == null) continue;
            output.write(buffer, 0, n2);
        }
        return count2;
    }

    public static int read(File file2, byte[] array2) throws IOException {
        try (InputStream inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);){
            int n2 = IOUtils.readFully(inputStream, array2, 0, array2.length);
            return n2;
        }
    }

    public static int readFully(InputStream input2, byte[] array2) throws IOException {
        return IOUtils.readFully(input2, array2, 0, array2.length);
    }

    public static int readFully(InputStream input2, byte[] array2, int offset, int len) throws IOException {
        int count2;
        if (len < 0 || offset < 0 || len + offset > array2.length || len + offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        int x2 = 0;
        for (count2 = 0; count2 != len && (x2 = input2.read(array2, offset + count2, len - count2)) != -1; count2 += x2) {
        }
        return count2;
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int read2;
        int readNow;
        int expectedLength = byteBuffer.remaining();
        for (read2 = 0; read2 < expectedLength && (readNow = channel.read(byteBuffer)) > 0; read2 += readNow) {
        }
        if (read2 < expectedLength) {
            throw new EOFException();
        }
    }

    public static byte[] readRange(InputStream input2, int len) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copyRange(input2, len, output);
        return output.toByteArray();
    }

    public static byte[] readRange(ReadableByteChannel input2, int len) throws IOException {
        int readNow;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteBuffer b2 = ByteBuffer.allocate(Math.min(len, 8024));
        for (int read2 = 0; read2 < len; read2 += readNow) {
            b2.limit(Math.min(len - read2, b2.capacity()));
            readNow = input2.read(b2);
            if (readNow <= 0) break;
            output.write(b2.array(), 0, readNow);
            b2.rewind();
        }
        return output.toByteArray();
    }

    public static long skip(InputStream input2, long numToSkip) throws IOException {
        int read2;
        long skipped;
        long available = numToSkip;
        while (numToSkip > 0L && (skipped = input2.skip(numToSkip)) != 0L) {
            numToSkip -= skipped;
        }
        while (numToSkip > 0L && (read2 = IOUtils.readFully(input2, SKIP_BUF, 0, (int)Math.min(numToSkip, 4096L))) >= 1) {
            numToSkip -= (long)read2;
        }
        return available - numToSkip;
    }

    public static byte[] toByteArray(InputStream input2) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, (OutputStream)output);
        return output.toByteArray();
    }

    private IOUtils() {
    }
}

