/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.evt.BaseEventImpl;
import org.codehaus.stax2.ri.evt.NamespaceEventImpl;

public class EndElementEventImpl
extends BaseEventImpl
implements EndElement {
    protected final QName mName;
    protected final ArrayList<Namespace> mNamespaces;

    public EndElementEventImpl(Location loc, XMLStreamReader r2) {
        super(loc);
        this.mName = r2.getName();
        int nsCount = r2.getNamespaceCount();
        if (nsCount == 0) {
            this.mNamespaces = null;
        } else {
            ArrayList<NamespaceEventImpl> l2 = new ArrayList<NamespaceEventImpl>(nsCount);
            for (int i2 = 0; i2 < nsCount; ++i2) {
                l2.add(NamespaceEventImpl.constructNamespace(loc, r2.getNamespacePrefix(i2), r2.getNamespaceURI(i2)));
            }
            this.mNamespaces = l2;
        }
    }

    public EndElementEventImpl(Location loc, QName name2, Iterator<Namespace> namespaces) {
        super(loc);
        this.mName = name2;
        if (namespaces == null || !namespaces.hasNext()) {
            this.mNamespaces = null;
        } else {
            ArrayList<Namespace> l2 = new ArrayList<Namespace>();
            while (namespaces.hasNext()) {
                l2.add(namespaces.next());
            }
            this.mNamespaces = l2;
        }
    }

    @Override
    public QName getName() {
        return this.mName;
    }

    @Override
    public Iterator<Namespace> getNamespaces() {
        if (this.mNamespaces == null) {
            return EmptyIterator.getInstance();
        }
        return this.mNamespaces.iterator();
    }

    @Override
    public EndElement asEndElement() {
        return this;
    }

    @Override
    public int getEventType() {
        return 2;
    }

    @Override
    public boolean isEndElement() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer w2) throws XMLStreamException {
        try {
            w2.write("</");
            String prefix = this.mName.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                w2.write(prefix);
                w2.write(58);
            }
            w2.write(this.mName.getLocalPart());
            w2.write(62);
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter2 w2) throws XMLStreamException {
        w2.writeEndElement();
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof EndElement)) {
            return false;
        }
        EndElement other = (EndElement)o2;
        return this.getName().equals(other.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }
}

