/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.CloneBase;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.Nullable;

public abstract class Content
extends CloneBase
implements Serializable {
    protected transient Parent parent = null;
    protected final CType ctype;

    protected Content(CType type) {
        this.ctype = type;
    }

    public final CType getCType() {
        return this.ctype;
    }

    public Content detach() {
        if (this.parent != null) {
            this.parent.removeContent(this);
        }
        return this;
    }

    public Parent getParent() {
        return this.parent;
    }

    @Nullable
    public final Element getParentElement() {
        Parent parent = this.parent;
        return parent instanceof Element ? (Element)parent : null;
    }

    protected Content setParent(Parent parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    public Document getDocument() {
        return this.parent == null ? null : this.parent.getDocument();
    }

    public abstract String getValue();

    @Override
    public Content clone() {
        Content c2 = (Content)super.clone();
        c2.parent = null;
        return c2;
    }

    public static enum CType {
        Comment,
        Element,
        ProcessingInstruction,
        EntityRef,
        Text,
        CDATA,
        DocType;

    }
}

