/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.Function;
import com.intellij.util.concurrency.ChildContext;
import com.intellij.util.concurrency.Propagation;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.CompletablePromise;
import org.jetbrains.concurrency.InternalPromiseUtilKt;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 B*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001BB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B%\b\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J \u0010 \u001a\u0004\u0018\u00018\u00002\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\"H\u0082\b\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u00020'0&H\u0016J \u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\u0010)\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000&H\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010+\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000&H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u000e\u0010-\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000,H\u0016J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u000200J\u0010\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020'H\u0016J\u0017\u00101\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\nH\u0014J,\u00105\u001a\b\u0012\u0004\u0012\u0002H60,\"\u0004\b\u0001\u001062\u0016\u00107\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H608H\u0016J2\u00109\u001a\b\u0012\u0004\u0012\u0002H60,\"\u0004\b\u0001\u001062\u001c\u0010:\u001a\u0018\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H60,08H\u0016J$\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0014\u0010<\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010'0=H\u0002J/\u0010>\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006\"\u0004\b\u0001\u0010\u00012\u0018\u0010?\u001a\u0014\u0012\u0004\u0012\u00020A\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060@H\u0082\bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lorg/jetbrains/concurrency/CompletablePromise;", "()V", "f", "Ljava/util/concurrent/CompletableFuture;", "hasErrorHandler", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addExceptionHandler", "", "(Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/atomic/AtomicBoolean;Z)V", "getF$intellij_platform_concurrency", "()Ljava/util/concurrent/CompletableFuture;", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "", "unit", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getState", "Lorg/jetbrains/concurrency/Promise$State;", "isCancelled", "isDone", "nullizeCancelled", "value", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onError", "rejected", "Ljava/util/function/Consumer;", "", "onProcessed", "processed", "onSuccess", "handler", "Lorg/jetbrains/concurrency/Promise;", "child", "setError", "error", "", "setResult", "t", "(Ljava/lang/Object;)V", "shouldLogErrors", "then", "SUB_RESULT", "done", "Lcom/intellij/util/Function;", "thenAsync", "doneF", "whenComplete", "action", "Ljava/util/function/BiConsumer;", "wrapWithCancellationPropagation", "producer", "Lkotlin/Function1;", "Lkotlin/coroutines/CoroutineContext;", "Companion", "intellij.platform.concurrency"})
@SourceDebugExtension(value={"SMAP\nAsyncPromise.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncPromise.kt\norg/jetbrains/concurrency/AsyncPromise\n*L\n1#1,216:1\n55#1,9:217\n55#1,9:226\n151#1,3:235\n*S KotlinDebug\n*F\n+ 1 AsyncPromise.kt\norg/jetbrains/concurrency/AsyncPromise\n*L\n49#1:217,9\n51#1:226,9\n141#1:235,3\n*E\n"})
public class AsyncPromise<T>
implements CancellablePromise<T>,
CompletablePromise<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletableFuture<T> f;
    @NotNull
    private final AtomicBoolean hasErrorHandler;
    @NotNull
    private static final Logger LOG;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final CancellationException CANCELED;

    private AsyncPromise(CompletableFuture<T> f2, AtomicBoolean hasErrorHandler, boolean addExceptionHandler) {
        this.f = f2;
        this.hasErrorHandler = hasErrorHandler;
        if (addExceptionHandler) {
            this.f.handle((arg_0, arg_1) -> AsyncPromise._init_$lambda$0(new Function2<T, Throwable, T>(){

                @Override
                public final T invoke(T value, Throwable error) {
                    if (error != null && this.shouldLogErrors()) {
                        Logger logger = LOG;
                        Throwable throwable = error instanceof CompletionException ? (CompletionException)error : null;
                        if (throwable == null || (throwable = throwable.getCause()) == null) {
                            throwable = error;
                        }
                        Promises.errorIfNotMessage(logger, throwable);
                    }
                    return value;
                }
            }, arg_0, arg_1));
        }
    }

    @NotNull
    public final CompletableFuture<T> getF$intellij_platform_concurrency() {
        return this.f;
    }

    public AsyncPromise() {
        this(new CompletableFuture(), new AtomicBoolean(), false);
    }

    @Override
    public boolean isDone() {
        return this.f.isDone();
    }

    @Override
    @Nullable
    public T get() {
        Object v0;
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var4_5;
            try {
                boolean bl2 = false;
                var4_5 = this.f.get();
            }
            catch (CancellationException e$iv) {
                var4_5 = null;
            }
            v0 = var4_5;
        }
        return v0;
    }

    @Override
    @Nullable
    public T get(long timeout, @NotNull TimeUnit unit) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        AsyncPromise this_$iv = this;
        boolean $i$f$nullizeCancelled = false;
        if (this_$iv.isCancelled()) {
            v0 = null;
        } else {
            Object var7_6;
            try {
                boolean bl2 = false;
                var7_6 = this.f.get(timeout, unit);
            }
            catch (CancellationException e$iv) {
                var7_6 = null;
            }
            v0 = var7_6;
        }
        return v0;
    }

    private final T nullizeCancelled(Function0<? extends T> value) {
        T t2;
        boolean $i$f$nullizeCancelled = false;
        if (this.isCancelled()) {
            return null;
        }
        try {
            t2 = value.invoke();
        }
        catch (CancellationException e2) {
            t2 = null;
        }
        return t2;
    }

    @Override
    public boolean isCancelled() {
        return this.f.isCancelled();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return !this.isCancelled() && this.f.completeExceptionally(CANCELED);
    }

    @Override
    public void cancel() {
        this.cancel(true);
    }

    @Override
    @NotNull
    public Promise.State getState() {
        return !this.f.isDone() ? Promise.State.PENDING : (this.f.isCompletedExceptionally() ? Promise.State.REJECTED : Promise.State.SUCCEEDED);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        return new AsyncPromise<Object>(this.whenComplete((arg_0, arg_1) -> AsyncPromise.onSuccess$lambda$3(handler, arg_0, arg_1)), this.hasErrorHandler, true);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onError(@NotNull Consumer<? super Throwable> rejected2) {
        Intrinsics.checkNotNullParameter(rejected2, "rejected");
        this.hasErrorHandler.set(true);
        return new AsyncPromise<Object>(this.whenComplete((arg_0, arg_1) -> AsyncPromise.onError$lambda$4(rejected2, arg_0, arg_1)), this.hasErrorHandler, false);
    }

    @Override
    @NotNull
    public AsyncPromise<T> onProcessed(@NotNull Consumer<? super T> processed2) {
        Intrinsics.checkNotNullParameter(processed2, "processed");
        return new AsyncPromise<Object>(this.whenComplete((arg_0, arg_1) -> AsyncPromise.onProcessed$lambda$5(processed2, arg_0, arg_1)), this.hasErrorHandler, true);
    }

    private final CompletableFuture<T> whenComplete(BiConsumer<T, Throwable> action2) {
        CompletableFuture result2 = new CompletableFuture();
        BiConsumer<T, Throwable> captured = Propagation.captureBiConsumerThreadContext(action2);
        this.f.handle((arg_0, arg_1) -> AsyncPromise.whenComplete$lambda$6(new Function2<T, Throwable, T>(captured, result2){
            final /* synthetic */ BiConsumer<T, Throwable> $captured;
            final /* synthetic */ CompletableFuture<T> $result;
            {
                this.$captured = $captured;
                this.$result = $result;
                super(2);
            }

            public final T invoke(T value, Throwable error) {
                try {
                    this.$captured.accept(value, error);
                    if (error != null) {
                        this.$result.completeExceptionally(error);
                    } else {
                        this.$result.complete(value);
                    }
                }
                catch (Throwable e2) {
                    if (error != null) {
                        ExceptionsKt.addSuppressed(e2, error);
                    }
                    this.$result.completeExceptionally(e2);
                }
                return value;
            }
        }, arg_0, arg_1));
        return result2;
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        try {
            return this.get(timeout, timeUnit);
        }
        catch (ExecutionException e2) {
            Throwable throwable = e2.getCause();
            if (throwable == null) {
                throw e2;
            }
            Throwable cause = throwable;
            ExceptionUtilRt.rethrowUnchecked(cause);
            throw e2;
        }
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done) {
        Intrinsics.checkNotNullParameter(done, "done");
        AsyncPromise this_$iv = this;
        boolean $i$f$wrapWithCancellationPropagation = false;
        ChildContext childContext = Propagation.createChildContext();
        CoroutineContext childContext$iv = childContext.component1();
        Continuation<Unit> childContinuation$iv = childContext.component2();
        CoroutineContext ctx = childContext$iv;
        boolean bl2 = false;
        CompletionStage completionStage = this.f.thenApply(arg_0 -> AsyncPromise.then$lambda$8$lambda$7(new Function1<T, SUB_RESULT>(ctx, done){
            final /* synthetic */ CoroutineContext $ctx;
            final /* synthetic */ Function<? super T, ? extends SUB_RESULT> $done;
            {
                this.$ctx = $ctx;
                this.$done = $done;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final SUB_RESULT invoke(T t2) {
                SUB_RESULT SUB_RESULT;
                AutoCloseable autoCloseable = ThreadContext.installThreadContext(this.$ctx, true);
                Function<T, SUB_RESULT> function = this.$done;
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl2 = false;
                    SUB_RESULT = function.fun(t2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                return SUB_RESULT;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        CompletionStage capturingFuture$iv = completionStage;
        Function2 function2 = new Function2<T, Throwable, Unit>(childContinuation$iv){
            final /* synthetic */ Continuation<Unit> $childContinuation;
            {
                this.$childContinuation = $childContinuation;
                super(2);
            }

            public final void invoke(T t2, Throwable result2) {
                block1: {
                    block3: {
                        Throwable cause;
                        block5: {
                            block4: {
                                Throwable throwable;
                                block2: {
                                    block0: {
                                        throwable = result2;
                                        if (throwable != null) break block0;
                                        Continuation<Unit> continuation = this.$childContinuation;
                                        if (continuation == null) break block1;
                                        continuation.resumeWith(Result.constructor-impl(Unit.INSTANCE));
                                        break block1;
                                    }
                                    if (!(throwable instanceof ProcessCanceledException)) break block2;
                                    Continuation<Unit> continuation = this.$childContinuation;
                                    if (continuation == null) break block1;
                                    continuation.resumeWith(Result.constructor-impl(ResultKt.createFailure(new CancellationException())));
                                    break block1;
                                }
                                if (!(throwable instanceof CompletionException)) break block3;
                                cause = result2.getCause();
                                if (!(cause instanceof CancellationException)) break block4;
                                Continuation<Unit> continuation = this.$childContinuation;
                                if (continuation == null) break block1;
                                continuation.resumeWith(Result.constructor-impl(ResultKt.createFailure(cause)));
                                break block1;
                            }
                            if (cause != null) break block5;
                            Continuation<Unit> continuation = this.$childContinuation;
                            if (continuation == null) break block1;
                            continuation.resumeWith(Result.constructor-impl(Unit.INSTANCE));
                            break block1;
                        }
                        Continuation<Unit> continuation = this.$childContinuation;
                        if (continuation == null) break block1;
                        continuation.resumeWith(Result.constructor-impl(ResultKt.createFailure(cause)));
                        break block1;
                    }
                    Continuation<Unit> continuation = this.$childContinuation;
                    if (continuation == null) break block1;
                    Intrinsics.checkNotNull(result2);
                    continuation.resumeWith(Result.constructor-impl(ResultKt.createFailure(result2)));
                }
            }
        };
        CompletionStage completionStage2 = ((CompletableFuture)capturingFuture$iv).whenComplete(new BiConsumer(function2){
            private final /* synthetic */ Function2 function;
            {
                Intrinsics.checkNotNullParameter(function, "function");
                this.function = function;
            }

            public final /* synthetic */ void accept(Object p0, Object p1) {
                this.function.invoke(p0, p1);
            }
        });
        Intrinsics.checkNotNullExpressionValue(completionStage2, "whenComplete(...)");
        boolean bl3 = true;
        AtomicBoolean atomicBoolean = this.hasErrorHandler;
        CompletionStage completionStage3 = completionStage2;
        return new AsyncPromise<T>(completionStage3, atomicBoolean, bl3);
    }

    private final <T> CompletableFuture<T> wrapWithCancellationPropagation(Function1<? super CoroutineContext, ? extends CompletableFuture<T>> producer) {
        boolean $i$f$wrapWithCancellationPropagation = false;
        ChildContext childContext = Propagation.createChildContext();
        CoroutineContext childContext2 = childContext.component1();
        Continuation<Unit> childContinuation2 = childContext.component2();
        CompletableFuture<T> capturingFuture = producer.invoke(childContext2);
        Function2 function2 = new /* invalid duplicate definition of identical inner class */;
        CompletionStage completionStage = capturingFuture.whenComplete(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue(completionStage, "whenComplete(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, ? extends Promise<SUB_RESULT>> doneF) {
        Intrinsics.checkNotNullParameter(doneF, "doneF");
        CompletionStage completionStage = this.f.thenCompose(arg_0 -> AsyncPromise.thenAsync$lambda$9(new Function1<T, CompletionStage<SUB_RESULT>>(doneF){
            final /* synthetic */ Function<? super T, ? extends Promise<SUB_RESULT>> $doneF;
            {
                this.$doneF = $doneF;
                super(1);
            }

            public final CompletionStage<SUB_RESULT> invoke(T it) {
                Promise<SUB_RESULT> promise = this.$doneF.fun(it);
                CompletableFuture<T> future2 = new CompletableFuture<T>();
                promise.onSuccess(arg_0 -> thenAsync.1.invoke$lambda$0(new Function1<SUB_RESULT, Unit>(future2){
                    final /* synthetic */ CompletableFuture<SUB_RESULT> $future;
                    {
                        this.$future = $future;
                        super(1);
                    }

                    public final void invoke(SUB_RESULT value) {
                        this.$future.complete(value);
                    }
                }, arg_0)).onError(arg_0 -> thenAsync.1.invoke$lambda$1(new Function1<Throwable, Unit>(future2){
                    final /* synthetic */ CompletableFuture<SUB_RESULT> $future;
                    {
                        this.$future = $future;
                        super(1);
                    }

                    public final void invoke(Throwable error) {
                        this.$future.completeExceptionally(error);
                    }
                }, arg_0));
                return future2;
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenCompose(...)");
        return new AsyncPromise<T>(completionStage, this.hasErrorHandler, true);
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        Intrinsics.checkNotNullParameter(child, "child");
        if (!(child instanceof AsyncPromise)) {
            return this;
        }
        return ((AsyncPromise)this.onSuccess(arg_0 -> AsyncPromise.processed$lambda$10(new Function1<T, Unit>(child){
            final /* synthetic */ Promise<? super T> $child;
            {
                this.$child = $child;
                super(1);
            }

            public final void invoke(T it) {
                ((AsyncPromise)this.$child).setResult(it);
            }
        }, arg_0))).onError(arg_0 -> AsyncPromise.processed$lambda$11(new Function1<Throwable, Unit>(child){
            final /* synthetic */ Promise<? super T> $child;
            {
                this.$child = $child;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ((AsyncPromise)this.$child).setError(it);
            }
        }, arg_0));
    }

    @Override
    public void setResult(@Nullable T t2) {
        this.f.complete(t2);
    }

    @Override
    public boolean setError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter(error, "error");
        if (!this.f.completeExceptionally(error)) {
            return false;
        }
        if (this.shouldLogErrors()) {
            Promises.errorIfNotMessage(LOG, error);
        }
        return true;
    }

    protected boolean shouldLogErrors() {
        return !this.hasErrorHandler.get();
    }

    public final boolean setError(@NotNull String error) {
        Intrinsics.checkNotNullParameter(error, "error");
        return this.setError(Promises.createError$default(error, false, 2, null));
    }

    private static final Object _init_$lambda$0(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0, p1);
    }

    private static final void onSuccess$lambda$3(Consumer $handler, Object value, Throwable error) {
        Intrinsics.checkNotNullParameter($handler, "$handler");
        if (error == null && !InternalPromiseUtilKt.isHandlerObsolete($handler)) {
            $handler.accept(value);
        }
    }

    private static final void onError$lambda$4(Consumer $rejected, Object object, Throwable error) {
        Intrinsics.checkNotNullParameter($rejected, "$rejected");
        if (error != null && !InternalPromiseUtilKt.isHandlerObsolete($rejected)) {
            Throwable throwable = error instanceof CompletionException ? (CompletionException)error : null;
            if (throwable == null || (throwable = throwable.getCause()) == null) {
                throwable = error;
            }
            $rejected.accept(throwable);
        }
    }

    private static final void onProcessed$lambda$5(Consumer $processed, Object value, Throwable throwable) {
        Intrinsics.checkNotNullParameter($processed, "$processed");
        if (!InternalPromiseUtilKt.isHandlerObsolete($processed)) {
            $processed.accept(value);
        }
    }

    private static final Object whenComplete$lambda$6(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0, p1);
    }

    private static final Object then$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final CompletionStage thenAsync$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final void processed$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processed$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(AsyncPromise.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
        CANCELED = new CancellationException(){

            @NotNull
            public Throwable fillInStackTrace() {
                return this;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise$Companion;", "", "()V", "CANCELED", "Ljava/util/concurrent/CancellationException;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.concurrency"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

