/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsLoaderBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetSerializer;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsSerializationFormatException;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleClasspathSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationSerializer;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.jps.util.JpsPathUtil;

public final class JpsProjectLoader
extends JpsLoaderBase {
    public static final String MODULE_MANAGER_COMPONENT = "ProjectModuleManager";
    public static final String MODULES_TAG = "modules";
    public static final String MODULE_TAG = "module";
    public static final String FILE_PATH_ATTRIBUTE = "filepath";
    public static final String FILE_URL_ATTRIBUTE = "fileurl";
    public static final String GROUP_ATTRIBUTE = "group";
    public static final String CLASSPATH_ATTRIBUTE = "classpath";
    public static final String CLASSPATH_DIR_ATTRIBUTE = "classpath-dir";
    private static final Logger LOG = Logger.getInstance(JpsProjectLoader.class);
    private final JpsProject myProject;
    private final Map<String, String> myPathVariables;
    private final JpsPathMapper myPathMapper;
    private final boolean myLoadUnloadedModules;

    private JpsProjectLoader(JpsProject project, Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, Path baseDir, boolean loadUnloadedModules) {
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(0);
        }
        super(JpsProjectLoader.createProjectMacroExpander(pathVariables, baseDir));
        this.myProject = project;
        this.myPathVariables = pathVariables;
        this.myPathMapper = pathMapper;
        this.myProject.getContainer().setChild(JpsProjectSerializationDataExtensionImpl.ROLE, new JpsProjectSerializationDataExtensionImpl(baseDir));
        this.myLoadUnloadedModules = loadUnloadedModules;
    }

    private static JpsMacroExpander createProjectMacroExpander(Map<String, String> pathVariables, @NotNull Path baseDir) {
        if (baseDir == null) {
            JpsProjectLoader.$$$reportNull$$$0(1);
        }
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        expander.addFileHierarchyReplacements("PROJECT_DIR", baseDir.toFile());
        return expander;
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, Path projectPath) throws IOException {
        JpsProjectLoader.loadProject(project, pathVariables, JpsPathMapper.IDENTITY, projectPath, false);
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, Path projectPath, boolean loadUnloadedModules) throws IOException {
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(2);
        }
        JpsProjectLoader.loadProject(project, pathVariables, pathMapper, projectPath, DefaultExecutorHolder.threadPool, loadUnloadedModules);
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, Path projectPath, @NotNull Executor executor, boolean loadUnloadedModules) throws IOException {
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(3);
        }
        if (executor == null) {
            JpsProjectLoader.$$$reportNull$$$0(4);
        }
        if (Files.isRegularFile(projectPath, new LinkOption[0]) && projectPath.toString().endsWith(".ipr")) {
            new JpsProjectLoader(project, pathVariables, pathMapper, projectPath.getParent(), loadUnloadedModules).loadFromIpr(projectPath, executor);
        } else {
            Path directory;
            Path dotIdea = projectPath.resolve(".idea");
            if (Files.isDirectory(dotIdea, new LinkOption[0])) {
                directory = dotIdea;
            } else if (Files.isDirectory(projectPath, new LinkOption[0]) && projectPath.endsWith(".idea")) {
                directory = projectPath;
            } else {
                throw new IOException("Cannot find IntelliJ IDEA project files at " + projectPath);
            }
            new JpsProjectLoader(project, pathVariables, pathMapper, directory.getParent(), loadUnloadedModules).loadFromDirectory(directory, executor);
        }
    }

    @NotNull
    public static String getDirectoryBaseProjectName(@NotNull Path dir) {
        String name2;
        if (dir == null) {
            JpsProjectLoader.$$$reportNull$$$0(5);
        }
        String string2 = (name2 = JpsPathUtil.readProjectName(dir)) != null ? name2 : JpsPathUtil.getDefaultProjectName(dir);
        if (string2 == null) {
            JpsProjectLoader.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @Nullable
    protected <E extends JpsElement> Element loadComponentData(@NotNull JpsElementExtensionSerializerBase<E> serializer2, @NotNull Path configFile2) {
        if (serializer2 == null) {
            JpsProjectLoader.$$$reportNull$$$0(7);
        }
        if (configFile2 == null) {
            JpsProjectLoader.$$$reportNull$$$0(8);
        }
        Path externalConfigDir = JpsProjectLoader.resolveExternalProjectConfig("project");
        Element data = super.loadComponentData(serializer2, configFile2);
        String componentName = serializer2.getComponentName();
        if (externalConfigDir == null || !componentName.equals("CompilerConfiguration")) {
            return data;
        }
        String prefixedComponentName = "External" + componentName;
        Element externalData = null;
        for (Element child : JDOMUtil.getChildren(this.loadRootElement(externalConfigDir.resolve(configFile2.getFileName())))) {
            if (!child.getName().equals(prefixedComponentName) && !JDomSerializationUtil.isComponent(prefixedComponentName, child) && !child.getName().equals(componentName) && !JDomSerializationUtil.isComponent(componentName, child)) continue;
            externalData = child;
            break;
        }
        return JpsProjectLoader.deepMergeCompilerConfigurations(data, externalData);
    }

    @Nullable
    private static Element deepMergeCompilerConfigurations(@Nullable Element data, @Nullable Element externalData) {
        if (data == null) {
            return externalData;
        }
        if (externalData == null) {
            return data;
        }
        JDOMUtil.deepMerge(data, externalData);
        JDOMUtil.reduceChildren("bytecodeTargetLevel", data);
        return data;
    }

    private void loadFromDirectory(@NotNull Path dir, @NotNull Executor executor) {
        Element externalModuleData;
        if (dir == null) {
            JpsProjectLoader.$$$reportNull$$$0(9);
        }
        if (executor == null) {
            JpsProjectLoader.$$$reportNull$$$0(10);
        }
        this.myProject.setName(JpsProjectLoader.getDirectoryBaseProjectName(dir));
        Path defaultConfigFile = dir.resolve("misc.xml");
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(this.loadRootElement(defaultConfigFile));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                this.loadComponents(dir, defaultConfigFile, jpsProjectExtensionSerializer, this.myProject);
            }
        }
        Path externalConfigDir = JpsProjectLoader.resolveExternalProjectConfig("project");
        if (externalConfigDir != null) {
            LOG.info("External project config dir is used: " + externalConfigDir);
        }
        Element moduleData = JDomSerializationUtil.findComponent(this.loadRootElement(dir.resolve("modules.xml")), MODULE_MANAGER_COMPONENT);
        if (externalConfigDir == null) {
            externalModuleData = null;
        } else {
            Element element = this.loadRootElement(externalConfigDir.resolve("modules.xml"));
            if (element == null) {
                externalModuleData = null;
            } else {
                externalModuleData = JDomSerializationUtil.findComponent(element, "ExternalProjectModuleManager");
                if (externalModuleData == null) {
                    externalModuleData = JDomSerializationUtil.findComponent(element, "ExternalModuleListStorage");
                }
                if (externalModuleData == null && element.getName().equals("component")) {
                    externalModuleData = element;
                }
            }
        }
        if (externalModuleData != null) {
            String string2 = externalModuleData.getAttributeValue("name");
            LOG.assertTrue(string2 != null && string2.startsWith("External"));
            externalModuleData.setAttribute("name", string2.substring("External".length()));
            if (moduleData == null) {
                moduleData = externalModuleData;
            } else {
                JDOMUtil.deepMerge(moduleData, externalModuleData);
            }
        }
        Path path = dir.resolve("workspace.xml");
        this.loadModules(moduleData, projectSdkType, path, executor);
        Runnable timingLog = TimingLog.startActivity("loading project libraries");
        for (Path path2 : JpsProjectLoader.listXmlFiles(dir.resolve("libraries"))) {
            this.loadProjectLibraries(this.loadRootElement(path2));
        }
        if (externalConfigDir != null) {
            this.loadProjectLibraries(this.loadRootElement(externalConfigDir.resolve("libraries.xml")));
        }
        timingLog.run();
        Runnable artifactsTimingLog = TimingLog.startActivity("loading artifacts");
        for (Path artifactFile : JpsProjectLoader.listXmlFiles(dir.resolve("artifacts"))) {
            this.loadArtifacts(this.loadRootElement(artifactFile));
        }
        if (externalConfigDir != null) {
            this.loadArtifacts(this.loadRootElement(externalConfigDir.resolve("artifacts.xml")));
        }
        artifactsTimingLog.run();
        if (JpsProjectLoader.hasRunConfigurationSerializers()) {
            Runnable runnable = TimingLog.startActivity("loading run configurations");
            for (Path configurationFile : JpsProjectLoader.listXmlFiles(dir.resolve("runConfigurations"))) {
                JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, this.loadRootElement(configurationFile));
            }
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(this.loadRootElement(path), "RunManager"));
            runnable.run();
        }
    }

    private static boolean hasRunConfigurationSerializers() {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            if (extension.getRunConfigurationPropertiesSerializers().isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<Path> listXmlFiles(@NotNull Path dir) {
        List<Path> list2;
        DirectoryStream<Path> stream;
        block11: {
            if (dir == null) {
                JpsProjectLoader.$$$reportNull$$$0(11);
            }
            stream = Files.newDirectoryStream(dir, it -> it.getFileName().toString().endsWith(".xml") && Files.isRegularFile(it, new LinkOption[0]));
            list2 = ContainerUtil.collect(stream.iterator());
            if (stream == null) break block11;
            stream.close();
        }
        List<Path> list3 = list2;
        if (list3 == null) {
            JpsProjectLoader.$$$reportNull$$$0(12);
        }
        return list3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    List<Path> list4 = Collections.emptyList();
                    if (list4 == null) {
                        JpsProjectLoader.$$$reportNull$$$0(13);
                    }
                    return list4;
                }
            }
        }
    }

    private void loadFromIpr(@NotNull Path iprFile, @NotNull Executor executor) {
        if (iprFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(14);
        }
        if (executor == null) {
            JpsProjectLoader.$$$reportNull$$$0(15);
        }
        Element iprRoot = this.loadRootElement(iprFile);
        String projectName = FileUtilRt.getNameWithoutExtension(iprFile.getFileName().toString());
        this.myProject.setName(projectName);
        Path iwsFile = iprFile.getParent().resolve(projectName + ".iws");
        Element iwsRoot = this.loadRootElement(iwsFile);
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(iprRoot);
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                Element rootTag = "workspace.xml".equals(jpsProjectExtensionSerializer.getConfigFileName()) ? iwsRoot : iprRoot;
                Element component = JDomSerializationUtil.findComponent(rootTag, jpsProjectExtensionSerializer.getComponentName());
                if (component != null) {
                    jpsProjectExtensionSerializer.loadExtension(this.myProject, component);
                    continue;
                }
                jpsProjectExtensionSerializer.loadExtensionWithDefaultSettings(this.myProject);
            }
        }
        this.loadModules(JDomSerializationUtil.findComponent(iprRoot, MODULE_MANAGER_COMPONENT), projectSdkType, iwsFile, executor);
        this.loadProjectLibraries(JDomSerializationUtil.findComponent(iprRoot, "libraryTable"));
        this.loadArtifacts(JDomSerializationUtil.findComponent(iprRoot, "ArtifactManager"));
        if (JpsProjectLoader.hasRunConfigurationSerializers()) {
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(iprRoot, "ProjectRunConfigurationManager"));
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(iwsRoot, "RunManager"));
        }
    }

    private void loadArtifacts(@Nullable Element artifactManagerComponent) {
        JpsArtifactSerializer.loadArtifacts(this.myProject, artifactManagerComponent);
    }

    @Nullable
    private JpsSdkType<?> loadProjectRoot(@Nullable Element root) {
        JpsSdkType<?> sdkType = null;
        Element rootManagerElement = JDomSerializationUtil.findComponent(root, "ProjectRootManager");
        if (rootManagerElement != null) {
            String sdkName = rootManagerElement.getAttributeValue("project-jdk-name");
            String sdkTypeId = rootManagerElement.getAttributeValue("project-jdk-type");
            if (sdkName != null) {
                sdkType = JpsSdkTableSerializer.getSdkType(sdkTypeId);
                JpsSdkTableSerializer.setSdkReference(this.myProject.getSdkReferencesTable(), sdkName, sdkType);
            }
        }
        return sdkType;
    }

    private void loadProjectLibraries(@Nullable Element libraryTableElement) {
        JpsLibraryTableSerializer.loadLibraries(libraryTableElement, this.myPathMapper, this.myProject.getLibraryCollection());
    }

    private void loadModules(@Nullable Element componentElement, @Nullable JpsSdkType<?> projectSdkType, @NotNull Path workspaceFile, @NotNull Executor executor) {
        if (workspaceFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(16);
        }
        if (executor == null) {
            JpsProjectLoader.$$$reportNull$$$0(17);
        }
        Runnable timingLog = TimingLog.startActivity("loading modules");
        if (componentElement == null) {
            return;
        }
        HashSet<String> unloadedModules = new HashSet<String>();
        if (!this.myLoadUnloadedModules && workspaceFile.toFile().exists()) {
            Element unloadedModulesList = JDomSerializationUtil.findComponent(this.loadRootElement(workspaceFile), "UnloadedModulesList");
            for (Element element : JDOMUtil.getChildren(unloadedModulesList, MODULE_TAG)) {
                unloadedModules.add(element.getAttributeValue("name"));
            }
        }
        Set foundFiles = CollectionFactory.createSmallMemoryFootprintSet();
        ArrayList<Path> moduleFiles = new ArrayList<Path>();
        for (Element moduleElement : JDOMUtil.getChildren(componentElement.getChild(MODULES_TAG), MODULE_TAG)) {
            Path file2;
            String path = moduleElement.getAttributeValue(FILE_PATH_ATTRIBUTE);
            if (path == null || !foundFiles.add(file2 = Path.of(path, new String[0])) || unloadedModules.contains(JpsProjectLoader.getModuleName(file2))) continue;
            moduleFiles.add(file2);
        }
        List<JpsModule> list2 = JpsProjectLoader.loadModules(moduleFiles, projectSdkType, this.myPathVariables, this.myPathMapper, executor);
        for (JpsModule module : list2) {
            this.myProject.addModule(module);
        }
        timingLog.run();
    }

    @Nullable
    private static Path resolveExternalProjectConfig(@NotNull String subDirName) {
        String externalProjectConfigDir;
        if (subDirName == null) {
            JpsProjectLoader.$$$reportNull$$$0(18);
        }
        return (externalProjectConfigDir = System.getProperty("external.project.config")) == null || externalProjectConfigDir.isBlank() ? null : Path.of(externalProjectConfigDir, subDirName);
    }

    @NotNull
    public static List<JpsModule> loadModules(@NotNull List<? extends Path> moduleFiles, @Nullable JpsSdkType<?> projectSdkType, @NotNull Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, @Nullable Executor executor) {
        ArrayList<JpsModule> arrayList;
        if (moduleFiles == null) {
            JpsProjectLoader.$$$reportNull$$$0(19);
        }
        if (pathVariables == null) {
            JpsProjectLoader.$$$reportNull$$$0(20);
        }
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(21);
        }
        if (executor == null) {
            executor = DefaultExecutorHolder.threadPool;
        }
        ArrayList<JpsModule> modules = new ArrayList<JpsModule>();
        ArrayList<CompletableFuture<Pair>> futureModuleFilesContents = new ArrayList<CompletableFuture<Pair>>();
        Path externalModuleDir = JpsProjectLoader.resolveExternalProjectConfig(MODULES_TAG);
        if (externalModuleDir != null) {
            LOG.info("External project config dir is used for modules: " + externalModuleDir);
        }
        for (Path path : moduleFiles) {
            futureModuleFilesContents.add(CompletableFuture.supplyAsync(() -> {
                String externalName;
                Element externalData;
                JpsMacroExpander expander = JpsProjectLoader.createModuleMacroExpander(pathVariables, path);
                Element data = JpsProjectLoader.loadRootElement(path, expander);
                if (externalModuleDir != null && (externalData = JpsProjectLoader.loadRootElement(externalModuleDir.resolve(externalName = FileUtilRt.getNameWithoutExtension(path.getFileName().toString()) + ".xml"), expander)) != null) {
                    if (data == null) {
                        data = externalData;
                    } else {
                        JDOMUtil.deepMergeWithAttributes(data, externalData, List.of(new JDOMUtil.MergeAttribute("content", "url"), new JDOMUtil.MergeAttribute("component", "name")));
                    }
                }
                if (data == null) {
                    LOG.info("Module '" + JpsProjectLoader.getModuleName(path) + "' is skipped: " + path.toAbsolutePath() + " doesn't exist");
                } else {
                    List<Element> components = data.getChildren("component");
                    Element rootManager = null;
                    Element additionalElements = null;
                    for (Element component : components) {
                        String attributeValue = component.getAttributeValue("name");
                        if (attributeValue.equals("NewModuleRootManager")) {
                            rootManager = component;
                        }
                        if (attributeValue.equals("AdditionalModuleElements")) {
                            additionalElements = component;
                        }
                        if (rootManager == null || additionalElements == null) continue;
                        break;
                    }
                    if (rootManager != null && additionalElements != null) {
                        additionalElements.removeAttribute("name");
                        additionalElements.getChildren().forEach(o2 -> o2.removeAttribute("dumb"));
                        JDOMUtil.deepMerge(rootManager, additionalElements);
                    }
                }
                return new Pair<Path, Element>(path, data);
            }, executor));
        }
        try {
            ArrayList<String> classpathDirs = new ArrayList<String>();
            for (CompletableFuture completableFuture : futureModuleFilesContents) {
                String classpathDir;
                Element element = (Element)((Pair)completableFuture.join()).getSecond();
                if (element == null || (classpathDir = element.getAttributeValue(CLASSPATH_DIR_ATTRIBUTE)) == null) continue;
                classpathDirs.add(classpathDir);
            }
            ArrayList<CompletableFuture<JpsModule>> arrayList2 = new ArrayList<CompletableFuture<JpsModule>>();
            for (CompletableFuture completableFuture : futureModuleFilesContents) {
                Pair moduleFile = (Pair)completableFuture.join();
                if (moduleFile.getSecond() == null) continue;
                arrayList2.add(CompletableFuture.supplyAsync(() -> JpsProjectLoader.loadModule((Path)moduleFile.getFirst(), (Element)moduleFile.getSecond(), classpathDirs, projectSdkType, pathVariables, pathMapper), executor));
            }
            for (CompletableFuture completableFuture : arrayList2) {
                JpsModule module = (JpsModule)completableFuture.join();
                if (module == null) continue;
                modules.add(module);
            }
            arrayList = modules;
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
        if (arrayList == null) {
            JpsProjectLoader.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private static JpsModule loadModule(@NotNull Path file2, @NotNull Element moduleRoot, List<String> paths2, @Nullable JpsSdkType<?> projectSdkType, Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper) {
        if (file2 == null) {
            JpsProjectLoader.$$$reportNull$$$0(23);
        }
        if (moduleRoot == null) {
            JpsProjectLoader.$$$reportNull$$$0(24);
        }
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(25);
        }
        String name2 = JpsProjectLoader.getModuleName(file2);
        String typeId = moduleRoot.getAttributeValue("type");
        JpsModulePropertiesSerializer<?> serializer2 = JpsProjectLoader.getModulePropertiesSerializer(typeId);
        JpsModule module = JpsProjectLoader.createModule(name2, moduleRoot, serializer2);
        module.getContainer().setChild(JpsModuleSerializationDataExtensionImpl.ROLE, new JpsModuleSerializationDataExtensionImpl(file2.getParent()));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadModuleOptions(module, moduleRoot);
        }
        String baseModulePath = FileUtilRt.toSystemIndependentName(file2.getParent().toString());
        String classpath = moduleRoot.getAttributeValue(CLASSPATH_ATTRIBUTE);
        if (classpath == null) {
            try {
                JpsModuleRootModelSerializer.loadRootModel(module, JDomSerializationUtil.findComponent(moduleRoot, "NewModuleRootManager"), projectSdkType, pathMapper);
            }
            catch (JpsSerializationFormatException e2) {
                LOG.warn("Failed to load module configuration from " + file2 + ": " + e2.getMessage(), e2);
            }
        } else {
            for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
                JpsModuleClasspathSerializer classpathSerializer = extension.getClasspathSerializer();
                if (classpathSerializer == null || !classpathSerializer.getClasspathId().equals(classpath)) continue;
                String classpathDir = moduleRoot.getAttributeValue(CLASSPATH_DIR_ATTRIBUTE);
                JpsMacroExpander expander = JpsProjectLoader.createModuleMacroExpander(pathVariables, file2);
                classpathSerializer.loadClasspath(module, classpathDir, baseModulePath, expander, paths2, projectSdkType);
            }
        }
        Element facetsTag = JDomSerializationUtil.findComponent(moduleRoot, "FacetManager");
        Element externalFacetsTag = JDomSerializationUtil.findComponent(moduleRoot, "ExternalFacetManager");
        Element mergedFacetsTag = facetsTag == null ? externalFacetsTag : (externalFacetsTag != null ? JDOMUtil.deepMerge(facetsTag, externalFacetsTag) : facetsTag);
        JpsFacetSerializer.loadFacets(module, mergedFacetsTag);
        JpsModule jpsModule = module;
        if (jpsModule == null) {
            JpsProjectLoader.$$$reportNull$$$0(26);
        }
        return jpsModule;
    }

    @NotNull
    private static String getModuleName(@NotNull Path file2) {
        if (file2 == null) {
            JpsProjectLoader.$$$reportNull$$$0(27);
        }
        String string2 = FileUtilRt.getNameWithoutExtension(file2.getFileName().toString());
        if (string2 == null) {
            JpsProjectLoader.$$$reportNull$$$0(28);
        }
        return string2;
    }

    static JpsMacroExpander createModuleMacroExpander(Map<String, String> pathVariables, @NotNull Path moduleFile) {
        if (moduleFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(29);
        }
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        String moduleDirPath = PathMacroUtil.getModuleDir(moduleFile.toAbsolutePath().toString());
        if (moduleDirPath != null) {
            expander.addFileHierarchyReplacements("MODULE_DIR", new File(FileUtilRt.toSystemDependentName(moduleDirPath)));
        }
        return expander;
    }

    private static <P extends JpsElement> JpsModule createModule(String name2, Element moduleRoot, JpsModulePropertiesSerializer<P> loader2) {
        String componentName = loader2.getComponentName();
        Element component = componentName != null ? JDomSerializationUtil.findComponent(moduleRoot, componentName) : null;
        return JpsElementFactory.getInstance().createModule(name2, (JpsModuleType)loader2.getType(), loader2.loadProperties(component));
    }

    private static JpsModulePropertiesSerializer<?> getModulePropertiesSerializer(@Nullable String typeId) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModulePropertiesSerializer<?> loader2 : extension.getModulePropertiesSerializers()) {
                if (!loader2.getTypeId().equals(typeId)) continue;
                return loader2;
            }
        }
        return new JpsModulePropertiesSerializer<JpsDummyElement>((JpsModuleType)JpsJavaModuleType.INSTANCE, "JAVA_MODULE", null){

            @Override
            public JpsDummyElement loadProperties(@Nullable Element componentElement) {
                return JpsElementFactory.getInstance().createDummyElement();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 22: 
            case 26: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 22: 
            case 26: 
            case 28: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: 
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsProjectLoader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iprFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFiles";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathVariables";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsProjectLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryBaseProjectName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "listXmlFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModules";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createProjectMacroExpander";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryBaseProjectName";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 22: 
            case 26: 
            case 28: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadComponentData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listXmlFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadFromIpr";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadModules";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveExternalProjectConfig";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createModuleMacroExpander";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 22: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DefaultExecutorHolder {
        static final ExecutorService threadPool = AppExecutorUtil.createBoundedApplicationPoolExecutor("JpsProjectLoader Pool", SharedThreadPool.getInstance(), Runtime.getRuntime().availableProcessors());

        private DefaultExecutorHolder() {
        }
    }
}

