/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public final class JpsSerializationManagerImpl
extends JpsSerializationManager {
    @Override
    @NotNull
    public JpsModel loadModel(@NotNull String projectPath, @Nullable String optionsPath, boolean loadUnloadedModules) throws IOException {
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(0);
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        if (optionsPath != null) {
            JpsGlobalLoader.loadGlobalSettings(model.getGlobal(), optionsPath);
        }
        Map<String, String> pathVariables = JpsModelSerializationDataService.computeAllPathVariables(model.getGlobal());
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, model.getGlobal().getPathMapper(), Paths.get(projectPath, new String[0]), loadUnloadedModules);
        JpsModel jpsModel = model;
        if (jpsModel == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(1);
        }
        return jpsModel;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPath, @NotNull Map<String, String> pathVariables) throws IOException {
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(2);
        }
        if (pathVariables == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(3);
        }
        JpsProject jpsProject = this.loadProject(projectPath, pathVariables, false);
        if (jpsProject == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(4);
        }
        return jpsProject;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPath, @NotNull Map<String, String> pathVariables, boolean loadUnloadedModules) throws IOException {
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(5);
        }
        if (pathVariables == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(6);
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, JpsPathMapper.IDENTITY, Paths.get(projectPath, new String[0]), loadUnloadedModules);
        JpsProject jpsProject = model.getProject();
        if (jpsProject == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(7);
        }
        return jpsProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathVariables";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModel";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadModel";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadProject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

