/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.jarRepository;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoriesConfiguration;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryService;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public final class JpsRemoteRepositoriesConfigurationSerializer
extends JpsProjectExtensionSerializer {
    private static final String ELEMENT_TAG = "remote-repository";
    private static final String OPTION_TAG = "option";
    private static final String ID_PROPERTY = "id";
    private static final String NAME_PROPERTY = "name";
    private static final String URL_PROPERTY = "url";

    public JpsRemoteRepositoriesConfigurationSerializer() {
        super("jarRepositories.xml", "RemoteRepositoriesConfiguration");
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            JpsRemoteRepositoriesConfigurationSerializer.$$$reportNull$$$0(0);
        }
        if (componentTag == null) {
            JpsRemoteRepositoriesConfigurationSerializer.$$$reportNull$$$0(1);
        }
        ArrayList<JpsRemoteRepositoryDescription> result2 = new ArrayList<JpsRemoteRepositoryDescription>();
        List<Element> children2 = componentTag.getChildren(ELEMENT_TAG);
        for (Element repoElement : children2) {
            String id2 = null;
            String name2 = null;
            String url = null;
            for (Element element : repoElement.getChildren(OPTION_TAG)) {
                String option = element.getAttributeValue(NAME_PROPERTY);
                String optionValue = element.getAttributeValue("value");
                if (ID_PROPERTY.equals(option)) {
                    id2 = optionValue;
                    continue;
                }
                if (NAME_PROPERTY.equals(option)) {
                    name2 = optionValue == null ? "" : optionValue;
                    continue;
                }
                if (!URL_PROPERTY.equals(option)) continue;
                url = optionValue;
            }
            if (id2 == null || url == null) continue;
            result2.add(new JpsRemoteRepositoryDescription(id2, name2, url));
        }
        JpsRemoteRepositoriesConfiguration config = JpsRemoteRepositoryService.getInstance().getOrCreateRemoteRepositoriesConfiguration(project);
        if (!result2.isEmpty()) {
            config.setRepositories(result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "componentTag";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/model/serialization/jarRepository/JpsRemoteRepositoriesConfigurationSerializer";
        objectArray[2] = "loadExtension";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

